/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.PolygonPolygonAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PolygonNotOverlappingPolygonValidation
extends PolygonPolygonAbstractValidation {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    boolean expected = true;

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getPolygonTypeRef();
        LOGGER.finer(String.valueOf(typeRef1) + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource polySource1 = (SimpleFeatureSource)layers.get(typeRef1);
        LOGGER.finer(String.valueOf(typeRef1) + ": found " + ((SimpleFeatureType)polySource1.getSchema()).getTypeName());
        SimpleFeatureCollection collection1 = polySource1.getFeatures();
        Object[] poly1 = collection1.toArray();
        String typeRef2 = this.getRestrictedPolygonTypeRef();
        LOGGER.finer(String.valueOf(typeRef2) + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource polySource2 = (SimpleFeatureSource)layers.get(typeRef2);
        LOGGER.finer(String.valueOf(typeRef2) + ": found " + ((SimpleFeatureType)polySource2.getSchema()).getTypeName());
        SimpleFeatureCollection collection2 = polySource2.getFeatures();
        Object[] poly2 = collection2.toArray();
        boolean success = true;
        int i = 0;
        while (i < poly1.length) {
            SimpleFeature tmp = (SimpleFeature)poly1[i];
            LOGGER.finest("Polgon overlap test for:" + tmp.getID());
            Geometry gt = (Geometry)tmp.getDefaultGeometry();
            int j = 0;
            while (j < poly2.length) {
                SimpleFeature tmp2 = (SimpleFeature)poly2[j];
                LOGGER.finest("Polgon overlap test against:" + tmp2.getID());
                Geometry gt2 = (Geometry)tmp2.getDefaultGeometry();
                if (gt2.overlaps(gt) != this.expected) {
                    results.error(tmp, "Polygon " + typeRef1 + " overlapped Polygon " + typeRef2 + "(" + tmp2.getID() + ") was not " + this.expected);
                    success = false;
                }
                ++j;
            }
            ++i;
        }
        return success;
    }
}

