/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.validation.dto.ArgumentDTO;
import org.geotools.validation.dto.PlugInDTO;
import org.geotools.validation.dto.TestDTO;
import org.geotools.validation.dto.TestSuiteDTO;
import org.geotools.validation.xml.ArgHelper;
import org.geotools.validation.xml.ReaderUtils;
import org.geotools.validation.xml.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLReader {
    private XMLReader() {
    }

    public static PlugInDTO readPlugIn(Reader inputSource) throws ValidationException {
        PlugInDTO dto;
        block14: {
            dto = new PlugInDTO();
            try {
                Element elem = null;
                try {
                    elem = ReaderUtils.loadConfig(inputSource);
                }
                catch (ParserConfigurationException pce) {
                    throw new ValidationException("Cannot parse the inputSource: Cannot configure the parser.", pce);
                }
                catch (SAXException se) {
                    throw new ValidationException("Cannot parse the inputSource: Cannot configure the parser.", se);
                }
                try {
                    dto.setName(ReaderUtils.getElementText(ReaderUtils.getChildElement(elem, "name", true), true));
                }
                catch (SAXException e) {
                    throw new ValidationException("Error parsing name for this plugin", e);
                }
                try {
                    dto.setDescription(ReaderUtils.getElementText(ReaderUtils.getChildElement(elem, "description", true), true));
                }
                catch (SAXException e) {
                    throw new ValidationException("Error parsing description for the " + dto.getName() + " plugin", e);
                }
                try {
                    dto.setClassName(ReaderUtils.getElementText(ReaderUtils.getChildElement(elem, "class", true), true));
                }
                catch (SAXException e) {
                    throw new ValidationException("Error parsing class for the " + dto.getName() + " plugin", e);
                }
                NodeList nl = elem.getElementsByTagName("argument");
                if (nl == null) break block14;
                HashMap<String, ArgumentDTO> m = new HashMap<String, ArgumentDTO>();
                dto.setArgs(m);
                int i = 0;
                while (i < nl.getLength()) {
                    elem = (Element)nl.item(i);
                    ArgumentDTO adto = null;
                    try {
                        adto = XMLReader.loadArg(elem, dto);
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    m.put(adto.getName(), adto);
                    ++i;
                }
            }
            catch (IOException ioe) {
                throw new ValidationException("Cannot parse the inputSource: Cannot configure the parser.", ioe);
            }
        }
        return dto;
    }

    public static TestSuiteDTO readTestSuite(String name, Reader inputSource, Map plugIns) throws ValidationException {
        TestSuiteDTO dto = new TestSuiteDTO();
        try {
            Element elem = null;
            try {
                elem = ReaderUtils.loadConfig(inputSource);
            }
            catch (ParserConfigurationException e) {
                throw new ValidationException("Problem parsing " + name + ":" + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new ValidationException("XML problem with  " + name + ":" + e.getMessage(), e);
            }
            try {
                dto.setName(ReaderUtils.getChildText(elem, "name", true));
            }
            catch (SAXException e) {
                throw new ValidationException("Error loading test suite name", e);
            }
            try {
                dto.setDescription(ReaderUtils.getChildText(elem, "description", true));
            }
            catch (SAXException e) {
                throw new ValidationException("Error loading test suite description", e);
            }
            HashMap<String, TestDTO> l = new HashMap<String, TestDTO>();
            dto.setTests(l);
            NodeList nl = elem.getElementsByTagName("test");
            if (nl == null || nl.getLength() == 0) {
                throw new ValidationException("The test suite loader has detected an error: no tests provided.");
            }
            int i = 0;
            while (i < nl.getLength()) {
                try {
                    TestDTO t = XMLReader.loadTestDTO((Element)nl.item(i), plugIns);
                    l.put(t.getName(), t);
                }
                catch (ValidationException e) {
                    throw new ValidationException("An error occured loading a test in " + dto.getName() + " test suite.", e);
                }
                catch (Throwable t) {
                    throw new ValidationException("Could not load test suite " + dto.getName() + ":" + t.getMessage(), t);
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ValidationException("An error occured loading the " + dto.getName() + "test suite", e);
        }
        return dto;
    }

    private static TestDTO loadTestDTO(Element elem, Map plugIns) throws ValidationException {
        TestDTO dto = new TestDTO();
        try {
            dto.setName(ReaderUtils.getChildText(elem, "name", true));
        }
        catch (SAXException e) {
            throw new ValidationException("Error reading the name for this test case.", e);
        }
        try {
            dto.setDescription(ReaderUtils.getChildText(elem, "description", false));
        }
        catch (SAXException e) {
            throw new ValidationException("Error reading the description for the " + dto.getName() + " test case.", e);
        }
        try {
            String pluginName = ReaderUtils.getChildText(elem, "plugin", true);
            dto.setPlugIn((PlugInDTO)plugIns.get(pluginName));
            if (dto.getPlugIn() == null) {
                throw new NullPointerException("Error - should have a plugin at " + elem);
            }
        }
        catch (SAXException e) {
            throw new ValidationException("Error reading the plugin for the " + dto.getName() + " test case.", e);
        }
        NodeList nl = elem.getElementsByTagName("argument");
        if (nl != null) {
            HashMap<String, ArgumentDTO> m = new HashMap<String, ArgumentDTO>();
            dto.setArgs(m);
            int i = 0;
            while (i < nl.getLength()) {
                elem = (Element)nl.item(i);
                ArgumentDTO adto = null;
                try {
                    adto = XMLReader.loadArg(elem, dto.getPlugIn());
                }
                catch (ValidationException e) {
                    e.printStackTrace();
                }
                if (adto == null || !adto.isFinal()) {
                    m.put(adto.getName(), adto);
                }
                ++i;
            }
        }
        return dto;
    }

    private static ArgumentDTO loadArg(Element elem, PlugInDTO dto) throws ValidationException {
        String key = "";
        boolean _fixed = false;
        try {
            _fixed = ReaderUtils.getBooleanAttribute(elem, "final", false);
            key = ReaderUtils.getChildText(elem, "name", true);
        }
        catch (SAXException e) {
            throw new ValidationException("Error reading argument for " + dto.getName() + " :name required");
        }
        NodeList nl2 = elem.getChildNodes();
        Element value = null;
        int j = 0;
        while (j < nl2.getLength()) {
            if (nl2.item(j).getNodeType() == 1) {
                elem = (Element)nl2.item(j);
                value = elem.getTagName().trim().equals("name") ? elem : elem;
            }
            ++j;
        }
        if (value == null) {
            throw new ValidationException("Invalid Argument \"" + dto.getName() + "\" for argument \"" + key + "\"");
        }
        ArgumentDTO adto = (ArgumentDTO)dto.getArgs().get(key);
        Object val = ArgHelper.getArgumentInstance(value.getTagName().trim(), value);
        if (val == null) {
            throw new ValidationException("Didn't find a real value for argument " + key);
        }
        adto = adto == null ? new ArgumentDTO() : (ArgumentDTO)adto.clone();
        adto.setName(key);
        adto.setValue(val);
        adto.setFinal(_fixed);
        return adto;
    }

    public static Map loadPlugIns(File plugInDir) throws ValidationException {
        HashMap<String, PlugInDTO> r = null;
        try {
            plugInDir = ReaderUtils.initFile(plugInDir, true);
            File[] fileList = plugInDir.listFiles();
            r = new HashMap<String, PlugInDTO>();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].canWrite() && fileList[i].isFile()) {
                    FileReader fr = new FileReader(fileList[i]);
                    PlugInDTO dto = XMLReader.readPlugIn(fr);
                    r.put(dto.getName(), dto);
                    fr.close();
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ValidationException("An io error occured while loading the plugin's", e);
        }
        return r;
    }

    public static Map loadValidations(File validationDir, Map plugInDTOs) throws ValidationException {
        HashMap<String, TestSuiteDTO> r = null;
        try {
            validationDir = ReaderUtils.initFile(validationDir, true);
        }
        catch (IOException dirException) {
            throw new ValidationException("Problem opening " + validationDir.getName(), dirException);
        }
        File[] fileList = validationDir.listFiles();
        r = new HashMap<String, TestSuiteDTO>();
        int i = 0;
        while (i < fileList.length) {
            block8: {
                try {
                    if (!fileList[i].canWrite() || !fileList[i].isFile()) break block8;
                    FileReader fr = new FileReader(fileList[i]);
                    try {
                        TestSuiteDTO dto = XMLReader.readTestSuite(fileList[i].getName(), fr, plugInDTOs);
                        r.put(dto.getName(), dto);
                    }
                    finally {
                        fr.close();
                    }
                }
                catch (IOException open) {
                    throw new ValidationException("Could not open " + fileList[i].getName(), open);
                }
            }
            ++i;
        }
        return r;
    }
}

