/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectPositionListTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return GML.DirectPositionListType;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return DirectPosition[].class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        int coordCount;
        int crsDimension = 2;
        Node dimensions = node.getAttribute("srsDimension");
        if (dimensions != null) {
            crsDimension = ((Number)dimensions.getValue()).intValue();
        }
        CoordinateReferenceSystem crs = GML3ParsingUtils.crs(node);
        Double[] values = (Double[])value;
        BigInteger coordinatesCount = (BigInteger)node.getAttributeValue("count");
        if (coordinatesCount == null) {
            coordinatesCount = BigInteger.valueOf(values.length / crsDimension);
        }
        if ((coordCount = coordinatesCount.intValue()) == 0) {
            return new DirectPosition[0];
        }
        int dim = values.length / coordCount;
        if (dim < 1) {
            throw new IllegalArgumentException("dimension must be greater or equal to 1");
        }
        DirectPosition[] dps = new DirectPosition[coordCount];
        if (dim == 1) {
            int i = 0;
            while (i < coordCount) {
                dps[i] = new DirectPosition1D(crs);
                dps[i].setOrdinate(0, values[i].doubleValue());
                ++i;
            }
        } else {
            int ordinateIdx = 0;
            int coordIndex = 0;
            while (coordIndex < coordCount) {
                dps[coordIndex] = new DirectPosition2D(crs);
                dps[coordIndex].setOrdinate(0, values[ordinateIdx].doubleValue());
                dps[coordIndex].setOrdinate(1, values[ordinateIdx + 1].doubleValue());
                ordinateIdx += crsDimension;
                ++coordIndex;
            }
        }
        return dps;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        DirectPosition[] dps = (DirectPosition[])object;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < dps.length) {
            sb.append(String.valueOf(dps[i].getOrdinate(0)) + " " + dps[i].getOrdinate(1));
            if (i < dps.length - 1) {
                sb.append(" ");
            }
            ++i;
        }
        value.appendChild(document.createTextNode(sb.toString()));
        return value;
    }
}

