/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.test.CMSTestUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMECompressedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.test.SMIMETestSetup;
import org.bouncycastle.mail.smime.test.SMIMETestUtil;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEMiscTest
extends TestCase {
    static MimeBodyPart msg;
    static String signDN;
    static KeyPair signKP;
    static X509Certificate signCert;
    static String origDN;
    static KeyPair origKP;
    static X509Certificate origCert;
    static String reciDN;
    static KeyPair reciKP;
    static X509Certificate reciCert;
    KeyPair dsaSignKP;
    X509Certificate dsaSignCert;
    KeyPair dsaOrigKP;
    X509Certificate dsaOrigCert;

    public SMIMEMiscTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        TestRunner.run(SMIMEMiscTest.class);
    }

    public static Test suite() {
        return new SMIMETestSetup((Test)new TestSuite(SMIMEMiscTest.class));
    }

    public void testSHA256WithRSAParserEncryptedWithAES() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        SMIMEEnvelopedGenerator encGen = new SMIMEEnvelopedGenerator();
        encGen.addKeyTransRecipient(origCert);
        MimeBodyPart mp = encGen.generate(msg, SMIMEEnvelopedGenerator.AES128_CBC, "BC");
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(origKP.getPrivate(), origCert, SMIMESignedGenerator.DIGEST_SHA256, new AttributeTable(signedAttrs), null);
        gen.addCertificatesAndCRLs(certs);
        MimeMultipart smm = gen.generate(mp, "BC");
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESignedParser s = new SMIMESignedParser((MimeMultipart)msg.getContent());
        certs = s.getCertificatesAndCRLs("Collection", "BC");
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners(certs, s.getSignerInfos());
        tmpFile.delete();
    }

    public void testSHA256WithRSACompressed() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        SMIMECompressedGenerator cGen = new SMIMECompressedGenerator();
        MimeBodyPart mp = cGen.generate(msg, "1.2.840.113549.1.9.16.3.8");
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(origKP.getPrivate(), origCert, SMIMESignedGenerator.DIGEST_SHA256, new AttributeTable(signedAttrs), null);
        gen.addCertificatesAndCRLs(certs);
        MimeMultipart smm = gen.generate(mp, "BC");
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESigned s = new SMIMESigned((MimeMultipart)msg.getContent());
        certs = s.getCertificatesAndCRLs("Collection", "BC");
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners(certs, s.getSignerInfos());
        tmpFile.delete();
    }

    public void testQuotePrintableSigPreservation() throws Exception {
        MimeMessage msg = new MimeMessage((Session)null, ((Object)((Object)this)).getClass().getResourceAsStream("qp-soft-break.eml"));
        SMIMEEnvelopedGenerator encGen = new SMIMEEnvelopedGenerator();
        encGen.addKeyTransRecipient(origCert);
        MimeBodyPart mp = encGen.generate(msg, SMIMEEnvelopedGenerator.AES128_CBC, "BC");
        SMIMEEnveloped env = new SMIMEEnveloped(mp);
        RecipientInformation ri = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        FileBackedMimeBodyPart mm = SMIMEUtil.toMimeBodyPart(ri.getContentStream((Key)origKP.getPrivate(), "BC"));
        SMIMESigned s = new SMIMESigned((MimeMultipart)mm.getContent());
        Collection c = s.getSignerInfos().getSigners();
        Iterator it = c.iterator();
        CertStore certs = s.getCertificatesAndCRLs("Collection", "BC");
        while (it.hasNext()) {
            SignerInformation signer = (SignerInformation)it.next();
            Collection<? extends Certificate> certCollection = certs.getCertificates(signer.getSID());
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            SMIMEMiscTest.assertEquals((boolean)true, (boolean)signer.verify(cert, "BC"));
        }
        mm.dispose();
    }

    public void testSHA256WithRSAParserCompressed() throws Exception {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        SMIMECompressedGenerator cGen = new SMIMECompressedGenerator();
        MimeBodyPart mp = cGen.generate(msg, "1.2.840.113549.1.9.16.3.8");
        ASN1EncodableVector signedAttrs = this.generateSignedAttributes();
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSigner(origKP.getPrivate(), origCert, SMIMESignedGenerator.DIGEST_SHA256, new AttributeTable(signedAttrs), null);
        gen.addCertificatesAndCRLs(certs);
        MimeMultipart smm = gen.generate(mp, "BC");
        File tmpFile = File.createTempFile("bcTest", ".mime");
        MimeMessage msg = this.createMimeMessage(tmpFile, smm);
        SMIMESignedParser s = new SMIMESignedParser((MimeMultipart)msg.getContent());
        certs = s.getCertificatesAndCRLs("Collection", "BC");
        this.verifyMessageBytes(mp, s.getContent());
        this.verifySigners(certs, s.getSignerInfos());
        tmpFile.delete();
    }

    private void verifySigners(CertStore certs, SignerInformationStore signers) throws Exception {
        Collection c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection<? extends Certificate> certCollection = certs.getCertificates(signer.getSID());
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = (X509Certificate)certIt.next();
            SMIMEMiscTest.assertEquals((boolean)true, (boolean)signer.verify(cert, "BC"));
        }
    }

    private void verifyMessageBytes(MimeBodyPart a, MimeBodyPart b) throws Exception {
        ByteArrayOutputStream bOut1 = new ByteArrayOutputStream();
        a.writeTo((OutputStream)bOut1);
        bOut1.close();
        ByteArrayOutputStream bOut2 = new ByteArrayOutputStream();
        b.writeTo((OutputStream)bOut2);
        bOut2.close();
        SMIMEMiscTest.assertEquals((boolean)true, (boolean)Arrays.equals(bOut1.toByteArray(), bOut2.toByteArray()));
    }

    private MimeMessage createMimeMessage(File tmpFile, MimeMultipart smm) throws Exception {
        FileOutputStream fOut = new FileOutputStream(tmpFile);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)fromUser);
        body.setRecipient(Message.RecipientType.TO, (Address)toUser);
        body.setSubject("example signed message");
        body.setContent((Object)smm, smm.getContentType());
        body.saveChanges();
        body.writeTo((OutputStream)fOut);
        fOut.close();
        return new MimeMessage(session, (InputStream)new FileInputStream(tmpFile));
    }

    private ASN1EncodableVector generateSignedAttributes() {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        return signedAttrs;
    }

    static {
        try {
            msg = SMIMETestUtil.makeMimeBodyPart("Hello world!\n");
            signDN = "O=Bouncy Castle, C=AU";
            signKP = CMSTestUtil.makeKeyPair();
            signCert = CMSTestUtil.makeCertificate(signKP, signDN, signKP, signDN);
            origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
            origKP = CMSTestUtil.makeKeyPair();
            origCert = CMSTestUtil.makeCertificate(origKP, origDN, signKP, signDN);
        }
        catch (Exception e) {
            throw new RuntimeException("problem setting up signed test class: " + e);
        }
    }
}

