/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.jboss.as.controller.interfaces.InterfaceCriteria;

public class NotInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = -2037624198837453203L;
    private final Set<InterfaceCriteria> criteria = new HashSet<InterfaceCriteria>();

    public NotInterfaceCriteria(Set<InterfaceCriteria> criteria) {
        if (criteria == null) {
            throw ControllerMessages.MESSAGES.nullVar("criteria");
        }
        this.criteria.addAll(criteria);
    }

    @Override
    public Map<NetworkInterface, Set<InetAddress>> getAcceptableAddresses(Map<NetworkInterface, Set<InetAddress>> candidates) throws SocketException {
        InterfaceCriteria ic;
        Map<NetworkInterface, Set<InetAddress>> testee = AbstractInterfaceCriteria.cloneCandidates(candidates);
        Iterator<InterfaceCriteria> i$ = this.criteria.iterator();
        while (i$.hasNext() && (testee = this.removeMatches(testee, (ic = i$.next()).getAcceptableAddresses(AbstractInterfaceCriteria.cloneCandidates(testee)))).size() != 0) {
        }
        return testee;
    }

    Set<InterfaceCriteria> getAllCriteria() {
        return this.criteria;
    }

    public int hashCode() {
        return ((Object)this.criteria).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NotInterfaceCriteria)) {
            return false;
        }
        return ((Object)this.criteria).equals(((NotInterfaceCriteria)o).criteria);
    }

    private Map<NetworkInterface, Set<InetAddress>> removeMatches(Map<NetworkInterface, Set<InetAddress>> candidates, Map<NetworkInterface, Set<InetAddress>> toRemove) {
        HashMap<NetworkInterface, Set<InetAddress>> result = new HashMap<NetworkInterface, Set<InetAddress>>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : candidates.entrySet()) {
            HashSet retained = new HashSet(entry.getValue());
            Set<InetAddress> badAddresses = toRemove.get(entry.getKey());
            if (badAddresses != null && badAddresses.size() > 0) {
                retained.removeAll(badAddresses);
                if (retained.size() <= 0) continue;
                result.put(entry.getKey(), retained);
                continue;
            }
            result.put(entry.getKey(), retained);
        }
        return result;
    }
}

