/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.dmr.ModelNode;

public class SystemPropertyValueWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    public static final SystemPropertyValueWriteAttributeHandler INSTANCE = new SystemPropertyValueWriteAttributeHandler(null);
    private final ProcessEnvironment processEnvironment;

    public SystemPropertyValueWriteAttributeHandler(ProcessEnvironment processEnvironment) {
        this.processEnvironment = processEnvironment;
    }

    @Override
    protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        boolean reload;
        final String name = PathAddress.pathAddress(operation.get("address")).getLastElement().getValue();
        final String value = newValue.isDefined() ? newValue.asString() : null;
        boolean applyToRuntime = this.processEnvironment != null && this.processEnvironment.isRuntimeSystemPropertyUpdateAllowed(name, value, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String setValue = value == null ? null : context.resolveExpressions(newValue).asString();
                    SecurityActions.setSystemProperty(name, setValue);
                    if (SystemPropertyValueWriteAttributeHandler.this.processEnvironment != null) {
                        SystemPropertyValueWriteAttributeHandler.this.processEnvironment.systemPropertyUpdated(name, setValue);
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        String oldValue;
                        String string = oldValue = currentValue.isDefined() ? context.resolveExpressions(currentValue).asString() : null;
                        if (oldValue != null) {
                            SecurityActions.setSystemProperty(name, oldValue);
                        } else {
                            SecurityActions.clearSystemProperty(name);
                        }
                        if (SystemPropertyValueWriteAttributeHandler.this.processEnvironment != null) {
                            SystemPropertyValueWriteAttributeHandler.this.processEnvironment.systemPropertyUpdated(name, oldValue);
                        }
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
            }
        });
    }
}

