/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.Matcher;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class JsonStringMatcher
extends BodyMatcher<String>
implements Matcher<String> {
    private final String matcher;

    public JsonStringMatcher(String matcher) {
        this.matcher = matcher;
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        JSONCompareResult jsonCompareResult = null;
        try {
            jsonCompareResult = JSONCompare.compareJSON((String)this.matcher, (String)matched, (JSONCompareMode)JSONCompareMode.LENIENT);
            if (jsonCompareResult.passed()) {
                result = true;
            }
            if (!result) {
                this.logger.trace("Failed to perform JSON match [{}] with [{}] because {}", new Object[]{matched, this.matcher, jsonCompareResult.getMessage()});
            }
        }
        catch (Exception e) {
            this.logger.trace("Failed to perform JSON match [{}] with [{}] because {}", new Object[]{matched, this.matcher, e.getMessage()});
        }
        return result;
    }
}

