/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.Times;
import org.mockserver.model.Action;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class Expectation
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final HttpRequest httpRequest;
    private final Times times;
    private final HttpRequestMatcher httpRequestMatcher;
    private HttpResponse httpResponse;
    private HttpForward httpForward;
    private HttpCallback httpCallback;

    public Expectation(HttpRequest httpRequest, Times times) {
        this.httpRequest = httpRequest;
        this.times = times;
        this.httpRequestMatcher = new MatcherBuilder().transformsToMatcher(this.httpRequest);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse(boolean applyDelay) {
        if (this.httpResponse != null) {
            if (applyDelay) {
                return this.httpResponse.applyDelay();
            }
            return this.httpResponse;
        }
        return null;
    }

    public HttpForward getHttpForward() {
        return this.httpForward;
    }

    public HttpCallback getHttpCallback() {
        return this.httpCallback;
    }

    public Action getAction(boolean applyDelay) {
        if (this.httpResponse != null) {
            return this.getHttpResponse(applyDelay);
        }
        if (this.httpForward != null) {
            return this.getHttpForward();
        }
        return this.getHttpCallback();
    }

    public Times getTimes() {
        return this.times;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        if (httpResponse != null) {
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a forward has been set");
            }
            if (this.httpCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a response once a callback has been set");
            }
            this.httpResponse = httpResponse;
        }
        return this;
    }

    public Expectation thenForward(HttpForward httpForward) {
        if (httpForward != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a response has been set");
            }
            if (this.httpCallback != null) {
                throw new IllegalArgumentException("It is not possible to set a forward once a callback has been set");
            }
            this.httpForward = httpForward;
        }
        return this;
    }

    public Expectation thenCallback(HttpCallback httpCallback) {
        if (httpCallback != null) {
            if (this.httpResponse != null) {
                throw new IllegalArgumentException("It is not possible to set a callback once a response has been set");
            }
            if (this.httpForward != null) {
                throw new IllegalArgumentException("It is not possible to set a callback once a forward has been set");
            }
            this.httpCallback = httpCallback;
        }
        return this;
    }

    public boolean matches(HttpRequest httpRequest) {
        this.logger.trace("\nMatching expectation: \n{} \nwith incoming http: \n{}" + System.getProperty("line.separator"), (Object)this.httpRequest, (Object)httpRequest);
        return this.hasRemainingMatches() && this.httpRequestMatcher.matches(httpRequest);
    }

    private boolean hasRemainingMatches() {
        return this.times == null || this.times.greaterThenZero();
    }

    public void decrementRemainingMatches() {
        if (this.times != null) {
            this.times.decrement();
        }
    }

    public void setNotUnlimitedResponses() {
        if (this.times != null) {
            this.times.setNotUnlimitedResponses();
        }
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }
}

