/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.Delay;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.DelayDTO;

public class HttpObjectCallbackDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpObjectCallback> {
    private String clientId;
    private Boolean responseCallback;
    private DelayDTO delay;

    public HttpObjectCallbackDTO(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            this.clientId = httpObjectCallback.getClientId();
            this.responseCallback = httpObjectCallback.getResponseCallback();
            if (httpObjectCallback.getDelay() != null) {
                this.delay = new DelayDTO(httpObjectCallback.getDelay());
            }
        }
    }

    public HttpObjectCallbackDTO() {
    }

    @Override
    public HttpObjectCallback buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpObjectCallback)new HttpObjectCallback().withClientId(this.clientId).withResponseCallback(this.responseCallback).withDelay(delay);
    }

    public String getClientId() {
        return this.clientId;
    }

    public HttpObjectCallbackDTO setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getResponseCallback() {
        return this.responseCallback;
    }

    public HttpObjectCallbackDTO setResponseCallback(Boolean responseCallback) {
        this.responseCallback = responseCallback;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }
}

