/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;

public class JsonBodyDTO
extends BodyWithContentTypeDTO {
    private final String json;
    private final MatchType matchType;
    private final byte[] rawBytes;

    public JsonBodyDTO(JsonBody jsonBody) {
        this(jsonBody, null);
    }

    public JsonBodyDTO(JsonBody jsonBody, Boolean not) {
        super(Body.Type.JSON, not, jsonBody);
        this.json = jsonBody.getValue();
        this.matchType = jsonBody.getMatchType();
        this.rawBytes = jsonBody.getRawBytes();
    }

    public String getJson() {
        return this.json;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Override
    public JsonBody buildObject() {
        return (JsonBody)new JsonBody(this.getJson(), this.getRawBytes(), this.getMediaType(), this.getMatchType()).withOptional(this.getOptional());
    }
}

