/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoException;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AbstractSubscription;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observer;
import java.util.List;

final class MongoIterableSubscription<TResult>
extends AbstractSubscription<TResult> {
    private final MongoIterable<TResult> mongoIterable;
    private boolean isReading;
    private boolean completed;
    private volatile AsyncBatchCursor<TResult> batchCursor;

    MongoIterableSubscription(MongoIterable<TResult> mongoIterable, Observer<? super TResult> observer) {
        super(observer);
        this.mongoIterable = mongoIterable;
        observer.onSubscribe(this);
    }

    @Override
    void requestInitialData() {
        this.mongoIterable.batchSize(this.calculateBatchSize());
        this.mongoIterable.batchCursor(new SingleResultCallback<AsyncBatchCursor<TResult>>(){

            public void onResult(AsyncBatchCursor<TResult> result, Throwable t) {
                if (t != null) {
                    MongoIterableSubscription.this.onError(t);
                } else if (result != null) {
                    MongoIterableSubscription.this.batchCursor = result;
                    MongoIterableSubscription.this.requestMoreData();
                } else {
                    MongoIterableSubscription.this.onError((Throwable)new MongoException("Unexpected error, no AsyncBatchCursor returned from the MongoIterable."));
                }
            }
        });
    }

    @Override
    boolean checkCompleted() {
        return this.completed;
    }

    @Override
    void postTerminate() {
        if (this.batchCursor != null) {
            this.batchCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void requestMoreData() {
        boolean mustRead = false;
        MongoIterableSubscription mongoIterableSubscription = this;
        synchronized (mongoIterableSubscription) {
            if (!this.isReading && !this.isTerminated() && this.batchCursor != null) {
                this.isReading = true;
                mustRead = true;
            }
        }
        if (mustRead) {
            this.batchCursor.setBatchSize(this.calculateBatchSize());
            this.batchCursor.next(new SingleResultCallback<List<TResult>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResult(List<TResult> result, Throwable t) {
                    MongoIterableSubscription mongoIterableSubscription = MongoIterableSubscription.this;
                    synchronized (mongoIterableSubscription) {
                        MongoIterableSubscription.this.isReading = false;
                    }
                    if (t != null) {
                        MongoIterableSubscription.this.onError(t);
                    } else {
                        MongoIterableSubscription.this.addToQueue(result);
                        mongoIterableSubscription = MongoIterableSubscription.this;
                        synchronized (mongoIterableSubscription) {
                            if (result == null) {
                                MongoIterableSubscription.this.completed = true;
                            }
                        }
                        MongoIterableSubscription.this.tryProcessResultsQueue();
                    }
                }
            });
        }
    }

    private int calculateBatchSize() {
        Integer batchSize = this.mongoIterable.getBatchSize();
        if (batchSize != null) {
            return batchSize;
        }
        long requested = this.getRequested();
        if (requested <= 1L) {
            return 2;
        }
        if (requested < Integer.MAX_VALUE) {
            return (int)requested;
        }
        return Integer.MAX_VALUE;
    }
}

