/*
 * Decompiled with CFR 0.152.
 */
package org.scalastyle.maven.plugin;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.scalastyle.Directory;
import org.scalastyle.FileSpec;
import org.scalastyle.Message;
import org.scalastyle.OutputResult;
import org.scalastyle.ScalastyleChecker;
import org.scalastyle.ScalastyleConfiguration;
import org.scalastyle.TextOutput;
import org.scalastyle.XmlOutput;
import scala.Option;
import scala.Option$;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ScalastyleViolationCheckMojo
extends AbstractMojo {
    @Parameter(property="scalastyle.config.location", required=true, defaultValue="default_config.xml")
    private String configLocation;
    @Parameter(property="scalastyle.test.config.location")
    private String testConfigLocation;
    @Parameter(property="scalastyle.output.file")
    private File outputFile;
    @Parameter(property="scalastyle.output.encoding")
    private String outputEncoding;
    @Parameter(property="scalastyle.failOnViolation", defaultValue="true")
    private Boolean failOnViolation = Boolean.TRUE;
    @Parameter(property="scalastyle.failOnWarning", defaultValue="false")
    private Boolean failOnWarning = Boolean.FALSE;
    @Parameter(property="scalastyle.skip", defaultValue="false")
    private Boolean skip = Boolean.FALSE;
    @Parameter(property="scalastyle.verbose", defaultValue="false")
    private Boolean verbose = Boolean.FALSE;
    @Parameter(property="scalastyle.quiet", defaultValue="false")
    private Boolean quiet = Boolean.FALSE;
    @Parameter
    private File sourceDirectory;
    @Parameter
    private File[] sourceDirectories;
    @Parameter
    private File testSourceDirectory;
    @Parameter
    private File[] testSourceDirectories;
    @Parameter(property="scalastyle.includeTestSourceDirectory", defaultValue="false")
    private Boolean includeTestSourceDirectory = Boolean.FALSE;
    @Parameter(property="scalastyle.build.directory", defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(property="scalastyle.base.directory", defaultValue="${basedir}")
    private File baseDirectory;
    @Parameter(property="scalastyle.input.encoding")
    private String inputEncoding;
    @Component
    protected MavenProject project;
    @Component
    private ResourceManager resourceManager;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (Boolean.TRUE.equals(this.skip)) {
            this.getLog().warn((CharSequence)"Scalastyle:check is skipped as scalastyle.skip=true");
        } else {
            this.getLog().debug((CharSequence)("failOnWarning=" + this.failOnWarning));
            this.getLog().debug((CharSequence)("verbose=" + this.verbose));
            this.getLog().debug((CharSequence)("quiet=" + this.quiet));
            for (File d : this.sourceDirectoriesAsList()) {
                this.getLog().debug((CharSequence)("sourceDirectory=" + d));
            }
            for (File d : this.testSourceDirectoriesAsList()) {
                this.getLog().debug((CharSequence)("testSourceDirectory=" + d));
            }
            this.getLog().debug((CharSequence)("includeTestSourceDirectory=" + this.includeTestSourceDirectory));
            this.getLog().debug((CharSequence)("buildDirectory=" + this.buildDirectory));
            this.getLog().debug((CharSequence)("baseDirectory=" + this.baseDirectory));
            this.getLog().debug((CharSequence)("outputFile=" + this.outputFile));
            this.getLog().debug((CharSequence)("outputEncoding=" + this.outputEncoding));
            this.getLog().debug((CharSequence)("inputEncoding=" + this.inputEncoding));
            this.performCheck();
        }
    }

    private void performCheck() throws MojoFailureException, MojoExecutionException {
        try {
            int violations;
            ScalastyleConfiguration srcConfiguration;
            ScalastyleConfiguration testConfiguration = srcConfiguration = ScalastyleConfiguration.readFromXml((String)this.getConfigFile(this.configLocation));
            if (this.testConfigLocation != null) {
                testConfiguration = ScalastyleConfiguration.readFromXml((String)this.getConfigFile(this.testConfigLocation));
            }
            long start = this.now();
            Option none = Option$.MODULE$.apply(null);
            ScalastyleChecker sc = new ScalastyleChecker(none);
            ArrayList<Message<FileSpec>> messages = new ArrayList<Message<FileSpec>>();
            messages.addAll(sc.checkFilesAsJava(srcConfiguration, this.getSrcFilesToProcess()));
            messages.addAll(sc.checkFilesAsJava(testConfiguration, this.getTestFilesToProcess()));
            Config config = ConfigFactory.load((ClassLoader)sc.getClass().getClassLoader());
            OutputResult outputResult = new TextOutput(config, this.verbose.booleanValue(), this.quiet.booleanValue()).output(messages);
            if (this.outputFile != null) {
                System.out.println("Saving to outputFile=" + this.outputFile.getAbsolutePath());
                this.saveToXml(config, this.outputFile, this.outputEncoding, messages);
            }
            if (!this.quiet.booleanValue()) {
                System.out.println("Processed " + outputResult.files() + " file(s)");
                System.out.println("Found " + outputResult.errors() + " errors");
                System.out.println("Found " + outputResult.warnings() + " warnings");
                System.out.println("Found " + outputResult.infos() + " infos");
                System.out.println("Finished in " + (this.now() - start) + " ms");
            }
            if ((violations = outputResult.errors() + (Boolean.TRUE.equals(this.failOnWarning) ? outputResult.warnings() : 0)) > 0) {
                if (this.failOnViolation.booleanValue()) {
                    throw new MojoFailureException("You have " + violations + " Scalastyle violation(s).");
                }
                this.getLog().warn((CharSequence)("Scalastyle:check violations detected but failOnViolation set to " + this.failOnViolation));
            } else {
                this.getLog().debug((CharSequence)"Scalastyle:check no violations found");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed during scalastyle execution", e);
        }
    }

    private void saveToXml(Config config, File outputFile, String encodingString, List<Message<FileSpec>> messages) {
        String encoding = encodingString != null ? encodingString : System.getProperty("file.encoding");
        XmlOutput.save((Config)config, (String)outputFile.getAbsolutePath(), (String)encoding, messages);
    }

    private long now() {
        return new Date().getTime();
    }

    private String getConfigFile(String configLocation) throws MojoFailureException {
        if (configLocation == null) {
            throw new MojoFailureException("configLocation is required");
        }
        if (new File(configLocation).exists()) {
            return configLocation;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassLoaderWithProjectResources());
            File configFile = this.resourceManager.getResourceAsFile(configLocation);
            if (configFile == null) {
                throw new MojoFailureException("Unable to process configuration file at location " + configLocation);
            }
            String string = configFile.getAbsolutePath();
            return string;
        }
        catch (ResourceNotFoundException e) {
            throw new MojoFailureException("Unable to find configuration file at location " + configLocation);
        }
        catch (FileResourceCreationException e) {
            throw new MojoFailureException("Unable to process configuration file at location " + configLocation, (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private URLClassLoader getClassLoaderWithProjectResources() throws MojoFailureException {
        ArrayList<String> classPathStrings = new ArrayList<String>();
        ArrayList<URL> urls = new ArrayList<URL>(classPathStrings.size());
        try {
            classPathStrings.addAll(this.project.getTestCompileSourceRoots());
            classPathStrings.addAll(this.project.getCompileSourceRoots());
            for (Resource resource : this.project.getTestResources()) {
                classPathStrings.add(resource.getDirectory());
            }
            for (Resource resource : this.project.getResources()) {
                classPathStrings.add(resource.getDirectory());
            }
            for (String path : classPathStrings) {
                urls.add(new File(path).toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    private List<FileSpec> getSrcFilesToProcess() {
        return this.getFiles("sourceDirectory", this.sourceDirectoriesAsList(), this.inputEncoding);
    }

    private List<FileSpec> getTestFilesToProcess() {
        return this.getFiles("testSourceDirectory", this.testSourceDirectoriesAsList(), this.inputEncoding);
    }

    private List<FileSpec> getFiles(String name, List<File> dirs, String encoding) {
        ArrayList<FileSpec> files = new ArrayList<FileSpec>();
        for (File dir : dirs) {
            if (this.isDirectory(dir)) {
                this.getLog().debug((CharSequence)("processing " + name + "=" + dir + " encoding=" + encoding));
                files.addAll(Directory.getFilesAsJava((Option)Option.apply((Object)encoding), Collections.singletonList(dir)));
                continue;
            }
            this.getLog().warn((CharSequence)(name + " is not specified or does not exist value=" + dir));
        }
        return files;
    }

    private boolean isDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    private List<File> sourceDirectoriesAsList() {
        return this.arrayOrValue(this.sourceDirectories, this.sourceDirectory);
    }

    private List<File> testSourceDirectoriesAsList() {
        return this.includeTestSourceDirectory == false ? new LinkedList<File>() : this.arrayOrValue(this.testSourceDirectories, this.testSourceDirectory);
    }

    private List<File> arrayOrValue(File[] array, File value) {
        return array != null ? Arrays.asList(array) : Collections.singletonList(value);
    }
}

