/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.languages.features.DocumentationProviderFeatures;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCodegen
extends DefaultCodegen
implements CodegenConfig,
DocumentationProviderFeatures {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaCodegen.class);
    private static final String ARTIFACT_VERSION_DEFAULT_VALUE = "1.0.0";
    public static final String FULL_JAVA_UTIL = "fullJavaUtil";
    public static final String DEFAULT_LIBRARY = "<default>";
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String JAVA8_MODE = "java8";
    public static final String SUPPORT_ASYNC = "supportAsync";
    public static final String WITH_XML = "withXml";
    public static final String SUPPORT_JAVA6 = "supportJava6";
    public static final String DISABLE_HTML_ESCAPING = "disableHtmlEscaping";
    public static final String BOOLEAN_GETTER_PREFIX = "booleanGetterPrefix";
    public static final String IGNORE_ANYOF_IN_ENUM = "ignoreAnyOfInEnum";
    public static final String ADDITIONAL_MODEL_TYPE_ANNOTATIONS = "additionalModelTypeAnnotations";
    public static final String ADDITIONAL_ENUM_TYPE_ANNOTATIONS = "additionalEnumTypeAnnotations";
    public static final String DISCRIMINATOR_CASE_SENSITIVE = "discriminatorCaseSensitive";
    public static final String OPENAPI_NULLABLE = "openApiNullable";
    public static final String JACKSON = "jackson";
    public static final String TEST_OUTPUT = "testOutput";
    public static final String DEFAULT_TEST_FOLDER = "${project.build.directory}/generated-test-sources/openapi";
    protected String dateLibrary = "threetenbp";
    protected boolean supportAsync = false;
    protected boolean java8Mode = true;
    protected boolean withXml = false;
    protected String invokerPackage = "org.openapitools";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-java";
    protected String artifactVersion = null;
    protected String artifactUrl = "https://github.com/openapitools/openapi-generator";
    protected String artifactDescription = "OpenAPI Java";
    protected String developerName = "OpenAPI-Generator Contributors";
    protected String developerEmail = "team@openapitools.org";
    protected String developerOrganization = "OpenAPITools.org";
    protected String developerOrganizationUrl = "http://openapitools.org";
    protected String scmConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmDeveloperConnection = "scm:git:git@github.com:openapitools/openapi-generator.git";
    protected String scmUrl = "https://github.com/openapitools/openapi-generator";
    protected String licenseName = "Unlicense";
    protected String licenseUrl = "http://unlicense.org";
    protected String projectFolder = "src/main";
    protected String projectTestFolder = "src/test";
    protected String sourceFolder = this.projectFolder + "/java";
    protected String testFolder = this.projectTestFolder + "/java";
    protected boolean fullJavaUtil;
    protected boolean discriminatorCaseSensitive = true;
    protected String javaUtilPrefix = "";
    protected Boolean serializableModel = false;
    protected boolean serializeBigDecimalAsString = false;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean supportJava6 = false;
    protected boolean disableHtmlEscaping = false;
    protected String booleanGetterPrefix = "get";
    protected boolean ignoreAnyOfInEnum = false;
    protected String parentGroupId = "";
    protected String parentArtifactId = "";
    protected String parentVersion = "";
    protected boolean parentOverridden = false;
    protected List<String> additionalModelTypeAnnotations = new LinkedList<String>();
    protected List<String> additionalEnumTypeAnnotations = new LinkedList<String>();
    protected boolean openApiNullable = true;
    protected String outputTestFolder = "";
    protected DocumentationProviderFeatures.DocumentationProvider documentationProvider;
    protected DocumentationProviderFeatures.AnnotationLibrary annotationLibrary;

    public AbstractJavaCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.supportsInheritance = true;
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = false;
        this.setReservedWordsLowerCase(Arrays.asList("object", "list", "file", "localVarPath", "localVarQueryParams", "localVarCollectionQueryParams", "localVarHeaderParams", "localVarCookieParams", "localVarFormParams", "localVarPostBody", "localVarAccepts", "localVarAccept", "localVarContentTypes", "localVarContentType", "localVarAuthNames", "localReturnType", "ApiClient", "ApiException", "ApiResponse", "Configuration", "StringUtil", "abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "null"));
        this.languageSpecificPrimitives = Sets.newHashSet((Object[])new String[]{"String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "byte[]"});
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("set", "LinkedHashSet");
        this.instantiationTypes.put("map", "HashMap");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("AnyType", "Object");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("URI", "java.net.URI");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("LinkedHashSet", "java.util.LinkedHashSet");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code").defaultValue(this.getInvokerPackage()));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml").defaultValue(this.getGroupId()));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename").defaultValue(this.getArtifactId()));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename").defaultValue(ARTIFACT_VERSION_DEFAULT_VALUE));
        this.cliOptions.add(new CliOption("artifactUrl", "artifact URL in generated pom.xml").defaultValue(this.getArtifactUrl()));
        this.cliOptions.add(new CliOption("artifactDescription", "artifact description in generated pom.xml").defaultValue(this.getArtifactDescription()));
        this.cliOptions.add(new CliOption("scmConnection", "SCM connection in generated pom.xml").defaultValue(this.getScmConnection()));
        this.cliOptions.add(new CliOption("scmDeveloperConnection", "SCM developer connection in generated pom.xml").defaultValue(this.getScmDeveloperConnection()));
        this.cliOptions.add(new CliOption("scmUrl", "SCM URL in generated pom.xml").defaultValue(this.getScmUrl()));
        this.cliOptions.add(new CliOption("developerName", "developer name in generated pom.xml").defaultValue(this.getDeveloperName()));
        this.cliOptions.add(new CliOption("developerEmail", "developer email in generated pom.xml").defaultValue(this.getDeveloperEmail()));
        this.cliOptions.add(new CliOption("developerOrganization", "developer organization in generated pom.xml").defaultValue(this.getDeveloperOrganization()));
        this.cliOptions.add(new CliOption("developerOrganizationUrl", "developer organization URL in generated pom.xml").defaultValue(this.getDeveloperOrganizationUrl()));
        this.cliOptions.add(new CliOption("licenseName", "The name of the license").defaultValue(this.getLicenseName()));
        this.cliOptions.add(new CliOption("licenseUrl", "The URL of the license").defaultValue(this.getLicenseUrl()));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code").defaultValue(this.getSourceFolder()));
        this.cliOptions.add(CliOption.newBoolean("serializableModel", "boolean - toggle \"implements Serializable\" for generated models", this.getSerializableModel()));
        this.cliOptions.add(CliOption.newBoolean("bigDecimalAsString", "Treat BigDecimal values as Strings to avoid precision loss.", this.serializeBigDecimalAsString));
        this.cliOptions.add(CliOption.newBoolean(FULL_JAVA_UTIL, "whether to use fully qualified name for classes under java.util. This option only works for Java API client", this.fullJavaUtil));
        this.cliOptions.add(CliOption.newBoolean(DISCRIMINATOR_CASE_SENSITIVE, "Whether the discriminator value lookup should be case-sensitive or not. This option only works for Java API client", this.discriminatorCaseSensitive));
        this.cliOptions.add(CliOption.newBoolean("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.", this.isHideGenerationTimestamp()));
        this.cliOptions.add(CliOption.newBoolean(WITH_XML, "whether to include support for application/xml content type and include XML annotations in the model (works with libraries that provide support for JSON and XML)"));
        CliOption dateLibrary = new CliOption(DATE_LIBRARY, "Option. Date library to use").defaultValue(this.getDateLibrary());
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put(JAVA8_MODE, "Java 8 native JSR310 (preferred for jdk 1.8+) - note: this also sets \"java8\" to true");
        dateOptions.put("threetenbp", "Backport of JSR310 (preferred for jdk < 1.8)");
        dateOptions.put("java8-localdatetime", "Java 8 using LocalDateTime (for legacy app only)");
        dateOptions.put("joda", "Joda (for legacy app only)");
        dateOptions.put("legacy", "Legacy java.util.Date (if you really have a good reason not to use threetenbp");
        dateLibrary.setEnum(dateOptions);
        this.cliOptions.add(dateLibrary);
        CliOption java8Mode = CliOption.newBoolean(JAVA8_MODE, "Use Java8 classes instead of third party equivalents. Starting in 5.x, JDK8 is the default and the support for JDK7, JDK6 has been dropped", this.java8Mode);
        HashMap<String, String> java8ModeOptions = new HashMap<String, String>();
        java8ModeOptions.put("true", "Use Java 8 classes such as Base64");
        java8ModeOptions.put("false", "Various third party libraries as needed");
        java8Mode.setEnum(java8ModeOptions);
        this.cliOptions.add(java8Mode);
        this.cliOptions.add(CliOption.newBoolean(DISABLE_HTML_ESCAPING, "Disable HTML escaping of JSON strings when using gson (needed to avoid problems with byte[] fields)", this.disableHtmlEscaping));
        this.cliOptions.add(CliOption.newString(BOOLEAN_GETTER_PREFIX, "Set booleanGetterPrefix").defaultValue(this.getBooleanGetterPrefix()));
        this.cliOptions.add(CliOption.newBoolean(IGNORE_ANYOF_IN_ENUM, "Ignore anyOf keyword in enum", this.ignoreAnyOfInEnum));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, "Additional annotations for enum type(class level annotations)"));
        this.cliOptions.add(CliOption.newString(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, "Additional annotations for model type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newBoolean(OPENAPI_NULLABLE, "Enable OpenAPI Jackson Nullable library", this.openApiNullable));
        this.cliOptions.add(CliOption.newString("parentGroupId", "parent groupId in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        this.cliOptions.add(CliOption.newString("parentArtifactId", "parent artifactId in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        this.cliOptions.add(CliOption.newString("parentVersion", "parent version in generated pom N.B. parentGroupId, parentArtifactId and parentVersion must all be specified for any of them to take effect"));
        CliOption snapShotVersion = CliOption.newString("snapshotVersion", "Uses a SNAPSHOT version.");
        HashMap<String, String> snapShotVersionOptions = new HashMap<String, String>();
        snapShotVersionOptions.put("true", "Use a SnapShot Version");
        snapShotVersionOptions.put("false", "Use a Release Version");
        snapShotVersion.setEnum(snapShotVersionOptions);
        this.cliOptions.add(snapShotVersion);
        this.cliOptions.add(CliOption.newString(TEST_OUTPUT, "Set output folder for models and APIs tests").defaultValue(DEFAULT_TEST_FOLDER));
        if (null != this.defaultDocumentationProvider()) {
            CliOption documentationProviderCliOption = new CliOption("documentationProvider", "Select the OpenAPI documentation provider.").defaultValue(this.defaultDocumentationProvider().toCliOptValue());
            this.supportedDocumentationProvider().forEach(dp -> documentationProviderCliOption.addEnum(dp.toCliOptValue(), dp.getDescription()));
            this.cliOptions.add(documentationProviderCliOption);
            CliOption annotationLibraryCliOption = new CliOption("annotationLibrary", "Select the complementary documentation annotation library.").defaultValue(this.defaultDocumentationProvider().getPreferredAnnotationLibrary().toCliOptValue());
            this.supportedAnnotationLibraries().forEach(al -> annotationLibraryCliOption.addEnum(al.toCliOptValue(), al.getDescription()));
            this.cliOptions.add(annotationLibraryCliOption);
        }
    }

    @Override
    public void processOpts() {
        String derivedInvokerPackage;
        String additionalAnnotationsList;
        super.processOpts();
        if (null != this.defaultDocumentationProvider()) {
            this.documentationProvider = DocumentationProviderFeatures.DocumentationProvider.ofCliOption(this.additionalProperties.getOrDefault("documentationProvider", this.defaultDocumentationProvider().toCliOptValue()));
            if (!this.supportedDocumentationProvider().contains((Object)this.documentationProvider)) {
                String msg = String.format(Locale.ROOT, "The [%s] Documentation Provider is not supported by this generator", this.documentationProvider.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.annotationLibrary = DocumentationProviderFeatures.AnnotationLibrary.ofCliOption(this.additionalProperties.getOrDefault("annotationLibrary", this.documentationProvider.getPreferredAnnotationLibrary().toCliOptValue()));
            if (!this.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The Annotation Library [%s] is not supported by this generator", this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            if (!this.documentationProvider.supportedAnnotationLibraries().contains((Object)this.annotationLibrary)) {
                String msg = String.format(Locale.ROOT, "The [%s] documentation provider does not support [%s] as complementary annotation library", this.documentationProvider.toCliOptValue(), this.annotationLibrary.toCliOptValue());
                throw new IllegalArgumentException(msg);
            }
            this.additionalProperties.put("documentationProvider", this.documentationProvider.toCliOptValue());
            this.additionalProperties.put(this.documentationProvider.getPropertyName(), true);
            this.additionalProperties.put("annotationLibrary", this.annotationLibrary.toCliOptValue());
            this.additionalProperties.put(this.annotationLibrary.getPropertyName(), true);
        } else {
            this.additionalProperties.put("documentationProvider", DocumentationProviderFeatures.DocumentationProvider.NONE);
            this.additionalProperties.put("annotationLibrary", DocumentationProviderFeatures.AnnotationLibrary.NONE);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("JAVA_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable JAVA_POST_PROCESS_FILE not defined so the Java code may not be properly formatted. To define it, try 'export JAVA_POST_PROCESS_FILE=\"/usr/local/bin/clang-format -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey(SUPPORT_JAVA6)) {
            this.setSupportJava6(Boolean.parseBoolean(this.additionalProperties.get(SUPPORT_JAVA6).toString()));
        }
        this.additionalProperties.put(SUPPORT_JAVA6, this.supportJava6);
        if (this.additionalProperties.containsKey(DISABLE_HTML_ESCAPING)) {
            this.setDisableHtmlEscaping(Boolean.parseBoolean(this.additionalProperties.get(DISABLE_HTML_ESCAPING).toString()));
        }
        this.additionalProperties.put(DISABLE_HTML_ESCAPING, this.disableHtmlEscaping);
        if (this.additionalProperties.containsKey(BOOLEAN_GETTER_PREFIX)) {
            this.setBooleanGetterPrefix(this.additionalProperties.get(BOOLEAN_GETTER_PREFIX).toString());
        }
        this.additionalProperties.put(BOOLEAN_GETTER_PREFIX, this.booleanGetterPrefix);
        if (this.additionalProperties.containsKey(IGNORE_ANYOF_IN_ENUM)) {
            this.setIgnoreAnyOfInEnum(Boolean.parseBoolean(this.additionalProperties.get(IGNORE_ANYOF_IN_ENUM).toString()));
        }
        this.additionalProperties.put(IGNORE_ANYOF_IN_ENUM, this.ignoreAnyOfInEnum);
        if (this.additionalProperties.containsKey(ADDITIONAL_MODEL_TYPE_ANNOTATIONS)) {
            additionalAnnotationsList = this.additionalProperties.get(ADDITIONAL_MODEL_TYPE_ANNOTATIONS).toString();
            this.setAdditionalModelTypeAnnotations(Arrays.asList(additionalAnnotationsList.trim().split("\\s*(;|\\r?\\n)\\s*")));
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_ENUM_TYPE_ANNOTATIONS)) {
            additionalAnnotationsList = this.additionalProperties.get(ADDITIONAL_ENUM_TYPE_ANNOTATIONS).toString();
            this.setAdditionalEnumTypeAnnotations(Arrays.asList(additionalAnnotationsList.split(";")));
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else if (this.additionalProperties.containsKey("apiPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("apiPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.LOGGER.info("Invoker Package Name, originally not set, is now derived from api package name: {}", (Object)derivedInvokerPackage);
        } else if (this.additionalProperties.containsKey("modelPackage")) {
            derivedInvokerPackage = this.deriveInvokerPackageName((String)this.additionalProperties.get("modelPackage"));
            this.additionalProperties.put("invokerPackage", derivedInvokerPackage);
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.LOGGER.info("Invoker Package Name, originally not set, is now derived from model package name: {}", (Object)derivedInvokerPackage);
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactUrl")) {
            this.setArtifactUrl((String)this.additionalProperties.get("artifactUrl"));
        } else {
            this.additionalProperties.put("artifactUrl", this.artifactUrl);
        }
        if (this.additionalProperties.containsKey("artifactDescription")) {
            this.setArtifactDescription((String)this.additionalProperties.get("artifactDescription"));
        } else {
            this.additionalProperties.put("artifactDescription", this.artifactDescription);
        }
        if (this.additionalProperties.containsKey("scmConnection")) {
            this.setScmConnection((String)this.additionalProperties.get("scmConnection"));
        } else {
            this.additionalProperties.put("scmConnection", this.scmConnection);
        }
        if (this.additionalProperties.containsKey("scmDeveloperConnection")) {
            this.setScmDeveloperConnection((String)this.additionalProperties.get("scmDeveloperConnection"));
        } else {
            this.additionalProperties.put("scmDeveloperConnection", this.scmDeveloperConnection);
        }
        if (this.additionalProperties.containsKey("scmUrl")) {
            this.setScmUrl((String)this.additionalProperties.get("scmUrl"));
        } else {
            this.additionalProperties.put("scmUrl", this.scmUrl);
        }
        if (this.additionalProperties.containsKey("developerName")) {
            this.setDeveloperName((String)this.additionalProperties.get("developerName"));
        } else {
            this.additionalProperties.put("developerName", this.developerName);
        }
        if (this.additionalProperties.containsKey("developerEmail")) {
            this.setDeveloperEmail((String)this.additionalProperties.get("developerEmail"));
        } else {
            this.additionalProperties.put("developerEmail", this.developerEmail);
        }
        if (this.additionalProperties.containsKey("developerOrganization")) {
            this.setDeveloperOrganization((String)this.additionalProperties.get("developerOrganization"));
        } else {
            this.additionalProperties.put("developerOrganization", this.developerOrganization);
        }
        if (this.additionalProperties.containsKey("developerOrganizationUrl")) {
            this.setDeveloperOrganizationUrl((String)this.additionalProperties.get("developerOrganizationUrl"));
        } else {
            this.additionalProperties.put("developerOrganizationUrl", this.developerOrganizationUrl);
        }
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        } else {
            this.additionalProperties.put("licenseName", this.licenseName);
        }
        if (this.additionalProperties.containsKey("licenseUrl")) {
            this.setLicenseUrl((String)this.additionalProperties.get("licenseUrl"));
        } else {
            this.additionalProperties.put("licenseUrl", this.licenseUrl);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("sourceFolder", this.sourceFolder);
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        if (this.additionalProperties.containsKey("library")) {
            this.setLibrary((String)this.additionalProperties.get("library"));
        }
        if (this.additionalProperties.containsKey("bigDecimalAsString")) {
            this.setSerializeBigDecimalAsString(Boolean.parseBoolean(this.additionalProperties.get("bigDecimalAsString").toString()));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        if (this.additionalProperties.containsKey(FULL_JAVA_UTIL)) {
            this.setFullJavaUtil(Boolean.parseBoolean(this.additionalProperties.get(FULL_JAVA_UTIL).toString()));
        }
        if (this.additionalProperties.containsKey(DISCRIMINATOR_CASE_SENSITIVE)) {
            this.setDiscriminatorCaseSensitive(Boolean.parseBoolean(this.additionalProperties.get(DISCRIMINATOR_CASE_SENSITIVE).toString()));
        } else {
            this.setDiscriminatorCaseSensitive(Boolean.TRUE);
        }
        this.additionalProperties.put(DISCRIMINATOR_CASE_SENSITIVE, this.discriminatorCaseSensitive);
        if (this.fullJavaUtil) {
            this.javaUtilPrefix = "java.util.";
        }
        this.additionalProperties.put(FULL_JAVA_UTIL, this.fullJavaUtil);
        this.additionalProperties.put("javaUtilPrefix", this.javaUtilPrefix);
        if (this.additionalProperties.containsKey(WITH_XML)) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get(WITH_XML).toString()));
        }
        this.additionalProperties.put(WITH_XML, this.withXml);
        if (this.additionalProperties.containsKey(OPENAPI_NULLABLE)) {
            this.setOpenApiNullable(Boolean.parseBoolean(this.additionalProperties.get(OPENAPI_NULLABLE).toString()));
        }
        this.additionalProperties.put(OPENAPI_NULLABLE, this.openApiNullable);
        if (this.additionalProperties.containsKey("parentGroupId")) {
            this.setParentGroupId((String)this.additionalProperties.get("parentGroupId"));
        }
        if (this.additionalProperties.containsKey("parentArtifactId")) {
            this.setParentArtifactId((String)this.additionalProperties.get("parentArtifactId"));
        }
        if (this.additionalProperties.containsKey("parentVersion")) {
            this.setParentVersion((String)this.additionalProperties.get("parentVersion"));
        }
        if (!(org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentGroupId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentArtifactId) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.parentVersion))) {
            this.additionalProperties.put("parentOverridden", true);
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.importMapping.put("List", "java.util.List");
        this.importMapping.put("Set", "java.util.Set");
        if (this.fullJavaUtil) {
            this.typeMapping.put("array", "java.util.List");
            this.typeMapping.put("set", "java.util.Set");
            this.typeMapping.put("map", "java.util.Map");
            this.typeMapping.put("DateTime", "java.util.Date");
            this.typeMapping.put("UUID", "java.util.UUID");
            this.typeMapping.remove("List");
            this.importMapping.remove("Date");
            this.importMapping.remove("Map");
            this.importMapping.remove("HashMap");
            this.importMapping.remove("Array");
            this.importMapping.remove("ArrayList");
            this.importMapping.remove("List");
            this.importMapping.remove("Set");
            this.importMapping.remove("DateTime");
            this.importMapping.remove("UUID");
            this.instantiationTypes.put("array", "java.util.ArrayList");
            this.instantiationTypes.put("set", "java.util.LinkedHashSet");
            this.instantiationTypes.put("map", "java.util.HashMap");
        }
        this.sanitizeConfig();
        this.importMapping.put("ToStringSerializer", "com.fasterxml.jackson.databind.ser.std.ToStringSerializer");
        this.importMapping.put("JsonSerialize", "com.fasterxml.jackson.databind.annotation.JsonSerialize");
        this.importMapping.put("JsonDeserialize", "com.fasterxml.jackson.databind.annotation.JsonDeserialize");
        this.importMapping.put("ApiModelProperty", "io.swagger.annotations.ApiModelProperty");
        this.importMapping.put("ApiModel", "io.swagger.annotations.ApiModel");
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonSubTypes", "com.fasterxml.jackson.annotation.JsonSubTypes");
        this.importMapping.put("JsonTypeInfo", "com.fasterxml.jackson.annotation.JsonTypeInfo");
        this.importMapping.put("JsonTypeName", "com.fasterxml.jackson.annotation.JsonTypeName");
        this.importMapping.put("JsonCreator", "com.fasterxml.jackson.annotation.JsonCreator");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("JsonIgnore", "com.fasterxml.jackson.annotation.JsonIgnore");
        this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
        this.importMapping.put("JsonNullable", "org.openapitools.jackson.nullable.JsonNullable");
        this.importMapping.put("SerializedName", "com.google.gson.annotations.SerializedName");
        this.importMapping.put("TypeAdapter", "com.google.gson.TypeAdapter");
        this.importMapping.put("JsonAdapter", "com.google.gson.annotations.JsonAdapter");
        this.importMapping.put("JsonReader", "com.google.gson.stream.JsonReader");
        this.importMapping.put("JsonWriter", "com.google.gson.stream.JsonWriter");
        this.importMapping.put("IOException", "java.io.IOException");
        this.importMapping.put("Arrays", "java.util.Arrays");
        this.importMapping.put("Objects", "java.util.Objects");
        this.importMapping.put("StringUtil", this.invokerPackage + ".StringUtil");
        this.importMapping.put("com.fasterxml.jackson.annotation.JsonProperty", "com.fasterxml.jackson.annotation.JsonCreator");
        if (this.additionalProperties.containsKey(JAVA8_MODE)) {
            this.setJava8ModeAndAdditionalProperties(Boolean.parseBoolean(this.additionalProperties.get(JAVA8_MODE).toString()));
        }
        if (this.additionalProperties.containsKey(SUPPORT_ASYNC)) {
            this.setSupportAsync(Boolean.parseBoolean(this.additionalProperties.get(SUPPORT_ASYNC).toString()));
            if (this.supportAsync) {
                this.additionalProperties.put(SUPPORT_ASYNC, "true");
            }
        }
        if (this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        }
        if ("threetenbp".equals(this.dateLibrary)) {
            this.additionalProperties.put("threetenbp", "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.importMapping.put("LocalDate", "org.threeten.bp.LocalDate");
            this.importMapping.put("OffsetDateTime", "org.threeten.bp.OffsetDateTime");
        } else if ("joda".equals(this.dateLibrary)) {
            this.additionalProperties.put("joda", "true");
            this.typeMapping.put("date", "LocalDate");
            this.typeMapping.put("DateTime", "DateTime");
            this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
            this.importMapping.put("DateTime", "org.joda.time.DateTime");
        } else if (this.dateLibrary.startsWith(JAVA8_MODE)) {
            this.additionalProperties.put(JAVA8_MODE, "true");
            this.additionalProperties.put("jsr310", "true");
            this.typeMapping.put("date", "LocalDate");
            this.importMapping.put("LocalDate", "java.time.LocalDate");
            if ("java8-localdatetime".equals(this.dateLibrary)) {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
            } else {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
            }
        } else if (this.dateLibrary.equals("legacy")) {
            this.additionalProperties.put("legacyDates", "true");
        }
        if (this.additionalProperties.containsKey(TEST_OUTPUT)) {
            this.setOutputTestFolder(this.additionalProperties.get(TEST_OUTPUT).toString());
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map models;
        objs = super.postProcessAllModels(objs);
        objs = super.updateAllModels(objs);
        if (!this.additionalModelTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = (Map)objs.get(modelName);
                models.put(ADDITIONAL_MODEL_TYPE_ANNOTATIONS, this.additionalModelTypeAnnotations);
            }
        }
        if (!this.additionalEnumTypeAnnotations.isEmpty()) {
            for (String modelName : objs.keySet()) {
                models = (Map)objs.get(modelName);
                models.put(ADDITIONAL_ENUM_TYPE_ANNOTATIONS, this.additionalEnumTypeAnnotations);
            }
        }
        return objs;
    }

    private void sanitizeConfig() {
        this.setApiPackage(AbstractJavaCodegen.sanitizePackageName(this.apiPackage));
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        this.setModelPackage(AbstractJavaCodegen.sanitizePackageName(this.modelPackage));
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.setInvokerPackage(AbstractJavaCodegen.sanitizePackageName(this.invokerPackage));
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputTestFolder + File.separator + this.testFolder + File.separator + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputTestFolder + File.separator + this.testFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + File.separator + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + File.separator + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name, "\\W-[\\$]")).toLowerCase(Locale.ROOT).matches("^_*class$")) {
            return "propertyClass";
        }
        if ("_".equals(name)) {
            name = "_u";
        }
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        if (name.matches("^[A-Z0-9_]*$")) {
            return name;
        }
        if (this.startsWithTwoUppercaseLetters(name)) {
            name = name.substring(0, 2).toLowerCase(Locale.ROOT) + name.substring(2);
        }
        if (name.chars().anyMatch(character -> this.specialCharReplacements.containsKey(String.valueOf((char)character)))) {
            ArrayList<String> allowedCharacters = new ArrayList<String>();
            allowedCharacters.add("_");
            allowedCharacters.add("$");
            name = StringUtils.escape(name, this.specialCharReplacements, allowedCharacters, "_");
        }
        if (this.isReservedWord(name = StringUtils.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private boolean startsWithTwoUppercaseLetters(String name) {
        boolean startsWithTwoUppercaseLetters = false;
        if (name.length() > 1) {
            startsWithTwoUppercaseLetters = name.substring(0, 2).equals(name.substring(0, 2).toUpperCase(Locale.ROOT));
        }
        return startsWithTwoUppercaseLetters;
    }

    @Override
    public String toParamName(String name) {
        if ("callback".equals(name)) {
            return "paramCallback";
        }
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        String camelizedName;
        String sanitizedName;
        String nameWithPrefixSuffix = sanitizedName = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            nameWithPrefixSuffix = this.modelNamePrefix + "_" + nameWithPrefixSuffix;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            nameWithPrefixSuffix = nameWithPrefixSuffix + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(camelizedName = StringUtils.camelize(nameWithPrefixSuffix))) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)camelizedName, (Object)modelName);
            return modelName;
        }
        if (camelizedName.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        Schema target;
        Schema schema = ModelUtils.unaliasSchema(this.openAPI, p, this.importMapping);
        Schema schema2 = target = ModelUtils.isGenerateAliasAsModel() ? p : schema;
        if (ModelUtils.isArraySchema(target)) {
            Schema<?> items = this.getSchemaItems((ArraySchema)schema);
            return this.getSchemaType(target) + "<" + this.getTypeDeclaration(items) + ">";
        }
        if (ModelUtils.isMapSchema(target)) {
            Schema inner = this.getAdditionalProperties(target);
            if (inner == null) {
                this.LOGGER.error("`{}` (map property) does not have a proper inner type defined. Default to type:string", (Object)p.getName());
                inner = new StringSchema().description("TODO default missing map inner type to string");
                p.setAdditionalProperties((Object)inner);
            }
            return this.getSchemaType(target) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(target);
    }

    @Override
    public String getAlias(String name) {
        if (this.typeAliases != null && this.typeAliases.containsKey(name)) {
            return (String)this.typeAliases.get(name);
        }
        return name;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (ModelUtils.isArraySchema(schema = ModelUtils.getReferencedSchema(this.openAPI, schema))) {
            Boolean java8;
            String pattern;
            if (ModelUtils.isSet(schema)) {
                String mapInstantiationType = this.instantiationTypes().getOrDefault("set", "LinkedHashSet");
                pattern = "new " + mapInstantiationType + "<%s>()";
            } else {
                String arrInstantiationType = this.instantiationTypes().getOrDefault("array", "ArrayList");
                pattern = "new " + arrInstantiationType + "<%s>()";
            }
            Schema<?> items = this.getSchemaItems((ArraySchema)schema);
            String typeDeclaration = this.getTypeDeclaration(ModelUtils.unaliasSchema(this.openAPI, items));
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(Locale.ROOT, pattern, typeDeclaration);
        }
        if (ModelUtils.isMapSchema(schema) && !(schema instanceof ComposedSchema)) {
            Boolean java8;
            if (schema.getProperties() != null && schema.getProperties().size() > 0) {
                if (schema.getDefault() != null) {
                    return super.toDefaultValue(schema);
                }
                return null;
            }
            String mapInstantiationType = this.instantiationTypes().getOrDefault("map", "HashMap");
            String pattern = "new " + mapInstantiationType + "<%s>()";
            if (this.getAdditionalProperties(schema) == null) {
                return null;
            }
            String typeDeclaration = String.format(Locale.ROOT, "String, %s", this.getTypeDeclaration(this.getAdditionalProperties(schema)));
            Object java8obj = this.additionalProperties.get(JAVA8_MODE);
            if (java8obj != null && (java8 = Boolean.valueOf(java8obj.toString())) != null && java8.booleanValue()) {
                typeDeclaration = "";
            }
            return String.format(Locale.ROOT, pattern, typeDeclaration);
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (schema.getDefault() != null) {
                if ("int64".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "l";
                }
                return schema.getDefault().toString();
            }
            return null;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (schema.getDefault() != null) {
                if ("float".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "f";
                }
                if ("double".equals(schema.getFormat())) {
                    return schema.getDefault().toString() + "d";
                }
                return "new BigDecimal(\"" + schema.getDefault().toString() + "\")";
            }
            return null;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            if (schema.getDefault() != null) {
                return schema.getDefault().toString();
            }
            return null;
        }
        if (ModelUtils.isURISchema(schema)) {
            if (schema.getDefault() != null) {
                return "URI.create(\"" + this.escapeText((String)schema.getDefault()) + "\")";
            }
            return null;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (schema.getDefault() != null) {
                if (schema.getDefault() instanceof Date) {
                    Date date = (Date)schema.getDefault();
                    LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    return String.format(Locale.ROOT, localDate.toString(), "");
                }
                if (schema.getDefault() instanceof OffsetDateTime) {
                    return "OffsetDateTime.parse(\"" + String.format(Locale.ROOT, ((OffsetDateTime)schema.getDefault()).atZoneSameInstant(ZoneId.systemDefault()).toString(), "") + "\", java.time.format.DateTimeFormatter.ISO_ZONED_DATE_TIME.withZone(java.time.ZoneId.systemDefault()))";
                }
                String _default = (String)schema.getDefault();
                if (schema.getEnum() == null) {
                    return "\"" + this.escapeText(_default) + "\"";
                }
                return _default;
            }
            return null;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            if (schema.getDefault() != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            if (schema.getDefault() != null) {
                return super.toDefaultValue(schema);
            }
            return null;
        }
        return super.toDefaultValue(schema);
    }

    @Override
    public String toDefaultParameterValue(Schema<?> schema) {
        Object defaultValue;
        Object object = defaultValue = schema.get$ref() != null ? ModelUtils.getReferencedSchema(this.openAPI, schema).getDefault() : schema.getDefault();
        if (defaultValue == null) {
            return null;
        }
        return defaultValue.toString().replace("\"", "\\\"");
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        Schema schema;
        Example example;
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        }
        if (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && (example = (Example)parameter.getExamples().values().iterator().next()).getValue() != null) {
            codegenParameter.example = example.getValue().toString();
        }
        if ((schema = parameter.getSchema()) != null && schema.getExample() != null) {
            codegenParameter.example = schema.getExample().toString();
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        Example example;
        MediaType mediaType;
        boolean isModel = codegenParameter.isModel || codegenParameter.isContainer && codegenParameter.getItems().isModel;
        Content content = requestBody.getContent();
        if (content.size() > 1) {
            this.LOGGER.warn("Multiple MediaTypes found, using only the first one");
        }
        if ((mediaType = (MediaType)content.values().iterator().next()).getExample() != null) {
            if (isModel) {
                this.LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = mediaType.getExample().toString();
                return;
            }
        }
        if (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && (example = (Example)mediaType.getExamples().values().iterator().next()).getValue() != null) {
            if (isModel) {
                this.LOGGER.warn("Ignoring complex example on request body");
            } else {
                codegenParameter.example = example.getValue().toString();
                return;
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example;
        boolean hasAllowableValues;
        boolean bl = hasAllowableValues = p.allowableValues != null && !p.allowableValues.isEmpty();
        if (hasAllowableValues) {
            List values = (List)p.allowableValues.get("values");
            example = String.valueOf(values.get(0));
        } else {
            example = p.defaultValue == null ? p.example : p.defaultValue;
        }
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "Short".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Long".equals(type)) {
            if (example == null) {
                example = "56";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)example, (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "new File(\"" + this.escapeText(example) + "\")";
        } else if ("Date".equals(type)) {
            example = "new Date()";
        } else if ("LocalDate".equals(type)) {
            example = example == null ? "LocalDate.now()" : "LocalDate.parse(\"" + example + "\")";
        } else if ("OffsetDateTime".equals(type)) {
            example = example == null ? "OffsetDateTime.now()" : "OffsetDateTime.parse(\"" + example + "\")";
        } else if ("BigDecimal".equals(type)) {
            example = example == null ? "new BigDecimal(78)" : "new BigDecimal(\"" + example + "\")";
        } else if ("UUID".equals(type)) {
            example = example == null ? "UUID.randomUUID()" : "UUID.fromString(\"" + example + "\")";
        } else if (hasAllowableValues) {
            example = type + ".fromValue(\"" + example + "\")";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + type + "()";
        }
        if (example == null) {
            example = "null";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            if (p.items.defaultValue != null) {
                String innerExample = "String".equals(p.items.dataType) ? "\"" + p.items.defaultValue + "\"" : p.items.defaultValue;
                example = "Arrays.asList(" + innerExample + ")";
            } else {
                example = "Arrays.asList()";
            }
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "new HashMap()";
        }
        p.example = example;
    }

    @Override
    public String toExampleValue(Schema p) {
        if (p.getExample() != null) {
            return this.escapeText(p.getExample().toString());
        }
        return null;
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (null == openAPIType) {
            this.LOGGER.error("No Type defined for Schema {}", (Object)p);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId = StringUtils.camelize(this.sanitizeName(operationId), true))) {
            String newOperationId = StringUtils.camelize("call_" + operationId, true);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        if (operationId.matches("^\\d.*")) {
            this.LOGGER.warn(operationId + " (starting with a number) cannot be used as method name. Renamed to " + StringUtils.camelize("call_" + operationId), (Object)true);
            operationId = StringUtils.camelize("call_" + operationId, true);
        }
        return operationId;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel codegenModel = super.fromModel(name, model);
        if (codegenModel.description != null) {
            codegenModel.imports.add("ApiModel");
        }
        if (codegenModel.discriminator != null && this.additionalProperties.containsKey(JACKSON)) {
            codegenModel.imports.add("JsonSubTypes");
            codegenModel.imports.add("JsonTypeInfo");
        }
        if (allDefinitions != null && codegenModel.parentSchema != null && codegenModel.hasEnums) {
            Schema parentModel = allDefinitions.get(codegenModel.parentSchema);
            CodegenModel parentCodegenModel = super.fromModel(codegenModel.parent, parentModel);
            codegenModel = AbstractJavaCodegen.reconcileInlineEnums(codegenModel, parentCodegenModel);
        }
        if ("BigDecimal".equals(codegenModel.dataType)) {
            codegenModel.imports.add("BigDecimal");
        }
        return codegenModel;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.serializeBigDecimalAsString && "decimal".equals(property.baseType)) {
            property.vendorExtensions.put("x-extra-annotation", "@JsonSerialize(using = ToStringSerializer.class)");
            model.imports.add("ToStringSerializer");
            model.imports.add("JsonSerialize");
        }
        if (!this.fullJavaUtil) {
            if ("array".equals(property.containerType)) {
                model.imports.add("ArrayList");
            } else if ("set".equals(property.containerType)) {
                model.imports.add("LinkedHashSet");
                model.imports.add("JsonDeserialize");
                property.vendorExtensions.put("x-setter-extra-annotation", "@JsonDeserialize(as = LinkedHashSet.class)");
            } else if ("map".equals(property.containerType)) {
                model.imports.add("HashMap");
            }
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("ApiModelProperty");
            model.imports.add("ApiModel");
        }
        if (this.openApiNullable && Boolean.FALSE.equals(property.required) && Boolean.TRUE.equals(property.isNullable)) {
            model.imports.add("JsonNullable");
            model.getVendorExtensions().put("x-jackson-optional-nullable-helpers", true);
        }
        if (property.isReadOnly) {
            model.getVendorExtensions().put("x-has-readonly-properties", true);
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator listIterator = recursiveImports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            HashMap newImportMap = new HashMap();
            newImportMap.put("import", this.importMapping.get(_import));
            listIterator.add(newImportMap);
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        List imports = (List)objs.get("imports");
        Pattern pattern = Pattern.compile("java\\.util\\.(List|ArrayList|Map|HashMap)");
        Iterator itr = imports.iterator();
        while (itr.hasNext()) {
            String itrImport = (String)((Map)itr.next()).get("import");
            if (!pattern.matcher(itrImport).matches()) continue;
            itr.remove();
        }
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            ConcurrentSkipListSet operationImports = new ConcurrentSkipListSet();
            for (CodegenParameter p : op.allParams) {
                if (!this.importMapping.containsKey(p.dataType)) continue;
                operationImports.add(this.importMapping.get(p.dataType));
            }
            op.vendorExtensions.put("x-java-import", operationImports);
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI == null) {
            return;
        }
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    this.LOGGER.info("Processing operation {}", (Object)operation.getOperationId());
                    if (this.hasBodyParameter(openAPI, operation) || this.hasFormParameter(openAPI, operation)) {
                        String defaultContentType = this.hasFormParameter(openAPI, operation) ? "application/x-www-form-urlencoded" : "application/json";
                        ArrayList<String> consumes = new ArrayList<String>(AbstractJavaCodegen.getConsumesInfo(openAPI, operation));
                        String contentType = consumes.isEmpty() ? defaultContentType : (String)consumes.get(0);
                        operation.addExtension("x-contentType", (Object)contentType);
                    }
                    String accepts = AbstractJavaCodegen.getAccept(openAPI, operation);
                    operation.addExtension("x-accepts", (Object)accepts);
                }
            }
        }
        if (this.artifactVersion == null) {
            if (this.additionalProperties.containsKey("artifactVersion") && this.additionalProperties.get("artifactVersion") != null) {
                this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
            } else if (openAPI.getInfo() != null && openAPI.getInfo().getVersion() != null) {
                this.setArtifactVersion(openAPI.getInfo().getVersion());
            } else {
                this.setArtifactVersion(ARTIFACT_VERSION_DEFAULT_VALUE);
            }
        }
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.additionalProperties.containsKey("snapshotVersion") && this.convertPropertyToBooleanAndWriteBack("snapshotVersion")) {
            this.setArtifactVersion(this.buildSnapshotVersion(this.getArtifactVersion()));
        }
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        if (this.ignoreAnyOfInEnum) {
            Stream.concat(Stream.of(openAPI.getComponents().getSchemas()), openAPI.getComponents().getSchemas().values().stream().filter(schema -> schema.getProperties() != null).map(Schema::getProperties)).forEach(schemas -> schemas.replaceAll((name, s) -> Stream.of(s).filter(schema -> schema instanceof ComposedSchema).map(schema -> (ComposedSchema)schema).filter(schema -> Objects.nonNull(schema.getAnyOf())).flatMap(schema -> schema.getAnyOf().stream()).filter(schema -> Objects.nonNull(schema.getEnum())).findFirst().orElse((Schema)s)));
        }
    }

    private static String getAccept(OpenAPI openAPI, Operation operation) {
        String accepts = null;
        String defaultContentType = "application/json";
        Set<String> producesInfo = AbstractJavaCodegen.getProducesInfo(openAPI, operation);
        if (producesInfo != null && !producesInfo.isEmpty()) {
            ArrayList<String> produces = new ArrayList<String>(producesInfo);
            StringBuilder sb = new StringBuilder();
            for (String produce : produces) {
                if (defaultContentType.equalsIgnoreCase(produce)) {
                    accepts = defaultContentType;
                    break;
                }
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(produce);
            }
            if (accepts == null) {
                accepts = sb.toString();
            }
        } else {
            accepts = defaultContentType;
        }
        return accepts;
    }

    @Override
    protected boolean needToImport(String type) {
        return super.needToImport(type) && !type.contains(".");
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype) || "BigDecimal".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "l";
        }
        if ("Float".equals(datatype)) {
            return value + "f";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(\"" + value + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.sanitizePath(op.path);
        return op;
    }

    @Override
    public void postProcessParameter(CodegenParameter p) {
        if (p.defaultValue == null) {
            return;
        }
        Boolean fixLong = p.isLong && "l".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        Boolean fixDouble = p.isDouble && "d".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        Boolean fixFloat = p.isFloat && "f".equals(p.defaultValue.substring(p.defaultValue.length() - 1));
        if (fixLong.booleanValue() || fixDouble.booleanValue() || fixFloat.booleanValue()) {
            p.defaultValue = p.defaultValue.substring(0, p.defaultValue.length() - 1);
        }
    }

    private static CodegenModel reconcileInlineEnums(CodegenModel codegenModel, CodegenModel parentCodegenModel) {
        if (!parentCodegenModel.hasEnums) {
            return codegenModel;
        }
        List<CodegenProperty> parentModelCodegenProperties = parentCodegenModel.vars;
        List<CodegenProperty> codegenProperties = codegenModel.vars;
        boolean removedChildEnum = false;
        for (CodegenProperty parentModelCodegenProperty : parentModelCodegenProperties) {
            if (!parentModelCodegenProperty.isEnum) continue;
            Iterator<CodegenProperty> iterator = codegenProperties.iterator();
            while (iterator.hasNext()) {
                CodegenProperty codegenProperty = iterator.next();
                if (!codegenProperty.isEnum || !codegenProperty.equals(parentModelCodegenProperty)) continue;
                iterator.remove();
                removedChildEnum = true;
            }
        }
        if (removedChildEnum) {
            codegenModel.vars = codegenProperties;
        }
        return codegenModel;
    }

    private static String sanitizePackageName(String packageName) {
        packageName = packageName.trim();
        if (Strings.isNullOrEmpty((String)(packageName = packageName.replaceAll("[^a-zA-Z0-9_\\.]", "_")))) {
            return "invalidPackageName";
        }
        return packageName;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
    }

    public String getScmConnection() {
        return this.scmConnection;
    }

    public void setScmConnection(String scmConnection) {
        this.scmConnection = scmConnection;
    }

    public String getScmDeveloperConnection() {
        return this.scmDeveloperConnection;
    }

    public void setScmDeveloperConnection(String scmDeveloperConnection) {
        this.scmDeveloperConnection = scmDeveloperConnection;
    }

    public String getScmUrl() {
        return this.scmUrl;
    }

    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public void setDeveloperName(String developerName) {
        this.developerName = developerName;
    }

    public String getDeveloperEmail() {
        return this.developerEmail;
    }

    public void setDeveloperEmail(String developerEmail) {
        this.developerEmail = developerEmail;
    }

    public String getDeveloperOrganization() {
        return this.developerOrganization;
    }

    public void setDeveloperOrganization(String developerOrganization) {
        this.developerOrganization = developerOrganization;
    }

    public String getDeveloperOrganizationUrl() {
        return this.developerOrganizationUrl;
    }

    public void setDeveloperOrganizationUrl(String developerOrganizationUrl) {
        this.developerOrganizationUrl = developerOrganizationUrl;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getTestFolder() {
        return this.testFolder;
    }

    public void setTestFolder(String testFolder) {
        this.testFolder = testFolder;
    }

    public void setSerializeBigDecimalAsString(boolean s) {
        this.serializeBigDecimalAsString = s;
    }

    public Boolean getSerializableModel() {
        return this.serializableModel;
    }

    public void setSerializableModel(Boolean serializableModel) {
        this.serializableModel = serializableModel;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("\"", "%22");
    }

    public void setFullJavaUtil(boolean fullJavaUtil) {
        this.fullJavaUtil = fullJavaUtil;
    }

    public void setDiscriminatorCaseSensitive(boolean discriminatorCaseSensitive) {
        this.discriminatorCaseSensitive = discriminatorCaseSensitive;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public void setJava8Mode(boolean enabled) {
        this.java8Mode = enabled;
    }

    public void setJava8ModeAndAdditionalProperties(boolean enabled) {
        this.java8Mode = enabled;
        if (this.java8Mode) {
            this.additionalProperties.put(JAVA8_MODE, true);
        } else {
            this.additionalProperties.put(JAVA8_MODE, false);
        }
    }

    public void setSupportAsync(boolean enabled) {
        this.supportAsync = enabled;
    }

    public void setDisableHtmlEscaping(boolean disabled) {
        this.disableHtmlEscaping = disabled;
    }

    public String getBooleanGetterPrefix() {
        return this.booleanGetterPrefix;
    }

    public void setBooleanGetterPrefix(String booleanGetterPrefix) {
        this.booleanGetterPrefix = booleanGetterPrefix;
    }

    public void setIgnoreAnyOfInEnum(boolean ignoreAnyOfInEnum) {
        this.ignoreAnyOfInEnum = ignoreAnyOfInEnum;
    }

    public boolean isOpenApiNullable() {
        return this.openApiNullable;
    }

    public void setOpenApiNullable(boolean openApiNullable) {
        this.openApiNullable = openApiNullable;
    }

    @Override
    public void setOutputDir(String dir) {
        super.setOutputDir(dir);
        if (this.outputTestFolder.isEmpty()) {
            this.setOutputTestFolder(dir);
        }
    }

    public String getOutputTestFolder() {
        if (this.outputTestFolder.isEmpty()) {
            return DEFAULT_TEST_FOLDER;
        }
        return this.outputTestFolder;
    }

    public void setOutputTestFolder(String outputTestFolder) {
        this.outputTestFolder = outputTestFolder;
    }

    @Override
    public DocumentationProviderFeatures.DocumentationProvider getDocumentationProvider() {
        return this.documentationProvider;
    }

    @Override
    public void setDocumentationProvider(DocumentationProviderFeatures.DocumentationProvider documentationProvider) {
        this.documentationProvider = documentationProvider;
    }

    @Override
    public DocumentationProviderFeatures.AnnotationLibrary getAnnotationLibrary() {
        return this.annotationLibrary;
    }

    @Override
    public void setAnnotationLibrary(DocumentationProviderFeatures.AnnotationLibrary annotationLibrary) {
        this.annotationLibrary = annotationLibrary;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    private String deriveInvokerPackageName(String input) {
        String[] parts = input.split(Pattern.quote("."));
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String p : Arrays.copyOf(parts, parts.length - 1)) {
            sb.append(delim).append(p);
            delim = ".";
        }
        return sb.toString();
    }

    private String buildSnapshotVersion(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            return version;
        }
        return version + "-SNAPSHOT";
    }

    public void setSupportJava6(boolean value) {
        this.supportJava6 = value;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String toBooleanGetter(String name) {
        return this.booleanGetterPrefix + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String sanitizeTag(String tag) {
        if ((tag = StringUtils.camelize(StringUtils.underscore(this.sanitizeName(tag)))).matches("^\\d.*")) {
            tag = "Class" + tag;
        }
        return tag;
    }

    @Override
    public String getterAndSetterCapitalize(String name) {
        boolean lowercaseFirstLetter = false;
        if (name == null || name.length() == 0) {
            return name;
        }
        if ((name = this.toVarName(name)).length() > 1 && Character.isLowerCase(name.charAt(0)) && Character.isUpperCase(name.charAt(1))) {
            lowercaseFirstLetter = true;
        }
        return StringUtils.camelize(name, lowercaseFirstLetter);
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String javaPostProcessFile = System.getenv("JAVA_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)javaPostProcessFile)) {
            return;
        }
        if ("java".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = javaPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public void setParentArtifactId(String parentArtifactId) {
        this.parentArtifactId = parentArtifactId;
    }

    public void setParentVersion(String parentVersion) {
        this.parentVersion = parentVersion;
    }

    public void setParentOverridden(boolean parentOverridden) {
        this.parentOverridden = parentOverridden;
    }

    public List<String> getAdditionalModelTypeAnnotations() {
        return this.additionalModelTypeAnnotations;
    }

    public void setAdditionalModelTypeAnnotations(List<String> additionalModelTypeAnnotations) {
        this.additionalModelTypeAnnotations = additionalModelTypeAnnotations;
    }

    public void setAdditionalEnumTypeAnnotations(List<String> additionalEnumTypeAnnotations) {
        this.additionalEnumTypeAnnotations = additionalEnumTypeAnnotations;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema s;
        if (!this.supportsAdditionalPropertiesWithComposedSchema) {
            super.addAdditionPropertiesToCodeGenModel(codegenModel, schema);
        }
        if ((s = this.getAdditionalProperties(schema)) != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(s);
            this.addImport(codegenModel, codegenModel.additionalPropertiesType);
        }
    }
}

