/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.IntEnum;
import org.fest.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeFormatter
extends ComponentFormatterTemplate {
    private static final String[] EMPTY = new String[0];
    private static final IntEnum SELECTION_MODES = new IntEnum();

    @Override
    protected String doFormat(Component c) {
        JTree tree = (JTree)c;
        return Strings.concat(tree.getClass().getName(), "[", "name=", Strings.quote(tree.getName()), ", ", "selectionCount=", String.valueOf(tree.getSelectionCount()), ", ", "selectionPaths=", Arrays.format(this.selectionPaths(tree)), ", ", "selectionMode=", this.selectionMode(tree), ", ", "enabled=", String.valueOf(tree.isEnabled()), ", ", "visible=", String.valueOf(tree.isVisible()), ", ", "showing=", String.valueOf(tree.isShowing()), "]");
    }

    private String[] selectionPaths(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return EMPTY;
        }
        int count = paths.length;
        if (count == 0) {
            return EMPTY;
        }
        String[] pathArray = new String[count];
        for (int i = 0; i < count; ++i) {
            TreePath path = paths[i];
            pathArray[i] = path != null ? path.toString() : null;
        }
        return pathArray;
    }

    private String selectionMode(JTree tree) {
        TreeSelectionModel model = tree.getSelectionModel();
        return SELECTION_MODES.get(model.getSelectionMode());
    }

    @Override
    public Class<? extends Component> targetType() {
        return JTree.class;
    }

    static {
        SELECTION_MODES.put(1, "SINGLE_TREE_SELECTION").put(2, "CONTIGUOUS_TREE_SELECTION").put(4, "DISCONTIGUOUS_TREE_SELECTION");
    }
}

