/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Collections;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class EndpointMvcAdapter
implements MvcEndpoint {
    private final Endpoint<?> delegate;

    public EndpointMvcAdapter(Endpoint<?> delegate) {
        Assert.notNull(delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Object invoke() {
        if (!this.delegate.isEnabled()) {
            return new ResponseEntity(Collections.singletonMap("message", "This endpoint is disabled"), HttpStatus.NOT_FOUND);
        }
        return this.delegate.invoke();
    }

    public Endpoint<?> getDelegate() {
        return this.delegate;
    }

    @Override
    public String getPath() {
        return "/" + this.delegate.getId();
    }

    @Override
    public boolean isSensitive() {
        return this.delegate.isSensitive();
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return this.delegate.getClass();
    }
}

