/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.aop.support.AbstractRegexpMethodPointcut;

public class Perl5RegexpMethodPointcut
extends AbstractRegexpMethodPointcut {
    private transient Pattern[] compiledPatterns = new Pattern[0];
    private transient Pattern[] compiledExclusionPatterns = new Pattern[0];
    private transient PatternMatcher matcher;

    protected void initPatternRepresentation(String[] patterns) throws IllegalArgumentException {
        this.compiledPatterns = this.compilePatterns(patterns);
        this.matcher = new Perl5Matcher();
    }

    protected boolean matches(String pattern, int patternIndex) {
        return this.matcher.matches(pattern, this.compiledPatterns[patternIndex]);
    }

    protected void initExcludedPatternRepresentation(String[] excludedPatterns) throws IllegalArgumentException {
        this.compiledExclusionPatterns = this.compilePatterns(excludedPatterns);
    }

    protected boolean matchesExclusion(String pattern, int patternIndex) {
        return this.matcher.matches(pattern, this.compiledExclusionPatterns[patternIndex]);
    }

    private Pattern[] compilePatterns(String[] source) {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern[] destination = new Pattern[source.length];
        for (int i = 0; i < source.length; ++i) {
            try {
                destination[i] = compiler.compile(source[i], 32768);
                continue;
            }
            catch (MalformedPatternException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        return destination;
    }
}

