/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.authentication.PassphraseDialog;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PublicKeyAuthenticationPrompt
implements SshAuthenticationPrompt {
    private Component parent;
    private PublicKeyAuthenticationClient instance;

    public PublicKeyAuthenticationPrompt(Component component) {
        this.parent = component;
    }

    public void setInstance(SshAuthenticationClient sshAuthenticationClient) throws AuthenticationProtocolException {
        if (!(sshAuthenticationClient instanceof PublicKeyAuthenticationClient)) {
            throw new AuthenticationProtocolException("PublicKeyAuthenticationClient instance required");
        }
        this.instance = (PublicKeyAuthenticationClient)sshAuthenticationClient;
    }

    public boolean showPrompt(SshAuthenticationClient sshAuthenticationClient) throws AuthenticationProtocolException {
        SshPrivateKey sshPrivateKey;
        File file;
        block14: {
            JFileChooser jFileChooser;
            if (!(sshAuthenticationClient instanceof PublicKeyAuthenticationClient)) {
                throw new AuthenticationProtocolException("PublicKeyAuthenticationClient instance required");
            }
            this.instance = (PublicKeyAuthenticationClient)sshAuthenticationClient;
            file = this.instance.getKeyfile() == null ? null : new File(this.instance.getKeyfile());
            String string = null;
            SshPrivateKeyFile sshPrivateKeyFile = null;
            if (file == null || !file.exists()) {
                jFileChooser = new JFileChooser();
                jFileChooser.setFileHidingEnabled(false);
                jFileChooser.setDialogTitle("Select Private Key File For Authentication");
                if (jFileChooser.showOpenDialog(this.parent) == 0) {
                    file = jFileChooser.getSelectedFile();
                } else {
                    return false;
                }
            }
            jFileChooser = null;
            try {
                sshPrivateKeyFile = SshPrivateKeyFile.parse((File)file);
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                JOptionPane.showMessageDialog(this.parent, invalidSshKeyException.getMessage());
                return false;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.parent, iOException.getMessage());
            }
            if (sshPrivateKeyFile.isPassphraseProtected()) {
                Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
                PassphraseDialog passphraseDialog = null;
                passphraseDialog = window instanceof Frame ? new PassphraseDialog((Frame)window) : (window instanceof Dialog ? new PassphraseDialog((Dialog)window) : new PassphraseDialog());
                while (true) {
                    passphraseDialog.setVisible(true);
                    if (passphraseDialog.isCancelled()) {
                        return false;
                    }
                    string = new String(passphraseDialog.getPassphrase());
                    try {
                        sshPrivateKey = sshPrivateKeyFile.toPrivateKey(string);
                        break block14;
                    }
                    catch (InvalidSshKeyException invalidSshKeyException) {
                        passphraseDialog.setMessage("Passphrase Invalid! Try again");
                        passphraseDialog.setMessageForeground(Color.red);
                        continue;
                    }
                    break;
                }
            }
            try {
                sshPrivateKey = sshPrivateKeyFile.toPrivateKey(string);
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                return false;
            }
        }
        this.instance.setKey(sshPrivateKey);
        this.instance.setKeyfile(file.getAbsolutePath());
        return true;
    }
}

