/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;

public class SSH2AuthorizedKeysFormat
implements AuthorizedKeysFormat {
    private static final String header = "# Open3SP auto-generated authorization file\n";
    private static final String key = "key ";

    public byte[] format(AuthorizedKeys authorizedKeys) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] byArray) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys authorizedKeys, AuthorizedKeysFileSaver authorizedKeysFileSaver) throws IOException, InvalidSshKeyException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(header.getBytes("US-ASCII"));
        SECSHPublicKeyFormat sECSHPublicKeyFormat = new SECSHPublicKeyFormat();
        Iterator iterator = authorizedKeys.getAuthorizedKeys().entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getValue();
            String string2 = string + ".pub";
            sECSHPublicKeyFormat.setComment(string);
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create((SshPublicKey)((SshPublicKey)entry.getKey()), (SshPublicKeyFormat)sECSHPublicKeyFormat);
            authorizedKeysFileSaver.saveFile(string2, sshPublicKeyFile.toString().getBytes("US-ASCII"));
            byteArrayOutputStream.write(key.getBytes("US-ASCII"));
            byteArrayOutputStream.write(string2.getBytes("US-ASCII"));
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] byArray, AuthorizedKeysFileLoader authorizedKeysFileLoader) throws IOException, InvalidSshKeyException {
        String string;
        AuthorizedKeys authorizedKeys = new AuthorizedKeys();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        while ((string = bufferedReader.readLine()) != null) {
            if (!string.trim().startsWith("key")) continue;
            String string2 = string.substring(string.trim().lastIndexOf(" ") + 1).trim();
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse((byte[])authorizedKeysFileLoader.loadFile(string2));
            String string3 = string2.substring(0, string2.length() - 4);
            authorizedKeys.addKey(string3, sshPublicKeyFile.toPublicKey());
        }
        return authorizedKeys;
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}

