/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Properties;
import openbusidl.acs.Credential;
import openbusidl.acs.CredentialHelper;
import openbusidl.acs.CredentialHolder;
import openbusidl.acs.IAccessControlService;
import openbusidl.acs.ILeaseProvider;
import openbusidl.rs.IRegistryService;
import openbusidl.rs.ServiceOffer;
import openbusidl.ss.ISessionService;
import openbusidl.ss.ISessionServiceHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import scs.core.IComponent;
import tecgraf.openbus.exception.ACSLoginFailureException;
import tecgraf.openbus.exception.ACSUnavailableException;
import tecgraf.openbus.exception.InvalidCredentialException;
import tecgraf.openbus.exception.PKIException;
import tecgraf.openbus.interceptors.ClientInitializer;
import tecgraf.openbus.interceptors.ServerInitializer;
import tecgraf.openbus.lease.LeaseExpiredCallback;
import tecgraf.openbus.lease.LeaseRenewer;
import tecgraf.openbus.util.InvalidTypes;
import tecgraf.openbus.util.Log;
import tecgraf.openbus.util.Utils;

public final class Openbus {
    private static Openbus instance;
    private ORB orb;
    private boolean isORBFinished;
    private POA rootPOA;
    private static final String ORB_INITIALIZER_PROPERTY_NAME_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    private String host;
    private int port;
    private IAccessControlService acs;
    private ILeaseProvider lp;
    private LeaseRenewer leaseRenewer;
    private LeaseExpiredCallback leaseExpiredCallback;
    private IRegistryService rgs;
    private ISessionService ss;
    private CredentialHolder credential;
    private ThreadLocal<Credential> threadLocalCredential;
    private int requestCredentialSlot;
    private ConnectionStates connectionState;

    private void reset() {
        this.threadLocalCredential = new ThreadLocal();
        this.credential = new CredentialHolder();
        this.requestCredentialSlot = -1;
        if (!this.isORBFinished && this.orb != null) {
            this.finish(true);
        }
        this.orb = null;
        this.rootPOA = null;
        this.isORBFinished = false;
        this.acs = null;
        this.host = null;
        this.port = -1;
        this.lp = null;
        this.leaseRenewer = null;
        this.leaseExpiredCallback = null;
        this.rgs = null;
        this.ss = null;
        this.connectionState = ConnectionStates.DISCONNECTED;
    }

    private void fetchACS() throws ACSUnavailableException {
        this.acs = Utils.fetchAccessControlService(this.orb, this.host, this.port);
        this.lp = Utils.fetchAccessControlServiceLeaseProvider(this.orb, this.host, this.port);
    }

    private Openbus() {
        this.reset();
    }

    public static Openbus getInstance() {
        if (instance == null) {
            instance = new Openbus();
        }
        return instance;
    }

    public void resetAndInitialize(String[] args, Properties props, String host, int port) throws UserException {
        if (props == null) {
            throw new IllegalArgumentException("O campo 'props' n\u00e3o pode ser null");
        }
        if (host == null) {
            throw new IllegalArgumentException("O campo 'host' n\u00e3o pode ser null");
        }
        if (port < 0) {
            throw new IllegalArgumentException("O campo 'port' n\u00e3o pode ser negativo.");
        }
        this.reset();
        this.host = host;
        this.port = port;
        String clientInitializerClassName = ClientInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + clientInitializerClassName, clientInitializerClassName);
        String serverInitializerClassName = ServerInitializer.class.getName();
        props.put(ORB_INITIALIZER_PROPERTY_NAME_PREFIX + serverInitializerClassName, serverInitializerClassName);
        this.orb = ORB.init((String[])args, (Properties)props);
        Object obj = this.orb.resolve_initial_references("RootPOA");
        this.rootPOA = POAHelper.narrow((Object)obj);
        POAManager manager = this.rootPOA.the_POAManager();
        manager.activate();
    }

    public ORB getORB() {
        return this.orb;
    }

    public POA getRootPOA() {
        return this.rootPOA;
    }

    public void run() {
        this.orb.run();
    }

    public void finish(boolean force) {
        this.orb.shutdown(force);
        this.orb.destroy();
        this.isORBFinished = true;
    }

    public IAccessControlService getAccessControlService() {
        return this.acs;
    }

    public IRegistryService getRegistryService() {
        return this.rgs;
    }

    public ISessionService getSessionService() {
        if (this.ss == null && this.rgs != null) {
            ServiceOffer[] offers = this.rgs.find(new String[]{"ISessionService"});
            if (offers.length > 0) {
                IComponent component = offers[0].member;
                Object facet = component.getFacet(ISessionServiceHelper.id());
                if (facet == null) {
                    return null;
                }
                this.ss = ISessionServiceHelper.narrow((Object)facet);
                return this.ss;
            }
            return null;
        }
        return this.ss;
    }

    public Credential getCredential() {
        Credential threadCredential = this.threadLocalCredential.get();
        if (threadCredential != null) {
            return threadCredential;
        }
        if (this.credential == null) {
            return null;
        }
        return this.credential.value;
    }

    public void setThreadCredential(Credential credential) {
        this.threadLocalCredential.set(credential);
    }

    public void setInterceptedCredentialSlot(int interceptedCredentialSlot) {
        this.requestCredentialSlot = interceptedCredentialSlot;
    }

    public Credential getInterceptedCredential() {
        try {
            Current pic = CurrentHelper.narrow((Object)this.orb.resolve_initial_references("PICurrent"));
            Any requestCredentialValue = pic.get_slot(this.requestCredentialSlot);
            if (requestCredentialValue.type().kind().equals(TCKind.tk_null)) {
                return InvalidTypes.CREDENTIAL;
            }
            Credential requestCredential = CredentialHelper.extract((Any)requestCredentialValue);
            return requestCredential;
        }
        catch (UserException e) {
            Log.COMMON.severe("Erro ao obter a credencial da requisi\u00e7\u00e3o,", e);
            return InvalidTypes.CREDENTIAL;
        }
    }

    public IRegistryService connect(String user, String password) throws ACSLoginFailureException, ACSUnavailableException, InvalidCredentialException {
        if (user == null || password == null) {
            throw new IllegalArgumentException("Os par\u00e2metros 'user' e 'password' n\u00e3o podem ser nulos.");
        }
        ConnectionStates connectionStates = this.connectionState;
        synchronized (connectionStates) {
            if (this.connectionState == ConnectionStates.DISCONNECTED) {
                if (this.acs == null) {
                    this.fetchACS();
                }
                if (this.acs.loginByPassword(user, password, this.credential, new IntHolder())) {
                    this.leaseRenewer = new LeaseRenewer(this.credential.value, this.lp, this.leaseExpiredCallback);
                    this.leaseRenewer.start();
                    this.connectionState = ConnectionStates.CONNECTED;
                    this.rgs = this.acs.getRegistryService();
                    return this.rgs;
                }
                throw new ACSLoginFailureException("N\u00e3o foi poss\u00edvel conectar ao barramento.");
            }
            throw new ACSLoginFailureException("O barramento j\u00e1 est\u00e1 conectado.");
        }
    }

    public IRegistryService connect(String name, RSAPrivateKey privateKey, X509Certificate acsCertificate) throws ACSLoginFailureException, PKIException, ACSUnavailableException, InvalidCredentialException {
        if (name == null || privateKey == null || acsCertificate == null) {
            throw new IllegalArgumentException("Nenhum par\u00e2metro pode ser nulo.");
        }
        ConnectionStates connectionStates = this.connectionState;
        synchronized (connectionStates) {
            if (this.connectionState == ConnectionStates.DISCONNECTED) {
                byte[] answer;
                byte[] challenge;
                if (this.acs == null) {
                    this.fetchACS();
                }
                if ((challenge = this.acs.getChallenge(name)).length == 0) {
                    throw new ACSLoginFailureException("Desafio inv\u00e1lido.");
                }
                try {
                    answer = Utils.generateAnswer(challenge, privateKey, acsCertificate);
                }
                catch (GeneralSecurityException e) {
                    throw new PKIException(e);
                }
                if (this.acs.loginByCertificate(name, answer, this.credential, new IntHolder())) {
                    this.leaseRenewer = new LeaseRenewer(this.credential.value, this.lp, this.leaseExpiredCallback);
                    this.leaseRenewer.start();
                    this.connectionState = ConnectionStates.CONNECTED;
                    this.rgs = this.acs.getRegistryService();
                    return this.rgs;
                }
                throw new ACSLoginFailureException("N\u00e3o foi poss\u00edvel conectar ao barramento.");
            }
            throw new ACSLoginFailureException("O barramento j\u00e1 est\u00e1 conectado.");
        }
    }

    public IRegistryService connect(Credential credential) throws InvalidCredentialException, ACSUnavailableException {
        if (credential == null) {
            throw new IllegalArgumentException("O par\u00e2metro 'credential' n\u00e3o pode ser nulo.");
        }
        if (this.acs == null) {
            this.fetchACS();
        }
        this.credential = new CredentialHolder(credential);
        if (this.acs.isValid(credential)) {
            if (this.rgs == null) {
                this.rgs = this.acs.getRegistryService();
            }
            return this.rgs;
        }
        throw new InvalidCredentialException(new NO_PERMISSION("Credencial inv\u00e1lida."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect() throws SystemException {
        ConnectionStates connectionStates = this.connectionState;
        synchronized (connectionStates) {
            if (this.connectionState == ConnectionStates.CONNECTED) {
                boolean status = false;
                try {
                    this.leaseRenewer.finish();
                    this.leaseRenewer = null;
                    status = this.acs.logout(this.credential.value);
                }
                catch (SystemException e) {
                    this.connectionState = ConnectionStates.CONNECTED;
                    throw e;
                }
                if (status) {
                    this.reset();
                } else {
                    this.connectionState = ConnectionStates.CONNECTED;
                }
                return status;
            }
            return false;
        }
    }

    public boolean isConnected() {
        return this.connectionState == ConnectionStates.CONNECTED;
    }

    public void addLeaseExpiredCallback(LeaseExpiredCallback lec) {
        this.leaseExpiredCallback = lec;
        if (this.connectionState == ConnectionStates.CONNECTED) {
            this.leaseRenewer.setLeaseExpiredCallback(lec);
        }
    }

    public void removeLeaseExpiredCallback() {
        this.leaseExpiredCallback = null;
        if (this.connectionState == ConnectionStates.CONNECTED) {
            this.leaseRenewer.setLeaseExpiredCallback(null);
        }
    }

    private static enum ConnectionStates {
        CONNECTED,
        DISCONNECTED;

    }
}

