/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus;

import java.util.ArrayList;
import tecgraf.openbus.util.Host;
import tecgraf.openbus.util.Log;
import tecgraf.openbus.util.PropertiesLoaderImpl;

public class FaultToleranceManager {
    private ArrayList<Host> acsHosts = new ArrayList();
    private Host acsHostInUse;
    private int currIndex = 0;
    private static FaultToleranceManager ftManager;
    private int trials = 1;
    private int currTrial = 0;

    private FaultToleranceManager() {
        this.setHosts();
    }

    public static FaultToleranceManager getInstance() {
        if (ftManager == null) {
            ftManager = new FaultToleranceManager();
        }
        return ftManager;
    }

    private void setHosts() {
        if (this.acsHosts == null) {
            this.acsHosts = new ArrayList();
        }
        String[] hostsStr = PropertiesLoaderImpl.getValor("hosts").split(",");
        for (int i = 0; i < hostsStr.length; ++i) {
            String[] hostStr = hostsStr[i].split(":");
            String name = hostStr[0];
            int port = Integer.valueOf(hostStr[1]);
            this.acsHosts.add(new Host(name, port));
        }
        this.acsHostInUse = this.acsHosts.get(this.currIndex);
        String _trials = PropertiesLoaderImpl.getValor("trials");
        if (_trials.length() > 0) {
            this.trials = Integer.valueOf(_trials);
        }
    }

    public ArrayList<Host> getHosts() {
        return this.acsHosts;
    }

    public void setHosts(ArrayList<Host> hosts) {
        this.acsHosts = hosts;
    }

    public Host getACSHostInUse() {
        return this.acsHostInUse;
    }

    public void setACSHostInUse(Host hostInUse) {
        this.acsHostInUse = hostInUse;
    }

    public boolean updateACSHostInUse() {
        Log.COMMON.finest("currTrial: " + this.currTrial);
        if (this.currTrial == this.trials) {
            return false;
        }
        if (this.currIndex == this.acsHosts.size() - 1) {
            this.currIndex = 0;
            ++this.currTrial;
        } else {
            ++this.currIndex;
        }
        this.acsHostInUse = this.acsHosts.get(this.currIndex);
        return true;
    }

    public void resetCurrTrial() {
        this.currTrial = 0;
    }
}

