/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.authenticators;

import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import org.omg.CORBA.IntHolder;
import tecgraf.openbus.authenticators.Authenticator;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.CredentialHolder;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.exception.ACSLoginFailureException;
import tecgraf.openbus.exception.PKIException;
import tecgraf.openbus.util.Utils;

public class CertificateAuthenticator
implements Authenticator {
    private String entityName;
    private RSAPrivateKey privateKey;
    private X509Certificate acsCertificate;

    public CertificateAuthenticator(String entityName, RSAPrivateKey privateKey, X509Certificate acsCertificate) {
        this.entityName = entityName;
        this.privateKey = privateKey;
        this.acsCertificate = acsCertificate;
    }

    @Override
    public Credential authenticate(IAccessControlService acs) throws ACSLoginFailureException, PKIException {
        byte[] answer;
        byte[] challenge = acs.getChallenge(this.entityName);
        if (challenge.length == 0) {
            throw new ACSLoginFailureException(MessageFormat.format("N\u00e3o foi poss\u00edvel realizar a autentica\u00e7\u00e3o no barramento. Provavelmente, a entidade {0} n\u00e3o est\u00e1 cadastrada.", this.entityName));
        }
        try {
            answer = Utils.generateAnswer(challenge, this.privateKey, this.acsCertificate);
        }
        catch (GeneralSecurityException e) {
            throw new PKIException("Ocorreu um erro ao realizar a autentica\u00e7\u00e3o no barramento. Verifique se a chave privada utilizada corresponde ao certificado digital cadastrado.", e);
        }
        CredentialHolder credentialHolder = new CredentialHolder();
        if (acs.loginByCertificate(this.entityName, answer, credentialHolder, new IntHolder())) {
            return credentialHolder.value;
        }
        return null;
    }
}

