/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.interceptors;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import tecgraf.openbus.Openbus;
import tecgraf.openbus.access_control_service.CredentialWrapper;
import tecgraf.openbus.core.v1_05.access_control_service.Credential;
import tecgraf.openbus.core.v1_05.access_control_service.IAccessControlService;
import tecgraf.openbus.util.Log;

final class CachedCredentialValidatorServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static long TASK_DELAY = 300000L;
    private static int MAXIMUM_CREDENTIALS_CACHE_SIZE = 20;
    private static CachedCredentialValidatorServerInterceptor instance;
    private Deque<CredentialWrapper> credentials = new LinkedList<CredentialWrapper>();
    private Lock lock = new ReentrantLock();
    private Timer timer = new Timer();

    private CachedCredentialValidatorServerInterceptor() {
        this.timer.schedule((TimerTask)new CredentialValidatorTask(), TASK_DELAY);
        Log.INTERCEPTORS.config("Cache de credenciais com capacidade m\u00e1xima de " + MAXIMUM_CREDENTIALS_CACHE_SIZE + " credenciais.");
        Log.INTERCEPTORS.config("Revalida\u00e7\u00e3o do cache realizada a cada " + TASK_DELAY + " milisegundos.");
    }

    public static CachedCredentialValidatorServerInterceptor getInstance() {
        if (instance == null) {
            instance = new CachedCredentialValidatorServerInterceptor();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
        boolean isValid;
        String method;
        String repID;
        Openbus bus = Openbus.getInstance();
        boolean isInterceptable = bus.isInterceptable(repID = ri.target_most_derived_interface(), method = ri.operation());
        if (!isInterceptable) {
            Log.INTERCEPTORS.info(String.format("Opera\u00e7\u00e3o '%s' n\u00e3o interceptada no servidor.", method));
            return;
        }
        Credential interceptedCredential = bus.getInterceptedCredential();
        if (interceptedCredential == null) {
            Log.INTERCEPTORS.warning("Nenhuma credencial foi interceptada.");
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        CredentialWrapper wrapper = new CredentialWrapper(interceptedCredential);
        this.lock.lock();
        try {
            if (this.credentials.remove(wrapper)) {
                Log.INTERCEPTORS.fine("A credencial interceptada " + wrapper + " est\u00e1 no cache.");
                this.credentials.offerLast(wrapper);
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        Log.INTERCEPTORS.fine("A credencial interceptada " + wrapper + " n\u00e3o est\u00e1 no cache.");
        IAccessControlService acs = bus.getAccessControlService();
        try {
            isValid = acs.isValid(interceptedCredential);
        }
        catch (SystemException e) {
            Log.INTERCEPTORS.severe("Erro ao tentar validar uma credencial.", e);
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
        if (isValid) {
            Log.INTERCEPTORS.info("A credencial interceptada " + wrapper + " \u00e9 v\u00e1lida.");
            this.lock.lock();
            try {
                if (this.credentials.size() == MAXIMUM_CREDENTIALS_CACHE_SIZE) {
                    Log.INTERCEPTORS.info("O cache est\u00e1 cheio.");
                    this.credentials.pollFirst();
                }
                this.credentials.offerLast(new CredentialWrapper(interceptedCredential));
            }
            finally {
                this.lock.unlock();
            }
        } else {
            Log.INTERCEPTORS.warning("A credencial interceptada " + wrapper + " n\u00e3o \u00e9 v\u00e1lida.");
            throw new NO_PERMISSION(0, CompletionStatus.COMPLETED_NO);
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void destroy() {
        this.timer.cancel();
    }

    public String name() {
        return CachedCredentialValidatorServerInterceptor.class.getName();
    }

    private class CredentialValidatorTask
    extends TimerTask {
        private CredentialValidatorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                CachedCredentialValidatorServerInterceptor.this.lock.lock();
                try {
                    if (CachedCredentialValidatorServerInterceptor.this.credentials.size() > 0) {
                        boolean[] results;
                        Log.INTERCEPTORS.info("Executando a tarefa de valida\u00e7\u00e3o de credenciais.");
                        CredentialWrapper[] credentialWrapperArray = CachedCredentialValidatorServerInterceptor.this.credentials.toArray(new CredentialWrapper[0]);
                        Credential[] credentialArray = new Credential[credentialWrapperArray.length];
                        for (int i = 0; i < credentialArray.length; ++i) {
                            credentialArray[i] = credentialWrapperArray[i].getCredential();
                        }
                        Openbus bus = Openbus.getInstance();
                        IAccessControlService acs = bus.getAccessControlService();
                        try {
                            results = acs.areValid(credentialArray);
                        }
                        catch (SystemException e) {
                            Log.INTERCEPTORS.severe("Erro ao tentar validar as credenciais.", e);
                            CachedCredentialValidatorServerInterceptor.this.lock.unlock();
                            return;
                        }
                        for (int i = 0; i < results.length; ++i) {
                            if (!results[i]) {
                                Log.INTERCEPTORS.finest("A credencial " + credentialWrapperArray[i] + " n\u00e3o \u00e9 mais v\u00e1lida.");
                                CachedCredentialValidatorServerInterceptor.this.credentials.remove(credentialWrapperArray[i]);
                                continue;
                            }
                            Log.INTERCEPTORS.finest("A credencial " + credentialWrapperArray[i] + " ainda \u00e9 v\u00e1lida.");
                        }
                        break block10;
                    }
                    Log.INTERCEPTORS.info("Tarefa de valida\u00e7\u00e3o de credenciais n\u00e3o foi executada pois n\u00e3o existem credenciais no cache.");
                }
                finally {
                    CachedCredentialValidatorServerInterceptor.this.lock.unlock();
                }
            }
        }
    }
}

