/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.util;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class LoadLog
extends Logger {
    public LoadLog(String name) {
        super(name, null);
        this.setUseParentHandlers(false);
        StreamHandler handler = null;
        try {
            File dir = new File("testOutput");
            if (!dir.exists() && !dir.mkdir()) {
                System.out.println("Erro ao criar diretorio!");
                handler = new ConsoleHandler();
                handler.setFormatter(LoadLogFormatter.getInstance());
                this.addHandler(handler);
            }
            if (handler == null) {
                handler = new FileHandler("testOutput/OpenbusLog.txt", 10000000, 5, true);
                handler.setFormatter(LoadLogFormatter.getInstance());
                this.addHandler(handler);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            handler = new ConsoleHandler();
            handler.setFormatter(LoadLogFormatter.getInstance());
            this.addHandler(handler);
        }
        catch (IOException e) {
            e.printStackTrace();
            handler = new ConsoleHandler();
            handler.setFormatter(LoadLogFormatter.getInstance());
            this.addHandler(handler);
        }
    }

    private static class LoadLogFormatter
    extends Formatter {
        private static LoadLogFormatter instance;
        private SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM; HH:mm:ss");

        private LoadLogFormatter() {
        }

        static LoadLogFormatter getInstance() {
            if (instance == null) {
                instance = new LoadLogFormatter();
            }
            return instance;
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder message = new StringBuilder();
            message.append("[");
            message.append(record.getLoggerName());
            message.append(" ");
            message.append(record.getLevel());
            message.append("]");
            message.append(" ");
            Date recordDate = new Date(record.getMillis());
            message.append(this.dateFormatter.format(recordDate));
            message.append("; ");
            message.append(this.formatMessage(record));
            message.append("; ");
            Throwable t = record.getThrown();
            if (t != null) {
                message.append("Exce\u00e7\u00e3o: ");
                message.append(LoadLogFormatter.format(t));
            }
            message.append("\n");
            return message.toString();
        }

        private static String format(Throwable t) {
            StringBuilder message = new StringBuilder();
            message.append(t.getClass().getName());
            message.append(": ");
            if (t.getMessage() != null) {
                message.append(t.getMessage().trim());
            }
            message.append("\n");
            for (StackTraceElement element : t.getStackTrace()) {
                message.append("==> ");
                message.append(element.getClassName());
                message.append(".");
                message.append(element.getMethodName());
                message.append(" (");
                if (element.isNativeMethod()) {
                    message.append("M\u00e9todo Nativo");
                } else {
                    String fileName = element.getFileName();
                    if (fileName == null) {
                        message.append("Desconhecido");
                    } else {
                        message.append(fileName);
                        int lineNumber = element.getLineNumber();
                        if (lineNumber > 0) {
                            message.append(":");
                            message.append(lineNumber);
                        }
                    }
                }
                message.append(")\n");
            }
            if (t.getCause() != null && t.getCause() != t) {
                message.append("Causada por: ");
                message.append(LoadLogFormatter.format(t.getCause()));
            }
            return message.toString();
        }
    }
}

