/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Hello;
import demo.HelloHelper;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.core.v2_0.OctetSeqHolder;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public final class Client {
    public static void main(String[] args) throws FileNotFoundException {
        ServiceOfferDesc[] services;
        LoginProcess process;
        String entity;
        int port;
        if (args.length < 3) {
            String params = "[file]";
            String desc = "\n  - [file] = arquivo a ser gerado com informa\u00e7\u00f5es do compartilhamento de autentica\u00e7\u00e3o (opcional)";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> [password] %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - password = senha (opcional) %s", params, desc));
            System.exit(1);
            return;
        }
        String host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        String password = entity = args[2];
        if (args.length > 3) {
            password = args[3];
        }
        String file = "sharedauth.dat";
        if (args.length > 4) {
            file = args[4];
        }
        Assistant assist = Assistant.createWithPassword((String)host, (int)port, (String)entity, (byte[])password.getBytes());
        OctetSeqHolder secret = new OctetSeqHolder();
        try {
            process = assist.startSharedAuth(secret, -1);
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            System.err.println("Erro inesperado durante compartilhamento de autentica\u00e7\u00e3o.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        PrintWriter out = new PrintWriter(file);
        out.println(assist.orb().object_to_string((Object)process));
        out.println(new String(secret.value));
        out.close();
        ServiceProperty[] properties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Hello")};
        try {
            services = assist.findServices(properties, -1);
        }
        catch (ServiceFailure e) {
            System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
            System.exit(1);
            return;
        }
        catch (TRANSIENT e) {
            System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
            System.exit(1);
            return;
        }
        catch (COMM_FAILURE e) {
            System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
            System.exit(1);
            return;
        }
        catch (NO_PERMISSION e) {
            if (e.minor == 1112888319) {
                System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
            }
            System.exit(1);
            return;
        }
        catch (Throwable e) {
            System.err.println("Erro inesperado durante busca de servi\u00e7os.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        block24: for (ServiceOfferDesc offerDesc : services) {
            try {
                Object helloObj = offerDesc.service_ref.getFacet(HelloHelper.id());
                if (helloObj == null) {
                    System.out.println("o servi\u00e7o encontrado n\u00e3o prov\u00ea a faceta ofertada");
                    continue;
                }
                Hello hello = HelloHelper.narrow(helloObj);
                hello.sayHello();
            }
            catch (TRANSIENT e) {
                System.err.println("o servi\u00e7o encontrado encontra-se indispon\u00edvel");
            }
            catch (COMM_FAILURE e) {
                System.err.println("falha de comunica\u00e7\u00e3o com o servi\u00e7o encontrado");
            }
            catch (NO_PERMISSION e) {
                switch (e.minor) {
                    case 1112888319: {
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                        continue block24;
                    }
                    case 1112888068: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o est\u00e1 mais logado ao barramento");
                        continue block24;
                    }
                    case 1112888067: {
                        System.err.println("o servi\u00e7o encontrado n\u00e3o foi capaz de validar a chamada");
                        continue block24;
                    }
                    case 1112888318: {
                        System.err.println("integra\u00e7\u00e3o do servi\u00e7o encontrado com o barramento est\u00e1 incorreta");
                    }
                }
            }
        }
        assist.shutdown();
    }
}

