/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.ClockHelper;
import demo.ClockImpl;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.Servant;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.exception.SCSException;
import tecgraf.openbus.Connection;
import tecgraf.openbus.InvalidLoginCallback;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.PrivateKey;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.OpenBusPrivateKey;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_0.services.access_control.MissingCertificate;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidProperties;
import tecgraf.openbus.core.v2_0.services.offer_registry.InvalidService;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_0.services.offer_registry.UnauthorizedFacets;
import tecgraf.openbus.exception.AlreadyLoggedIn;

public final class DedicatedClockServer {
    private static String host;
    private static int port;
    private static String entity;
    private static OpenBusPrivateKey privateKey;
    private static int interval;

    public static void main(String[] args) throws InvalidName, AdapterInactive, SCSException, AlreadyLoggedIn, ServiceFailure {
        if (args.length < 4) {
            String params = "[interval]";
            String desc = "\n  - [interval] = Tempo de espera entre tentativas de acesso ao barramento. Valor padr\u00e3o \u00e9 '1'";
            System.out.println(String.format("Usage: 'demo' <host> <port> <entity> <privatekeypath> %s\n  - host = \u00e9 o host do barramento\n  - port = \u00e9 a porta do barramento\n  - entity = \u00e9 a entidade a ser autenticada\n  - privatekeypath = \u00e9 o caminho da chave privada de autentica\u00e7\u00e3o da entidade %s", params, desc));
            System.exit(1);
            return;
        }
        host = args[0];
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.out.println("Valor de <port> deve ser um n\u00famero");
            System.exit(1);
            return;
        }
        entity = args[2];
        String privateKeyFile = args[3];
        try {
            privateKey = OpenBusPrivateKey.createPrivateKeyFromFile((String)privateKeyFile);
        }
        catch (Exception e) {
            System.out.println("<privatekeypath> deve apontar para uma chave v\u00e1lida.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (args.length > 4) {
            try {
                interval = Integer.parseInt(args[4]);
            }
            catch (NumberFormatException e) {
                System.out.println("Valor de [interval] deve ser um n\u00famero");
                System.exit(1);
                return;
            }
        }
        final ORB orb = ORBInitializer.initORB();
        Thread run = new Thread(){

            @Override
            public void run() {
                orb.run();
            }
        };
        run.start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                orb.shutdown(true);
                orb.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
        final OpenBusContext context = (OpenBusContext)orb.resolve_initial_references("OpenBusContext");
        POA poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        ComponentId id = new ComponentId("Clock", 1, 0, 0, "java");
        final ComponentContext component = new ComponentContext(orb, poa, id);
        component.addFacet("Clock", ClockHelper.id(), (Servant)new ClockImpl());
        Connection conn = context.createConnection(host, port);
        context.setDefaultConnection(conn);
        conn.onInvalidLoginCallback(new InvalidLoginCallback(){
            ConcurrencyControl options = new ConcurrencyControl();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invalidLogin(Connection conn, LoginInfo login) {
                java.lang.Object object = this.options.lock;
                synchronized (object) {
                    this.options.disabled = false;
                }
                this.login(conn, entity, (PrivateKey)privateKey, host, port, interval);
                object = this.options.lock;
                synchronized (object) {
                    if (!this.options.disabled && !this.options.active) {
                        this.options.active = true;
                        Thread register = new Thread(){

                            @Override
                            public void run() {
                                this.register(context, component, interval);
                            }
                        };
                        register.start();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void login(Connection conn, String entity, PrivateKey privateKey, java.lang.Object host, java.lang.Object port, int sleepTime) {
                boolean failed;
                do {
                    failed = false;
                    try {
                        conn.loginByCertificate(entity, privateKey);
                    }
                    catch (AlreadyLoggedIn e) {
                        failed = false;
                    }
                    catch (AccessDenied e) {
                        failed = true;
                        System.err.println(String.format("a chave utilizada n\u00e3o corresponde ao certificado da entidade '%s'", entity));
                    }
                    catch (MissingCertificate e) {
                        failed = true;
                        System.err.println(String.format("a entidade %s n\u00e3o possui um certificado registrado", entity));
                    }
                    catch (ServiceFailure e) {
                        failed = true;
                        System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                    }
                    catch (TRANSIENT e) {
                        failed = true;
                        System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                    }
                    catch (COMM_FAILURE e) {
                        failed = true;
                        System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                    }
                    catch (NO_PERMISSION e) {
                        failed = true;
                        if (e.minor != 1112888319) continue;
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                    }
                    finally {
                        if (failed) {
                            try {
                                Thread.sleep(sleepTime * 1000);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                } while (failed);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void register(OpenBusContext context2, ComponentContext component2, int sleepTime) {
                boolean failed;
                do {
                    failed = true;
                    try {
                        ServiceProperty[] serviceProperties = new ServiceProperty[]{new ServiceProperty("offer.domain", "Demo Dedicated Clock")};
                        context2.getOfferRegistry().registerService(component2.getIComponent(), serviceProperties);
                        failed = false;
                        java.lang.Object object = this.options.lock;
                        synchronized (object) {
                            this.options.disabled = true;
                        }
                    }
                    catch (UnauthorizedFacets e) {
                        StringBuffer interfaces = new StringBuffer();
                        for (String string : e.facets) {
                            interfaces.append("\n  - ");
                            interfaces.append(string);
                        }
                        System.err.println(String.format("a entidade '%s' n\u00e3o foi autorizada pelo administrador do barramento a ofertar os servi\u00e7os: %s", entity, interfaces.toString()));
                    }
                    catch (InvalidService e) {
                        System.err.println("o servi\u00e7o ofertado apresentou alguma falha durante o registro.");
                    }
                    catch (InvalidProperties e) {
                        StringBuffer props = new StringBuffer();
                        for (String string : e.properties) {
                            props.append("\n  - ");
                            props.append(String.format("name = %s, value = %s", ((ServiceProperty)string).name, ((ServiceProperty)string).value));
                        }
                        System.err.println(String.format("tentativa de registrar servi\u00e7o com propriedades inv\u00e1lidas: %s", props.toString()));
                    }
                    catch (ServiceFailure e) {
                        System.err.println(String.format("falha severa no barramento em %s:%s : %s", host, port, e.message));
                    }
                    catch (TRANSIENT e) {
                        System.err.println(String.format("o barramento em %s:%s esta inacess\u00edvel no momento", host, port));
                    }
                    catch (COMM_FAILURE e) {
                        System.err.println("falha de comunica\u00e7\u00e3o ao acessar servi\u00e7os n\u00facleo do barramento");
                    }
                    catch (NO_PERMISSION e) {
                        if (e.minor != 1112888319) continue;
                        System.err.println(String.format("n\u00e3o h\u00e1 um login de '%s' v\u00e1lido no momento", entity));
                    }
                    finally {
                        if (failed) {
                            try {
                                Thread.sleep(sleepTime * 1000);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                } while (failed);
                java.lang.Object object = this.options.lock;
                synchronized (object) {
                    this.options.active = false;
                }
            }
        });
        conn.onInvalidLoginCallback().invalidLogin(conn, null);
    }

    static {
        interval = 1;
    }

    public static class ConcurrencyControl {
        public volatile boolean active = false;
        public volatile boolean disabled = false;
        public java.lang.Object lock = new java.lang.Object();
    }
}

