/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.BucketsPath;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class BucketPathAggregation
extends AggregationBase {
    @Nullable
    private final BucketsPath bucketsPath;

    protected BucketPathAggregation(AbstractBuilder<?> builder) {
        super(builder);
        this.bucketsPath = ((AbstractBuilder)builder).bucketsPath;
    }

    @Nullable
    public final BucketsPath bucketsPath() {
        return this.bucketsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bucketsPath != null) {
            generator.writeKey("buckets_path");
            this.bucketsPath.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBucketPathAggregationDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::bucketsPath, BucketsPath._DESERIALIZER, "buckets_path");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private BucketsPath bucketsPath;

        public final BuilderT bucketsPath(@Nullable BucketsPath value) {
            this.bucketsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT bucketsPath(Function<BucketsPath.Builder, ObjectBuilder<BucketsPath>> fn) {
            return this.bucketsPath(fn.apply(new BucketsPath.Builder()).build());
        }
    }
}

