/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter;

import com.artofsolving.jodconverter.BasicDocumentFormatRegistry;
import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentFamily;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;

public class XmlDocumentFormatRegistry
extends BasicDocumentFormatRegistry
implements DocumentFormatRegistry {
    private static final String DEFAULT_CONFIGURATION = "/" + XmlDocumentFormatRegistry.class.getPackage().getName().replace('.', '/') + "/document-formats.xml";

    public XmlDocumentFormatRegistry() {
        this.load(this.getClass().getResourceAsStream(DEFAULT_CONFIGURATION));
    }

    public XmlDocumentFormatRegistry(InputStream inputStream) {
        this.load(inputStream);
    }

    private void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        XStream xstream = XmlDocumentFormatRegistry.createXStream();
        try {
            ObjectInputStream in = xstream.createObjectInputStream((Reader)new InputStreamReader(inputStream));
            try {
                while (true) {
                    this.addDocumentFormat((DocumentFormat)in.readObject());
                }
            }
            catch (EOFException endOfFile) {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException("invalid registry configuration", exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
        }
    }

    private static XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.setMode(1001);
        xstream.alias("document-format", DocumentFormat.class);
        xstream.aliasField("mime-type", DocumentFormat.class, "mimeType");
        xstream.aliasField("file-extension", DocumentFormat.class, "fileExtension");
        xstream.aliasField("export-filters", DocumentFormat.class, "exportFilters");
        xstream.aliasField("export-options", DocumentFormat.class, "exportOptions");
        xstream.aliasField("import-options", DocumentFormat.class, "importOptions");
        xstream.alias("family", DocumentFamily.class);
        xstream.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class type) {
                return type.equals(class$com$artofsolving$jodconverter$DocumentFamily == null ? (class$com$artofsolving$jodconverter$DocumentFamily = XmlDocumentFormatRegistry.class$("com.artofsolving.jodconverter.DocumentFamily")) : class$com$artofsolving$jodconverter$DocumentFamily);
            }

            public Object fromString(String name) {
                return DocumentFamily.getFamily(name);
            }

            public String toString(Object object) {
                DocumentFamily family = (DocumentFamily)object;
                return family.getName();
            }
        });
        return xstream;
    }

    public static void main(String[] args) throws IOException {
        DefaultDocumentFormatRegistry registry = new DefaultDocumentFormatRegistry();
        XStream xstream = XmlDocumentFormatRegistry.createXStream();
        ObjectOutputStream outputStream = xstream.createObjectOutputStream((Writer)new OutputStreamWriter(System.out), "document-formats");
        Iterator iterator = registry.getDocumentFormats().iterator();
        while (iterator.hasNext()) {
            outputStream.writeObject(iterator.next());
        }
        outputStream.close();
    }
}

