/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

public abstract class ViewMatcher {
    public abstract boolean isVisibleForView(Class<?> var1);

    public static ViewMatcher construct(Class<?>[] views) {
        if (views == null) {
            return Empty.instance;
        }
        switch (views.length) {
            case 0: {
                return Empty.instance;
            }
            case 1: {
                return new Single(views[0]);
            }
        }
        return new Multi(views);
    }

    private static final class Multi
    extends ViewMatcher {
        private final Class<?>[] _views;

        public Multi(Class<?>[] v) {
            this._views = v;
        }

        @Override
        public boolean isVisibleForView(Class<?> activeView) {
            for (Class<?> view : this._views) {
                if (activeView != view && !view.isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Single
    extends ViewMatcher {
        private final Class<?> _view;

        public Single(Class<?> v) {
            this._view = v;
        }

        @Override
        public boolean isVisibleForView(Class<?> activeView) {
            return activeView == this._view || this._view.isAssignableFrom(activeView);
        }
    }

    private static final class Empty
    extends ViewMatcher {
        static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public boolean isVisibleForView(Class<?> activeView) {
            return false;
        }
    }
}

