/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.InnerClassProperty;
import com.fasterxml.jackson.databind.deser.impl.ManagedReferenceProperty;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BeanDeserializerBase
extends StdDeserializer<Object>
implements ContextualDeserializer,
ResolvableDeserializer,
Serializable {
    private static final long serialVersionUID = -2038793552422727904L;
    private final transient Annotations _classAnnotations;
    protected final JavaType _beanType;
    protected final JsonFormat.Shape _serializationShape;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected boolean _nonStandardCreation;
    protected boolean _vanillaProcessing;
    protected final BeanPropertyMap _beanProperties;
    protected final ValueInjector[] _injectables;
    protected SettableAnyProperty _anySetter;
    protected final HashSet<String> _ignorableProps;
    protected final boolean _ignoreAllUnknown;
    protected final boolean _needViewProcesing;
    protected final Map<String, SettableBeanProperty> _backRefs;
    protected transient HashMap<ClassKey, JsonDeserializer<Object>> _subDeserializers;
    protected UnwrappedPropertyHandler _unwrappedPropertyHandler;
    protected ExternalTypeHandler _externalTypeIdHandler;
    protected final ObjectIdReader _objectIdReader;

    protected BeanDeserializerBase(BeanDeserializerBuilder beanDeserializerBuilder, BeanDescription beanDescription, BeanPropertyMap beanPropertyMap, Map<String, SettableBeanProperty> map, HashSet<String> hashSet, boolean bl, boolean bl2) {
        super(beanDescription.getType());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        this._classAnnotations = annotatedClass.getAnnotations();
        this._beanType = beanDescription.getType();
        this._valueInstantiator = beanDeserializerBuilder.getValueInstantiator();
        this._beanProperties = beanPropertyMap;
        this._backRefs = map;
        this._ignorableProps = hashSet;
        this._ignoreAllUnknown = bl;
        this._anySetter = beanDeserializerBuilder.getAnySetter();
        List<ValueInjector> list = beanDeserializerBuilder.getInjectables();
        this._injectables = list == null || list.isEmpty() ? null : list.toArray(new ValueInjector[list.size()]);
        this._objectIdReader = beanDeserializerBuilder.getObjectIdReader();
        this._nonStandardCreation = this._unwrappedPropertyHandler != null || this._valueInstantiator.canCreateUsingDelegate() || this._valueInstantiator.canCreateFromObjectWith() || !this._valueInstantiator.canCreateUsingDefault();
        JsonFormat.Value value = beanDescription.findExpectedFormat(null);
        this._serializationShape = value == null ? null : value.getShape();
        this._needViewProcesing = bl2;
        this._vanillaProcessing = !this._nonStandardCreation && this._injectables == null && !this._needViewProcesing && this._objectIdReader != null;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase) {
        this(beanDeserializerBase, beanDeserializerBase._ignoreAllUnknown);
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, boolean bl) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._beanProperties = beanDeserializerBase._beanProperties;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = bl;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
    }

    protected BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, NameTransformer nameTransformer) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = nameTransformer != null || beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        UnwrappedPropertyHandler unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        if (nameTransformer != null) {
            if (unwrappedPropertyHandler != null) {
                unwrappedPropertyHandler = unwrappedPropertyHandler.renameAll(nameTransformer);
            }
            this._beanProperties = beanDeserializerBase._beanProperties.renameAll(nameTransformer);
        } else {
            this._beanProperties = beanDeserializerBase._beanProperties;
        }
        this._unwrappedPropertyHandler = unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = false;
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, ObjectIdReader objectIdReader) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = beanDeserializerBase._ignorableProps;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = objectIdReader;
        if (objectIdReader == null) {
            this._beanProperties = beanDeserializerBase._beanProperties;
        } else {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(objectIdReader, true);
            this._beanProperties = beanDeserializerBase._beanProperties.withProperty(objectIdValueProperty);
        }
    }

    public BeanDeserializerBase(BeanDeserializerBase beanDeserializerBase, HashSet<String> hashSet) {
        super(beanDeserializerBase._beanType);
        this._classAnnotations = beanDeserializerBase._classAnnotations;
        this._beanType = beanDeserializerBase._beanType;
        this._valueInstantiator = beanDeserializerBase._valueInstantiator;
        this._delegateDeserializer = beanDeserializerBase._delegateDeserializer;
        this._propertyBasedCreator = beanDeserializerBase._propertyBasedCreator;
        this._backRefs = beanDeserializerBase._backRefs;
        this._ignorableProps = hashSet;
        this._ignoreAllUnknown = beanDeserializerBase._ignoreAllUnknown;
        this._anySetter = beanDeserializerBase._anySetter;
        this._injectables = beanDeserializerBase._injectables;
        this._nonStandardCreation = beanDeserializerBase._nonStandardCreation;
        this._unwrappedPropertyHandler = beanDeserializerBase._unwrappedPropertyHandler;
        this._needViewProcesing = beanDeserializerBase._needViewProcesing;
        this._serializationShape = beanDeserializerBase._serializationShape;
        this._vanillaProcessing = beanDeserializerBase._vanillaProcessing;
        this._objectIdReader = beanDeserializerBase._objectIdReader;
        this._beanProperties = beanDeserializerBase._beanProperties;
    }

    @Override
    public abstract JsonDeserializer<Object> unwrappingDeserializer(NameTransformer var1);

    public abstract BeanDeserializerBase withObjectIdReader(ObjectIdReader var1);

    public abstract BeanDeserializerBase withIgnorableProperties(HashSet<String> var1);

    protected abstract BeanDeserializerBase asArrayDeserializer();

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        Object object;
        Object object2;
        ExternalTypeHandler.Builder builder = null;
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object2 = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object2);
            for (SettableBeanProperty serializable : this._propertyBasedCreator.properties()) {
                if (!serializable.hasValueTypeDeserializer() || ((TypeDeserializer)(object = serializable.getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
                if (builder == null) {
                    builder = new ExternalTypeHandler.Builder();
                }
                builder.addExternal(serializable, (TypeDeserializer)object);
            }
        }
        object2 = null;
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            Object object3;
            JsonDeserializer<Object> jsonDeserializer;
            object = settableBeanProperty;
            if (!((SettableBeanProperty)object).hasValueDeserializer()) {
                jsonDeserializer = this.findConvertingDeserializer(deserializationContext, (SettableBeanProperty)object);
                if (jsonDeserializer == null) {
                    jsonDeserializer = this.findDeserializer(deserializationContext, ((SettableBeanProperty)object).getType(), (BeanProperty)object);
                }
                object = ((SettableBeanProperty)object).withValueDeserializer(jsonDeserializer);
            } else {
                jsonDeserializer = ((SettableBeanProperty)object).getValueDeserializer();
                if (jsonDeserializer instanceof ContextualDeserializer && (object3 = ((ContextualDeserializer)((Object)jsonDeserializer)).createContextual(deserializationContext, (BeanProperty)object)) != jsonDeserializer) {
                    object = ((SettableBeanProperty)object).withValueDeserializer((JsonDeserializer<?>)object3);
                }
            }
            object = this._resolveManagedReferenceProperty(deserializationContext, (SettableBeanProperty)object);
            jsonDeserializer = this._resolveUnwrappedProperty(deserializationContext, (SettableBeanProperty)object);
            if (jsonDeserializer != null) {
                object = jsonDeserializer;
                if (object2 == null) {
                    object2 = new UnwrappedPropertyHandler();
                }
                object2.addProperty((SettableBeanProperty)object);
                continue;
            }
            if ((object = this._resolveInnerClassValuedProperty(deserializationContext, (SettableBeanProperty)object)) != settableBeanProperty) {
                this._beanProperties.replace((SettableBeanProperty)object);
            }
            if (!((SettableBeanProperty)object).hasValueTypeDeserializer() || ((TypeDeserializer)(object3 = ((SettableBeanProperty)object).getValueTypeDeserializer())).getTypeInclusion() != JsonTypeInfo.As.EXTERNAL_PROPERTY) continue;
            if (builder == null) {
                builder = new ExternalTypeHandler.Builder();
            }
            builder.addExternal((SettableBeanProperty)object, (TypeDeserializer)object3);
            this._beanProperties.remove((SettableBeanProperty)object);
        }
        if (this._anySetter != null && !this._anySetter.hasValueDeserializer()) {
            this._anySetter = this._anySetter.withValueDeserializer(this.findDeserializer(deserializationContext, this._anySetter.getType(), this._anySetter.getProperty()));
        }
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            JavaType javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (javaType == null) {
                throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._beanType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
            }
            AnnotatedWithParams annotatedWithParams = this._valueInstantiator.getDelegateCreator();
            object = new BeanProperty.Std(null, javaType, null, this._classAnnotations, annotatedWithParams, false);
            this._delegateDeserializer = this.findDeserializer(deserializationContext, javaType, (BeanProperty)object);
        }
        if (builder != null) {
            this._externalTypeIdHandler = builder.build();
            this._nonStandardCreation = true;
        }
        this._unwrappedPropertyHandler = object2;
        if (object2 != null) {
            this._nonStandardCreation = true;
        }
        this._vanillaProcessing = this._vanillaProcessing && !this._nonStandardCreation;
    }

    protected JsonDeserializer<Object> findConvertingDeserializer(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && (object = annotationIntrospector.findDeserializationConverter(settableBeanProperty.getMember())) != null) {
            Converter<Object, Object> converter = deserializationContext.converterInstance(settableBeanProperty.getMember(), object);
            JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
            JsonDeserializer<Object> jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, settableBeanProperty);
            return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        AnnotatedMember annotatedMember;
        ObjectIdReader objectIdReader = this._objectIdReader;
        String[] stringArray = null;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        if (beanProperty != null && annotationIntrospector != null) {
            stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedMember);
            object3 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object3 != null) {
                ObjectIdGenerator objectIdGenerator;
                SettableBeanProperty settableBeanProperty;
                Object object4;
                object2 = ((ObjectIdInfo)(object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object3))).getGeneratorType();
                if (object2 == ObjectIdGenerators.PropertyGenerator.class) {
                    object4 = ((ObjectIdInfo)object3).getPropertyName();
                    settableBeanProperty = this.findProperty((String)object4);
                    if (settableBeanProperty == null) {
                        throw new IllegalArgumentException("Invalid Object Id definition for " + this.getBeanClass().getName() + ": can not find property with name '" + object4 + "'");
                    }
                    object = settableBeanProperty.getType();
                    objectIdGenerator = new ObjectIdGenerator(((ObjectIdInfo)object3).getScope());
                } else {
                    object4 = deserializationContext.constructType((Class<?>)object2);
                    object = deserializationContext.getTypeFactory().findTypeParameters((JavaType)object4, ObjectIdGenerator.class)[0];
                    settableBeanProperty = null;
                    objectIdGenerator = deserializationContext.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
                }
                object4 = deserializationContext.findRootValueDeserializer((JavaType)object);
                objectIdReader = ObjectIdReader.construct((JavaType)object, ((ObjectIdInfo)object3).getPropertyName(), objectIdGenerator, object4, settableBeanProperty);
            }
        }
        object3 = this;
        if (objectIdReader != null && objectIdReader != this._objectIdReader) {
            object3 = ((BeanDeserializerBase)object3).withObjectIdReader(objectIdReader);
        }
        if (stringArray != null && stringArray.length != 0) {
            object2 = ArrayBuilders.setAndArray(((BeanDeserializerBase)object3)._ignorableProps, stringArray);
            object3 = ((BeanDeserializerBase)object3).withIgnorableProperties((HashSet<String>)object2);
        }
        object2 = null;
        if (annotatedMember != null && (object = annotationIntrospector.findFormat((Annotated)annotatedMember)) != null) {
            object2 = object.getShape();
        }
        if (object2 == null) {
            object2 = this._serializationShape;
        }
        if (object2 == JsonFormat.Shape.ARRAY) {
            object3 = ((BeanDeserializerBase)object3).asArrayDeserializer();
        }
        return object3;
    }

    protected SettableBeanProperty _resolveManagedReferenceProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        JsonDeserializer<Object> jsonDeserializer;
        String string = settableBeanProperty.getManagedReferenceName();
        if (string == null) {
            return settableBeanProperty;
        }
        JsonDeserializer<Object> jsonDeserializer2 = settableBeanProperty.getValueDeserializer();
        SettableBeanProperty settableBeanProperty2 = null;
        boolean bl = false;
        if (jsonDeserializer2 instanceof BeanDeserializerBase) {
            settableBeanProperty2 = ((BeanDeserializerBase)jsonDeserializer2).findBackReference(string);
        } else if (jsonDeserializer2 instanceof ContainerDeserializerBase) {
            jsonDeserializer = ((ContainerDeserializerBase)jsonDeserializer2).getContentDeserializer();
            if (!(jsonDeserializer instanceof BeanDeserializerBase)) {
                String string2 = jsonDeserializer == null ? "NULL" : jsonDeserializer.getClass().getName();
                throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': value deserializer is of type ContainerDeserializerBase, but content type is not handled by a BeanDeserializer " + " (instead it's of type " + string2 + ")");
            }
            settableBeanProperty2 = ((BeanDeserializerBase)jsonDeserializer).findBackReference(string);
            bl = true;
        } else if (jsonDeserializer2 instanceof AbstractDeserializer) {
            settableBeanProperty2 = ((AbstractDeserializer)jsonDeserializer2).findBackReference(string);
        } else {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': type for value deserializer is not BeanDeserializer or ContainerDeserializerBase, but " + jsonDeserializer2.getClass().getName());
        }
        if (settableBeanProperty2 == null) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': no back reference property found from type " + settableBeanProperty.getType());
        }
        jsonDeserializer = this._beanType;
        JavaType javaType = settableBeanProperty2.getType();
        if (!javaType.getRawClass().isAssignableFrom(((JavaType)((Object)jsonDeserializer)).getRawClass())) {
            throw new IllegalArgumentException("Can not handle managed/back reference '" + string + "': back reference type (" + javaType.getRawClass().getName() + ") not compatible with managed type (" + ((JavaType)((Object)jsonDeserializer)).getRawClass().getName() + ")");
        }
        return new ManagedReferenceProperty(settableBeanProperty, string, settableBeanProperty2, this._classAnnotations, bl);
    }

    protected SettableBeanProperty _resolveUnwrappedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        JsonDeserializer<Object> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2;
        NameTransformer nameTransformer;
        AnnotatedMember annotatedMember = settableBeanProperty.getMember();
        if (annotatedMember != null && (nameTransformer = deserializationContext.getAnnotationIntrospector().findUnwrappingNameTransformer(annotatedMember)) != null && (jsonDeserializer2 = (jsonDeserializer = settableBeanProperty.getValueDeserializer()).unwrappingDeserializer(nameTransformer)) != jsonDeserializer && jsonDeserializer2 != null) {
            return settableBeanProperty.withValueDeserializer(jsonDeserializer2);
        }
        return null;
    }

    protected SettableBeanProperty _resolveInnerClassValuedProperty(DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) {
        Class<?> clazz;
        Class<?> clazz2;
        BeanDeserializerBase beanDeserializerBase;
        ValueInstantiator valueInstantiator;
        JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
        if (jsonDeserializer instanceof BeanDeserializerBase && !(valueInstantiator = (beanDeserializerBase = (BeanDeserializerBase)jsonDeserializer).getValueInstantiator()).canCreateUsingDefault() && (clazz2 = ClassUtil.getOuterClass(clazz = settableBeanProperty.getType().getRawClass())) != null && clazz2 == this._beanType.getRawClass()) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 1 || classArray[0] != clazz2) continue;
                if (deserializationContext.getConfig().canOverrideAccessModifiers()) {
                    ClassUtil.checkAndFixAccess(constructor);
                }
                return new InnerClassProperty(settableBeanProperty, constructor);
            }
        }
        return settableBeanProperty;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public boolean hasProperty(String string) {
        return this._beanProperties.find(string) != null;
    }

    public boolean hasViews() {
        return this._needViewProcesing;
    }

    public int getPropertyCount() {
        return this._beanProperties.size();
    }

    @Override
    public Collection<Object> getKnownPropertyNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (SettableBeanProperty settableBeanProperty : this._beanProperties) {
            arrayList.add(settableBeanProperty.getName());
        }
        return arrayList;
    }

    public final Class<?> getBeanClass() {
        return this._beanType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._beanType;
    }

    public Iterator<SettableBeanProperty> properties() {
        if (this._beanProperties == null) {
            throw new IllegalStateException("Can only call after BeanDeserializer has been resolved");
        }
        return this._beanProperties.iterator();
    }

    public Iterator<SettableBeanProperty> creatorProperties() {
        if (this._propertyBasedCreator == null) {
            return Collections.emptyList().iterator();
        }
        return this._propertyBasedCreator.properties().iterator();
    }

    public SettableBeanProperty findProperty(String string) {
        SettableBeanProperty settableBeanProperty;
        SettableBeanProperty settableBeanProperty2 = settableBeanProperty = this._beanProperties == null ? null : this._beanProperties.find(string);
        if (settableBeanProperty == null && this._propertyBasedCreator != null) {
            settableBeanProperty = this._propertyBasedCreator.findCreatorProperty(string);
        }
        return settableBeanProperty;
    }

    public SettableBeanProperty findBackReference(String string) {
        if (this._backRefs == null) {
            return null;
        }
        return this._backRefs.get(string);
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public void replaceProperty(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        this._beanProperties.replace(settableBeanProperty2);
    }

    public abstract Object deserializeFromObject(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        if (this._objectIdReader != null && (jsonToken = jsonParser.getCurrentToken()) != null && jsonToken.isScalarValue()) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    protected Object deserializeWithObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        String string = this._objectIdReader.propertyName;
        if (string.equals(jsonParser.getCurrentName())) {
            return this.deserializeFromObject(jsonParser, deserializationContext);
        }
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        TokenBuffer tokenBuffer2 = null;
        while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            object = jsonParser.getCurrentName();
            if (tokenBuffer2 == null) {
                if (string.equals(object)) {
                    tokenBuffer2 = new TokenBuffer(jsonParser.getCodec());
                    tokenBuffer2.writeFieldName((String)object);
                    jsonParser.nextToken();
                    tokenBuffer2.copyCurrentStructure(jsonParser);
                    tokenBuffer2.append(tokenBuffer);
                    tokenBuffer = null;
                } else {
                    tokenBuffer.writeFieldName((String)object);
                    jsonParser.nextToken();
                    tokenBuffer.copyCurrentStructure(jsonParser);
                }
            } else {
                tokenBuffer2.writeFieldName((String)object);
                jsonParser.nextToken();
                tokenBuffer2.copyCurrentStructure(jsonParser);
            }
            jsonParser.nextToken();
        }
        object = tokenBuffer2 == null ? tokenBuffer : tokenBuffer2;
        ((TokenBuffer)((Object)object)).writeEndObject();
        JsonParser jsonParser2 = ((TokenBuffer)((Object)object)).asParser();
        jsonParser2.nextToken();
        return this.deserializeFromObject(jsonParser2, deserializationContext);
    }

    protected Object deserializeFromObjectId(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object = this._objectIdReader.deserializer.deserialize(jsonParser, deserializationContext);
        ReadableObjectId readableObjectId = deserializationContext.findObjectId(object, this._objectIdReader.generator);
        Object object2 = readableObjectId.item;
        if (object2 == null) {
            throw new IllegalStateException("Could not resolve Object Id [" + object + "] (for " + this._beanType + ") -- unresolved forward-reference?");
        }
        return object2;
    }

    protected Object deserializeFromObjectUsingNonDefault(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingPropertyBased(jsonParser, deserializationContext);
        }
        if (this._beanType.isAbstract()) {
            throw JsonMappingException.from(jsonParser, "Can not instantiate abstract type " + this._beanType + " (need to add/enable type information?)");
        }
        throw JsonMappingException.from(jsonParser, "No suitable constructor found for type " + this._beanType + ": can not instantiate from JSON object (need to add/enable type information?)");
    }

    protected abstract Object _deserializeUsingPropertyBased(JsonParser var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    public Object deserializeFromNumber(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        switch (jsonParser.getNumberType()) {
            case INT: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromInt(deserializationContext, jsonParser.getIntValue());
            }
            case LONG: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromInt()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromLong(deserializationContext, jsonParser.getLongValue());
            }
        }
        if (this._delegateDeserializer != null) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON integer number");
    }

    public Object deserializeFromString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._objectIdReader != null) {
            return this.deserializeFromObjectId(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromString()) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        return this._valueInstantiator.createFromString(deserializationContext, jsonParser.getText());
    }

    public Object deserializeFromDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        switch (jsonParser.getNumberType()) {
            case FLOAT: 
            case DOUBLE: {
                if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromDouble()) {
                    Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                    if (this._injectables != null) {
                        this.injectValues(deserializationContext, object);
                    }
                    return object;
                }
                return this._valueInstantiator.createFromDouble(deserializationContext, jsonParser.getDoubleValue());
            }
        }
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        throw deserializationContext.instantiationException(this.getBeanClass(), "no suitable creator method found to deserialize from JSON floating-point number");
    }

    public Object deserializeFromBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null && !this._valueInstantiator.canCreateFromBoolean()) {
            Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
            if (this._injectables != null) {
                this.injectValues(deserializationContext, object);
            }
            return object;
        }
        boolean bl = jsonParser.getCurrentToken() == JsonToken.VALUE_TRUE;
        return this._valueInstantiator.createFromBoolean(deserializationContext, bl);
    }

    public Object deserializeFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (this._delegateDeserializer != null) {
            try {
                Object object = this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
                if (this._injectables != null) {
                    this.injectValues(deserializationContext, object);
                }
                return object;
            }
            catch (Exception exception) {
                this.wrapInstantiationProblem(exception, deserializationContext);
            }
        }
        throw deserializationContext.mappingException(this.getBeanClass());
    }

    protected void injectValues(DeserializationContext deserializationContext, Object object) throws IOException, JsonProcessingException {
        for (ValueInjector valueInjector : this._injectables) {
            valueInjector.inject(deserializationContext, object);
        }
    }

    @Override
    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException, JsonProcessingException {
        if (this._ignoreAllUnknown || this._ignorableProps != null && this._ignorableProps.contains(string)) {
            jsonParser.skipChildren();
            return;
        }
        super.handleUnknownProperty(jsonParser, deserializationContext, object, string);
    }

    protected Object handleUnknownProperties(DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException, JsonProcessingException {
        tokenBuffer.writeEndObject();
        JsonParser jsonParser = tokenBuffer.asParser();
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
        }
        return object;
    }

    protected void handleUnknownVanilla(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, String string) throws IOException, JsonProcessingException {
        if (this._ignorableProps != null && this._ignorableProps.contains(string)) {
            jsonParser.skipChildren();
        } else if (this._anySetter != null) {
            try {
                this._anySetter.deserializeAndSet(jsonParser, deserializationContext, object, string);
            }
            catch (Exception exception) {
                this.wrapAndThrow((Throwable)exception, object, string, deserializationContext);
            }
        } else {
            this.handleUnknownProperty(jsonParser, deserializationContext, object, string);
        }
    }

    protected Object handlePolymorphic(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> jsonDeserializer = this._findSubclassDeserializer(deserializationContext, object, tokenBuffer);
        if (jsonDeserializer != null) {
            if (tokenBuffer != null) {
                tokenBuffer.writeEndObject();
                JsonParser jsonParser2 = tokenBuffer.asParser();
                jsonParser2.nextToken();
                object = jsonDeserializer.deserialize(jsonParser2, deserializationContext, object);
            }
            if (jsonParser != null) {
                object = jsonDeserializer.deserialize(jsonParser, deserializationContext, object);
            }
            return object;
        }
        if (tokenBuffer != null) {
            object = this.handleUnknownProperties(deserializationContext, object, tokenBuffer);
        }
        if (jsonParser != null) {
            object = this.deserialize(jsonParser, deserializationContext, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer<Object> _findSubclassDeserializer(DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException, JsonProcessingException {
        JsonDeserializer<Object> jsonDeserializer;
        Serializable serializable = this;
        synchronized (serializable) {
            jsonDeserializer = this._subDeserializers == null ? null : this._subDeserializers.get(new ClassKey(object.getClass()));
        }
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        serializable = deserializationContext.constructType(object.getClass());
        jsonDeserializer = deserializationContext.findRootValueDeserializer((JavaType)serializable);
        if (jsonDeserializer != null) {
            BeanDeserializerBase beanDeserializerBase = this;
            synchronized (beanDeserializerBase) {
                if (this._subDeserializers == null) {
                    this._subDeserializers = new HashMap();
                }
                this._subDeserializers.put(new ClassKey(object.getClass()), jsonDeserializer);
            }
        }
        return jsonDeserializer;
    }

    public void wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    public void wrapAndThrow(Throwable throwable, Object object, int n, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, n);
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonProcessingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    protected void wrapInstantiationProblem(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw deserializationContext.instantiationException(this._beanType.getRawClass(), throwable);
    }
}

