/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable;

import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.map.ImmutableMap;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.multimap.set.MutableSetMultimap;
import com.gs.collections.api.partition.bag.PartitionMutableBag;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.block.factory.Predicates;
import com.gs.collections.impl.block.procedure.PartitionPredicate2Procedure;
import com.gs.collections.impl.block.procedure.PartitionProcedure;
import com.gs.collections.impl.block.procedure.SelectInstancesOfProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectByteProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectCharProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectIntProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectLongProcedure;
import com.gs.collections.impl.block.procedure.primitive.CollectShortProcedure;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.list.fixed.ArrayAdapter;
import com.gs.collections.impl.map.mutable.AbstractMutableMapIterable;
import com.gs.collections.impl.map.mutable.SynchronizedMutableMap;
import com.gs.collections.impl.map.mutable.UnmodifiableMutableMap;
import com.gs.collections.impl.multimap.bag.HashBagMultimap;
import com.gs.collections.impl.partition.bag.PartitionHashBag;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.utility.MapIterate;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableMap<K, V>
extends AbstractMutableMapIterable<K, V>
implements MutableMap<K, V> {
    public abstract MutableMap<K, V> clone();

    public abstract <K, V> MutableMap<K, V> newEmpty(int var1);

    public MutableMap<K, V> asUnmodifiable() {
        return UnmodifiableMutableMap.of(this);
    }

    public ImmutableMap<K, V> toImmutable() {
        return Maps.immutable.withAll((Map)((Object)this));
    }

    public MutableMap<K, V> asSynchronized() {
        return SynchronizedMutableMap.of(this);
    }

    public MutableSetMultimap<V, K> flip() {
        return MapIterate.flip(this);
    }

    public <R> MutableMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return MapIterate.collectValues(this, function, this.newEmpty(this.size()));
    }

    public MutableMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.selectMapOnEntry(this, predicate, this.newEmpty());
    }

    public MutableMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        return MapIterate.rejectMapOnEntry(this, predicate, this.newEmpty());
    }

    public <R> MutableBag<R> collect(Function<? super V, ? extends R> function) {
        return this.collect(function, HashBag.newBag());
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        BooleanHashBag result = new BooleanHashBag();
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, (MutableBooleanCollection)result));
        return result;
    }

    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        ByteHashBag result = new ByteHashBag();
        this.forEach(new CollectByteProcedure<V>(byteFunction, (MutableByteCollection)result));
        return result;
    }

    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        CharHashBag result = new CharHashBag();
        this.forEach(new CollectCharProcedure<V>(charFunction, (MutableCharCollection)result));
        return result;
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        DoubleHashBag result = new DoubleHashBag();
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, (MutableDoubleCollection)result));
        return result;
    }

    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        FloatHashBag result = new FloatHashBag();
        this.forEach(new CollectFloatProcedure<V>(floatFunction, (MutableFloatCollection)result));
        return result;
    }

    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        IntHashBag result = new IntHashBag();
        this.forEach(new CollectIntProcedure<V>(intFunction, (MutableIntCollection)result));
        return result;
    }

    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        LongHashBag result = new LongHashBag();
        this.forEach(new CollectLongProcedure<V>(longFunction, (MutableLongCollection)result));
        return result;
    }

    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        ShortHashBag result = new ShortHashBag();
        this.forEach(new CollectShortProcedure<V>(shortFunction, (MutableShortCollection)result));
        return result;
    }

    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect((Function<? super V, ? extends R>)((Function)Functions.bind(function, parameter)));
    }

    public <R> MutableBag<R> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends R> function) {
        return this.collectIf(predicate, function, new HashBag());
    }

    public <R> MutableBag<R> flatCollect(Function<? super V, ? extends Iterable<R>> function) {
        return this.flatCollect(function, new HashBag());
    }

    public MutableBag<V> select(Predicate<? super V> predicate) {
        return this.select(predicate, new HashBag());
    }

    public MutableMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public MutableBag<V> reject(Predicate<? super V> predicate) {
        return this.reject(predicate, new HashBag());
    }

    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionProcedure<V>(predicate, partitionMutableBag));
        return partitionMutableBag;
    }

    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionHashBag partitionMutableBag = new PartitionHashBag();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionMutableBag));
        return partitionMutableBag;
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag();
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result;
    }

    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, new HashBag(this.size()));
    }

    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(new UnifiedSet(this.size()));
    }

    public MutableMap<K, V> withKeyValue(K key, V value) {
        this.put(key, value);
        return this;
    }

    public MutableMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        for (Pair<K, V> pair : keyValues) {
            this.put(pair.getOne(), pair.getTwo());
        }
        return this;
    }

    public MutableMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValues) {
        return this.withAllKeyValues((Iterable<? extends Pair<? extends K, ? extends V>>)((Object)ArrayAdapter.adapt(keyValues)));
    }

    public MutableMap<K, V> withoutKey(K key) {
        this.removeKey(key);
        return this;
    }

    public MutableMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        for (K key : keys) {
            this.removeKey(key);
        }
        return this;
    }

    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        return this.groupBy(function, HashBagMultimap.newMultimap());
    }

    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        return this.groupByEach(function, HashBagMultimap.newMultimap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ValuesCollectionCommon<V>
    implements Collection<V> {
        protected ValuesCollectionCommon() {
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }
    }
}

