/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableShortSingletonSet
implements ImmutableShortSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short element;

    ImmutableShortSingletonSet(short element) {
        this.element = element;
    }

    public ImmutableShortSet newWith(short element) {
        return ShortSets.immutable.with(new short[]{this.element, element});
    }

    public ImmutableShortSet newWithout(short element) {
        return this.element == element ? ShortSets.immutable.with() : this;
    }

    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return elements.contains(this.element) ? ShortSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(short value) {
        return this.element == value;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(ShortProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableShortSet select(ShortPredicate predicate) {
        return predicate.accept(this.element) ? ShortHashSet.newSetWith(this.element).toImmutable() : new ShortHashSet().toImmutable();
    }

    public ImmutableShortSet reject(ShortPredicate predicate) {
        return predicate.accept(this.element) ? new ShortHashSet().toImmutable() : ShortHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(short item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure) {
        shortIntProcedure.value(this.element, 1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(ShortPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public short min() {
        return this.element;
    }

    public short max() {
        return this.element;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.element;
    }

    public short minIfEmpty(short defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public short[] toSortedArray() {
        return new short[]{this.element};
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet set = (ShortSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element;
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.element);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.element);
    }

    public ShortSet freeze() {
        return this;
    }

    public ImmutableShortSet toImmutable() {
        return this;
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public short[] toArray() {
        return new short[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)ShortHashSet.newSetWith(this.element).shortIterator());
    }
}

