/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.stack.ImmutableStack;
import com.gs.collections.api.stack.primitive.CharStack;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.factory.primitive.CharStacks;
import com.gs.collections.impl.iterator.UnmodifiableCharIterator;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.stack.mutable.primitive.CharArrayStack;
import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableCharSingletonStack
implements ImmutableCharStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final char element1;

    ImmutableCharSingletonStack(char element) {
        this.element1 = element;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(CharArrayStack.newStackWith(this.element1).charIterator());
    }

    public void forEach(CharProcedure procedure) {
        procedure.value(this.element1);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public char peek() {
        return this.element1;
    }

    public CharList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new CharArrayList(0);
        }
        if (count == 1) {
            return CharArrayList.newListWith(this.element1);
        }
        throw new IllegalArgumentException("Count must be less than or equal to size: Count = " + count + " Size = 1");
    }

    public char peekAt(int index) {
        this.checkNegativeCount(index);
        if (index == 0) {
            return this.element1;
        }
        throw new IllegalArgumentException("Index must be less than size: Index = " + index + " Size = 1");
    }

    public ImmutableCharStack select(CharPredicate predicate) {
        return predicate.accept(this.element1) ? CharStacks.immutable.with(this.element1) : CharStacks.immutable.with();
    }

    public ImmutableCharStack reject(CharPredicate predicate) {
        return predicate.accept(this.element1) ? CharStacks.immutable.with() : CharStacks.immutable.with(this.element1);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableStack<V> collect(CharToObjectFunction<? extends V> function) {
        return Stacks.immutable.with(function.valueOf(this.element1));
    }

    public long sum() {
        return this.element1;
    }

    public char max() {
        return this.element1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.element1;
    }

    public char min() {
        return this.element1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public char[] toSortedArray() {
        return new char[]{this.element1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.element1);
    }

    public char[] toArray() {
        return new char[]{this.element1};
    }

    public boolean contains(char value) {
        return this.element1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.element1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.element1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.element1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharStack toImmutable() {
        return this;
    }

    public ImmutableCharStack push(char element) {
        return CharStacks.immutable.with(new char[]{this.element1, element});
    }

    public ImmutableCharStack pop() {
        return CharStacks.immutable.with();
    }

    public ImmutableCharStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        if (count == 1) {
            return CharStacks.immutable.with();
        }
        throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = 1");
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof CharStack)) {
            return false;
        }
        CharStack stack = (CharStack)otherStack;
        if (stack.size() != 1) {
            return false;
        }
        return this.element1 == stack.peek();
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

