/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;

public class HTMLBugReporter
extends BugCollectionBugReporter {
    private String stylesheet;
    private Exception fatalException;

    public HTMLBugReporter(Project project, String stylesheet) {
        super(project);
        this.stylesheet = stylesheet;
    }

    public void finish() {
        block2: {
            try {
                BugCollection bugCollection = this.getBugCollection();
                bugCollection.setWithMessages(true);
                Document document = bugCollection.toDocument();
                InputStream xslInputStream = HTMLBugReporter.getStylesheetStream(this.stylesheet);
                StreamSource xsl = new StreamSource(xslInputStream);
                xsl.setSystemId(this.stylesheet);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(xsl);
                DocumentSource source = new DocumentSource(document);
                StreamResult result = new StreamResult(this.outputStream);
                transformer.transform((Source)source, result);
            }
            catch (Exception e) {
                this.logError("Could not generate HTML output", e);
                this.fatalException = e;
                if (!FindBugs.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public Exception getFatalException() {
        return this.fatalException;
    }

    private static InputStream getStylesheetStream(String stylesheet) throws IOException {
        if (FindBugs.DEBUG) {
            System.out.println("Attempting to load stylesheet " + stylesheet);
        }
        try {
            URL u = new URL(stylesheet);
            return u.openStream();
        }
        catch (Exception e) {
            try {
                return new BufferedInputStream(new FileInputStream(stylesheet));
            }
            catch (Exception fnfe) {
                InputStream xslInputStream = HTMLBugReporter.class.getResourceAsStream("/" + stylesheet);
                if (xslInputStream == null) {
                    throw new IOException("Could not load HTML generation stylesheet " + stylesheet);
                }
                return xslInputStream;
            }
        }
    }
}

