/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ProgramPoint;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.IncompatibleTypes;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.UnreadFields;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSummary {
    private Set<XField> writtenOutsideOfConstructor = new HashSet<XField>();
    private Map<XField, OpcodeStack.Item> summary = new HashMap<XField, OpcodeStack.Item>();
    private Map<XMethod, Set<XField>> fieldsWritten = new HashMap<XMethod, Set<XField>>();
    private Map<XMethod, XMethod> nonVoidSuperConstructorsCalled = new HashMap<XMethod, XMethod>();
    private Map<XMethod, Set<ProgramPoint>> selfMethodsCalledFromConstructor = new HashMap<XMethod, Set<ProgramPoint>>();
    private Set<ClassDescriptor> callsOverriddenMethodsFromConstructor = new HashSet<ClassDescriptor>();
    private boolean complete = false;

    public OpcodeStack.Item getSummary(XField field) {
        if (field == null) {
            return new OpcodeStack.Item();
        }
        OpcodeStack.Item result = this.summary.get(field);
        if (result == null || field.isVolatile()) {
            String signature = field.getSignature();
            return new OpcodeStack.Item(signature);
        }
        return result;
    }

    public boolean callsOverriddenMethodsFromConstructor(ClassDescriptor c) {
        return this.callsOverriddenMethodsFromConstructor.contains(c);
    }

    public boolean callsOverriddenMethodsFromSuperConstructor(ClassDescriptor c) {
        try {
            do {
                XClass cx;
                if ((c = (cx = Global.getAnalysisCache().getClassAnalysis(XClass.class, c)).getSuperclassDescriptor()) != null) continue;
                return false;
            } while (!this.callsOverriddenMethodsFromConstructor(c));
            return true;
        }
        catch (CheckedAnalysisException e) {
            return false;
        }
    }

    public void setCalledFromSuperConstructor(ProgramPoint from, XMethod calledFromConstructor) {
        Set<ProgramPoint> set = this.selfMethodsCalledFromConstructor.get(calledFromConstructor);
        if (set == null) {
            set = new HashSet<ProgramPoint>();
            this.selfMethodsCalledFromConstructor.put(calledFromConstructor, set);
        }
        set.add(from);
        this.callsOverriddenMethodsFromConstructor.add(from.method.getClassDescriptor());
    }

    public Set<ProgramPoint> getCalledFromSuperConstructor(ClassDescriptor superClass, XMethod calledFromConstructor) {
        if (!this.callsOverriddenMethodsFromConstructor.contains(superClass)) {
            return Collections.emptySet();
        }
        for (Map.Entry<XMethod, Set<ProgramPoint>> e : this.selfMethodsCalledFromConstructor.entrySet()) {
            XMethod m = e.getKey();
            if (!m.getName().equals(calledFromConstructor.getName()) || !m.getClassDescriptor().equals(calledFromConstructor.getClassDescriptor())) continue;
            String sig1 = m.getSignature();
            String sig2 = calledFromConstructor.getSignature();
            if (!(sig1 = sig1.substring(0, sig1.indexOf(41))).equals(sig2 = sig2.substring(0, sig2.indexOf(41)))) continue;
            return e.getValue();
        }
        return Collections.emptySet();
    }

    public void setFieldsWritten(XMethod method, Collection<XField> fields) {
        if (fields.isEmpty()) {
            return;
        }
        if (fields.size() == 1) {
            this.fieldsWritten.put(method, Collections.singleton(Util.first(fields)));
            return;
        }
        HashSet<XField> set = new HashSet<XField>(10 * fields.size() / 7 + 1);
        set.addAll(fields);
        this.fieldsWritten.put(method, set);
    }

    public Set<XField> getFieldsWritten(XMethod method) {
        Set<XField> result = this.fieldsWritten.get(method);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public boolean isWrittenOutsideOfConstructor(XField field) {
        if (field.isFinal()) {
            return false;
        }
        if (this.writtenOutsideOfConstructor.contains(field)) {
            return true;
        }
        if (!AnalysisContext.currentAnalysisContext().unreadFieldsAvailable()) {
            return true;
        }
        UnreadFields unreadFields = AnalysisContext.currentAnalysisContext().getUnreadFields();
        return unreadFields.isReflexive(field);
    }

    public boolean addWrittenOutsideOfConstructor(XField field) {
        return this.writtenOutsideOfConstructor.add(field);
    }

    public void mergeSummary(XField fieldOperand, OpcodeStack.Item mergeValue) {
        OpcodeStack.Item oldSummary;
        Type fieldType;
        String mSignature;
        Type mergeType;
        IncompatibleTypes check;
        if (SystemProperties.ASSERTIONS_ENABLED && (check = IncompatibleTypes.getPriorityForAssumingCompatible(mergeType = Type.getType((String)(mSignature = mergeValue.getSignature())), fieldType = Type.getType((String)fieldOperand.getSignature()), false)).getPriority() <= 2) {
            AnalysisContext.logError(fieldOperand + " not compatible with " + mergeValue, new IllegalArgumentException(check.toString()));
        }
        if ((oldSummary = this.summary.get(fieldOperand)) != null) {
            OpcodeStack.Item newValue = OpcodeStack.Item.merge(mergeValue, oldSummary);
            newValue.clearNewlyAllocated();
            this.summary.put(fieldOperand, newValue);
        } else {
            if (mergeValue.isNewlyAllocated()) {
                mergeValue = new OpcodeStack.Item(mergeValue);
                mergeValue.clearNewlyAllocated();
            }
            this.summary.put(fieldOperand, mergeValue);
        }
    }

    public void setComplete(boolean complete) {
        int fields = 0;
        int removed = 0;
        int retained = 0;
        this.complete = complete;
        if (this.isComplete()) {
            Iterator<Map.Entry<XField, OpcodeStack.Item>> i = this.summary.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<XField, OpcodeStack.Item> entry = i.next();
                OpcodeStack.Item defaultItem = new OpcodeStack.Item(entry.getKey().getSignature());
                ++fields;
                OpcodeStack.Item value = entry.getValue();
                value.makeCrossMethod();
                if (defaultItem.equals(value)) {
                    i.remove();
                    ++removed;
                    continue;
                }
                ++retained;
            }
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void sawSuperCall(XMethod from, XMethod constructorInSuperClass) {
        if (constructorInSuperClass == null || from == null) {
            return;
        }
        if (constructorInSuperClass.getSignature().equals("()V")) {
            return;
        }
        this.nonVoidSuperConstructorsCalled.put(from, constructorInSuperClass);
    }

    @CheckForNull
    public XMethod getSuperCall(XMethod from) {
        return this.nonVoidSuperConstructorsCalled.get(from);
    }
}

