/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import org.apache.bcel.generic.InstructionHandle;

public class PatternElementMatch {
    private final PatternElement patternElement;
    private final InstructionHandle matchedInstruction;
    private final BasicBlock basicBlock;
    private final int matchCount;
    private final PatternElementMatch prev;

    public PatternElementMatch(PatternElement patternElement, InstructionHandle matchedInstruction, BasicBlock basicBlock, int matchCount, PatternElementMatch prev) {
        this.patternElement = patternElement;
        this.matchedInstruction = matchedInstruction;
        this.basicBlock = basicBlock;
        this.matchCount = matchCount;
        this.prev = prev;
    }

    public PatternElement getPatternElement() {
        return this.patternElement;
    }

    public InstructionHandle getMatchedInstructionInstructionHandle() {
        return this.matchedInstruction;
    }

    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    public int getMatchCount() {
        return this.matchCount;
    }

    public PatternElementMatch getPrev() {
        return this.prev;
    }

    public InstructionHandle getLabeledInstruction(String label) {
        PatternElementMatch first = this.getFirstLabeledMatch(label);
        return first != null ? first.getMatchedInstructionInstructionHandle() : null;
    }

    public PatternElementMatch getFirstLabeledMatch(String label) {
        PatternElementMatch cur = this;
        PatternElementMatch result = null;
        while (cur != null) {
            String elementLabel = cur.patternElement.getLabel();
            if (elementLabel != null && elementLabel.equals(label)) {
                result = cur;
            }
            cur = cur.prev;
        }
        return result;
    }

    public PatternElementMatch getLastLabeledMatch(String label) {
        PatternElementMatch cur = this;
        while (cur != null) {
            String elementLabel = cur.patternElement.getLabel();
            if (elementLabel != null && elementLabel.equals(label)) {
                return cur;
            }
            cur = cur.prev;
        }
        return null;
    }

    public boolean allowTrailingEdges() {
        return this.patternElement.allowTrailingEdges();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        PatternElementMatch cur = this;
        buf.append(cur.patternElement.toString());
        buf.append(", ");
        buf.append(cur.matchedInstruction.toString());
        buf.append(", ");
        buf.append(cur.matchCount);
        return buf.toString();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PatternElementMatch)) {
            return false;
        }
        PatternElementMatch lhs = this;
        PatternElementMatch rhs = (PatternElementMatch)o;
        while (lhs != null && rhs != null) {
            if (lhs.patternElement != rhs.patternElement || lhs.matchedInstruction != rhs.matchedInstruction || lhs.matchCount != rhs.matchCount) {
                return false;
            }
            lhs = lhs.prev;
            rhs = rhs.prev;
        }
        return lhs == rhs;
    }
}

