/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SystemProperties;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Cloud {
    public BugCollection getBugCollection();

    public String getStatusMsg();

    public void addListener(CloudListener var1);

    public void removeListener(CloudListener var1);

    public boolean availableForInitialization();

    public boolean initialize();

    public void bugsPopulated();

    public void shutdown();

    public Mode getMode();

    public void setMode(Mode var1);

    public boolean getIWillFix(BugInstance var1);

    public boolean supportsSourceLinks();

    public String getUser();

    public String getSourceLinkToolTip(@CheckForNull BugInstance var1);

    public URL getSourceLink(BugInstance var1);

    public boolean supportsBugLinks();

    public BugFilingStatus getBugLinkStatus(BugInstance var1);

    public URL getBugLink(BugInstance var1);

    public void bugFiled(BugInstance var1, @CheckForNull Object var2);

    public boolean supportsCloudReports();

    public String getCloudReport(BugInstance var1);

    public boolean supportsClaims();

    @CheckForNull
    public String claimedBy(BugInstance var1);

    public boolean claim(BugInstance var1);

    public long getUserTimestamp(BugInstance var1);

    public void setUserTimestamp(BugInstance var1, long var2);

    public Date getUserDate(BugInstance var1);

    public UserDesignation getUserDesignation(BugInstance var1);

    public void setUserDesignation(BugInstance var1, UserDesignation var2, long var3);

    public double getClassificationScore(BugInstance var1);

    public double getClassificationVariance(BugInstance var1);

    public double getClassificationDisagreement(BugInstance var1);

    public double getPortionObsoleteClassifications(BugInstance var1);

    public int getNumberReviewers(BugInstance var1);

    public String getUserEvaluation(BugInstance var1);

    public void setUserEvaluation(BugInstance var1, String var2, long var3);

    public long getFirstSeen(BugInstance var1);

    public boolean overallClassificationIsNotAProblem(BugInstance var1);

    public void storeUserAnnotation(BugInstance var1);

    public boolean canStoreUserAnnotation(BugInstance var1);

    public void printCloudSummary(PrintWriter var1, Iterable<BugInstance> var2, String[] var3);

    public boolean supportsCloudSummaries();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BugFilingStatus {
        FILE_BUG(SystemProperties.getProperty("findbugs.filebug.label", "File bug")){

            public boolean bugIsFiled() {
                return false;
            }
        }
        ,
        FILE_AGAIN("File again"),
        BUG_PENDING("Bug pending"){

            public boolean linkEnabled() {
                return false;
            }
        }
        ,
        VIEW_BUG(SystemProperties.getProperty("findbugs.viewbug.label", "View bug")),
        NA(""){

            public boolean linkEnabled() {
                return false;
            }

            public boolean bugIsFiled() {
                return false;
            }
        };

        final String displayName;

        public boolean bugIsFiled() {
            return true;
        }

        public boolean linkEnabled() {
            return true;
        }

        private BugFilingStatus(String name) {
            this.displayName = name;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        COMMUNAL,
        VOTING,
        SECRET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UserDesignation {
        UNCLASSIFIED,
        NEEDS_STUDY,
        BAD_ANALYSIS,
        NOT_A_BUG,
        MOSTLY_HARMLESS,
        SHOULD_FIX,
        MUST_FIX,
        I_WILL_FIX,
        OBSOLETE_CODE;


        public int score() {
            switch (this) {
                case BAD_ANALYSIS: {
                    return -3;
                }
                case NOT_A_BUG: 
                case OBSOLETE_CODE: {
                    return -2;
                }
                case MOSTLY_HARMLESS: {
                    return -1;
                }
                case SHOULD_FIX: {
                    return 1;
                }
                case MUST_FIX: 
                case I_WILL_FIX: {
                    return 2;
                }
            }
            return 0;
        }
    }

    public static interface CloudListener {
        public void issueUpdate(BugInstance var1);

        public void statusUpdated();
    }
}

