/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.ProjectFilterSettings;
import edu.umd.cs.findbugs.config.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.WillClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPreferences
implements Cloneable {
    private static final String PREF_FILE_NAME = ".Findbugs_prefs";
    private static final int MAX_RECENT_FILES = 9;
    private static final String DETECTOR_THRESHOLD_KEY = "detector_threshold";
    private static final String FILTER_SETTINGS_KEY = "filter_settings";
    private static final String FILTER_SETTINGS2_KEY = "filter_settings_neg";
    private static final String RUN_AT_FULL_BUILD = "run_at_full_build";
    private LinkedList<String> recentProjectsList = new LinkedList();
    private Map<String, Boolean> detectorEnablementMap = new HashMap<String, Boolean>();
    private ProjectFilterSettings filterSettings;
    private boolean runAtFullBuild = true;
    private static UserPreferences preferencesSingleton = new UserPreferences();
    public static final String EFFORT_MIN = "min";
    public static final String EFFORT_DEFAULT = "default";
    public static final String EFFORT_MAX = "max";
    private static final String EFFORT_KEY = "effort";
    private static final String INCLUDE_FILTER_KEY = "includefilter";
    private static final String EXCLUDE_FILTER_KEY = "excludefilter";
    private static final String EXCLUDE_BUGS_KEY = "excludebugs";
    private String effort = "default";
    private Collection<String> includeFilterFiles = Collections.emptySet();
    private Collection<String> excludeFilterFiles = Collections.emptySet();
    private Collection<String> excludeBugsFiles = Collections.emptySet();

    private UserPreferences() {
        this.filterSettings = ProjectFilterSettings.createDefault();
    }

    public static UserPreferences createDefaultUserPreferences() {
        return new UserPreferences();
    }

    public static UserPreferences getUserPreferences() {
        return preferencesSingleton;
    }

    public void read() {
        File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
        if (!prefFile.exists() || !prefFile.isFile()) {
            return;
        }
        try {
            this.read(new FileInputStream(prefFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(@WillClose InputStream in) throws IOException {
        BufferedInputStream prefStream = null;
        Properties props = new Properties();
        try {
            prefStream = new BufferedInputStream(in);
            props.load(prefStream);
        }
        finally {
            try {
                if (prefStream != null) {
                    prefStream.close();
                }
            }
            catch (IOException ioe) {}
        }
        if (props.size() == 0) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            String key = "recent" + i;
            String projectName = (String)props.get(key);
            if (projectName == null) continue;
            this.recentProjectsList.add(projectName);
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String detectorState;
            int pipePos;
            String key = (String)e.getKey();
            if (!key.startsWith("detector") || key.startsWith("detector_") || (pipePos = (detectorState = (String)e.getValue()).indexOf("|")) < 0) continue;
            String name = detectorState.substring(0, pipePos);
            String enabled = detectorState.substring(pipePos + 1);
            this.detectorEnablementMap.put(name, Boolean.valueOf(enabled));
        }
        if (props.get(FILTER_SETTINGS_KEY) != null) {
            this.filterSettings = ProjectFilterSettings.fromEncodedString(props.getProperty(FILTER_SETTINGS_KEY));
        } else {
            String threshold = (String)props.get(DETECTOR_THRESHOLD_KEY);
            if (threshold != null) {
                try {
                    int detectorThreshold = Integer.parseInt(threshold);
                    this.setUserDetectorThreshold(detectorThreshold);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (props.get(FILTER_SETTINGS2_KEY) != null) {
            ProjectFilterSettings.hiddenFromEncodedString(this.filterSettings, props.getProperty(FILTER_SETTINGS2_KEY));
        }
        if (props.get(RUN_AT_FULL_BUILD) != null) {
            this.runAtFullBuild = Boolean.parseBoolean(props.getProperty(RUN_AT_FULL_BUILD));
        }
        this.effort = props.getProperty(EFFORT_KEY, EFFORT_DEFAULT);
        this.includeFilterFiles = this.readFilters(props, INCLUDE_FILTER_KEY);
        this.excludeFilterFiles = this.readFilters(props, EXCLUDE_FILTER_KEY);
        this.excludeBugsFiles = this.readFilters(props, EXCLUDE_BUGS_KEY);
    }

    public void write() {
        block2: {
            try {
                File prefFile = new File(SystemProperties.getProperty("user.home"), PREF_FILE_NAME);
                this.write(new FileOutputStream(prefFile));
            }
            catch (IOException e) {
                if (!FindBugs.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@WillClose OutputStream out) throws IOException {
        SortedProperties props = new SortedProperties();
        for (int i = 0; i < this.recentProjectsList.size(); ++i) {
            String projectName = this.recentProjectsList.get(i);
            String key = "recent" + i;
            props.put(key, projectName);
        }
        for (Map.Entry<String, Boolean> entry : this.detectorEnablementMap.entrySet()) {
            props.put("detector" + entry.getKey(), entry.getKey() + "|" + String.valueOf(entry.getValue()));
        }
        props.put(FILTER_SETTINGS_KEY, this.filterSettings.toEncodedString());
        props.put(FILTER_SETTINGS2_KEY, this.filterSettings.hiddenToEncodedString());
        props.put(DETECTOR_THRESHOLD_KEY, String.valueOf(this.filterSettings.getMinPriorityAsInt()));
        props.put(RUN_AT_FULL_BUILD, String.valueOf(this.runAtFullBuild));
        props.setProperty(EFFORT_KEY, this.effort);
        this.writeFilters(props, INCLUDE_FILTER_KEY, this.includeFilterFiles);
        this.writeFilters(props, EXCLUDE_FILTER_KEY, this.excludeFilterFiles);
        this.writeFilters(props, EXCLUDE_BUGS_KEY, this.excludeBugsFiles);
        BufferedOutputStream prefStream = null;
        try {
            prefStream = new BufferedOutputStream(out);
            props.store(prefStream, "FindBugs User Preferences");
            ((OutputStream)prefStream).flush();
        }
        finally {
            try {
                if (prefStream != null) {
                    ((OutputStream)prefStream).close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public List<String> getRecentProjects() {
        return this.recentProjectsList;
    }

    public void useProject(String projectName) {
        this.removeProject(projectName);
        this.recentProjectsList.addFirst(projectName);
        while (this.recentProjectsList.size() > 9) {
            this.recentProjectsList.removeLast();
        }
    }

    public void removeProject(String projectName) {
        Iterator it = this.recentProjectsList.iterator();
        while (it.hasNext()) {
            if (!projectName.equals(it.next())) continue;
            it.remove();
        }
    }

    public void enableDetector(DetectorFactory factory, boolean enable) {
        this.detectorEnablementMap.put(factory.getShortName(), enable);
    }

    public boolean isDetectorEnabled(DetectorFactory factory) {
        String detectorName = factory.getShortName();
        Boolean enabled = this.detectorEnablementMap.get(detectorName);
        if (enabled == null) {
            enabled = factory.isDefaultEnabled();
            this.detectorEnablementMap.put(detectorName, enabled);
        }
        return enabled;
    }

    public void enableAllDetectors(boolean enable) {
        this.detectorEnablementMap.clear();
        DetectorFactoryCollection factoryCollection = DetectorFactoryCollection.instance();
        Iterator<DetectorFactory> i = factoryCollection.factoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = i.next();
            this.detectorEnablementMap.put(factory.getShortName(), enable);
        }
    }

    public void setProjectFilterSettings(ProjectFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }

    public ProjectFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public int getUserDetectorThreshold() {
        return this.filterSettings.getMinPriorityAsInt();
    }

    public void setUserDetectorThreshold(int threshold) {
        String minPriority = ProjectFilterSettings.getIntPriorityAsString(threshold);
        this.filterSettings.setMinPriority(minPriority);
    }

    public void setRunAtFullBuild(boolean enable) {
        this.runAtFullBuild = enable;
    }

    public boolean isRunAtFullBuild() {
        return this.runAtFullBuild;
    }

    public void setUserDetectorThreshold(String threshold) {
        this.filterSettings.setMinPriority(threshold);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UserPreferences other = (UserPreferences)obj;
        return this.runAtFullBuild == other.runAtFullBuild && this.recentProjectsList.equals(other.recentProjectsList) && ((Object)this.detectorEnablementMap).equals(other.detectorEnablementMap) && this.filterSettings.equals(other.filterSettings) && this.effort.equals(other.effort) && ((Object)this.includeFilterFiles).equals(other.includeFilterFiles) && ((Object)this.excludeFilterFiles).equals(other.excludeFilterFiles) && ((Object)this.excludeBugsFiles).equals(other.excludeBugsFiles);
    }

    public int hashCode() {
        return this.recentProjectsList.hashCode() + ((Object)this.detectorEnablementMap).hashCode() + this.filterSettings.hashCode() + this.effort.hashCode() + ((Object)this.includeFilterFiles).hashCode() + ((Object)this.excludeFilterFiles).hashCode() + (this.runAtFullBuild ? 1 : 0);
    }

    public Object clone() {
        try {
            UserPreferences dup = (UserPreferences)super.clone();
            dup.recentProjectsList = new LinkedList();
            dup.recentProjectsList.addAll(this.recentProjectsList);
            dup.detectorEnablementMap = new HashMap<String, Boolean>();
            dup.detectorEnablementMap.putAll(this.detectorEnablementMap);
            dup.filterSettings = (ProjectFilterSettings)this.filterSettings.clone();
            dup.runAtFullBuild = this.runAtFullBuild;
            return dup;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        if (!(EFFORT_MIN.equals(effort) || EFFORT_DEFAULT.equals(effort) || EFFORT_MAX.equals(effort))) {
            throw new IllegalArgumentException("Effort \"" + effort + "\" is not a valid effort value.");
        }
        this.effort = effort;
    }

    public Collection<String> getIncludeFilterFiles() {
        return this.includeFilterFiles;
    }

    public void setIncludeFilterFiles(Collection<String> includeFilterFiles) {
        if (includeFilterFiles == null) {
            throw new IllegalArgumentException("includeFilterFiles may not be null.");
        }
        this.includeFilterFiles = includeFilterFiles;
    }

    public Collection<String> getExcludeBugsFiles() {
        return this.excludeBugsFiles;
    }

    public void setExcludeBugsFiles(Collection<String> excludeBugsFiles) {
        if (excludeBugsFiles == null) {
            throw new IllegalArgumentException("excludeBugsFiles may not be null.");
        }
        this.excludeBugsFiles = excludeBugsFiles;
    }

    public void setExcludeFilterFiles(Collection<String> excludeFilterFiles) {
        if (excludeFilterFiles == null) {
            throw new IllegalArgumentException("excludeFilterFiles may not be null.");
        }
        this.excludeFilterFiles = excludeFilterFiles;
    }

    public Collection<String> getExcludeFilterFiles() {
        return this.excludeFilterFiles;
    }

    private Set<String> readFilters(Properties props, String keyPrefix) {
        LinkedHashSet<String> filters = new LinkedHashSet<String>();
        int counter = 0;
        boolean keyFound = true;
        while (keyFound) {
            String property = props.getProperty(keyPrefix + counter);
            if (property != null) {
                filters.add(property);
                ++counter;
                continue;
            }
            keyFound = false;
        }
        return filters;
    }

    private void writeFilters(Properties props, String keyPrefix, Collection<String> filters) {
        int counter = 0;
        for (String s : filters) {
            props.setProperty(keyPrefix + counter, s);
            ++counter;
        }
        boolean keyFound = true;
        while (keyFound) {
            String key = keyPrefix + counter;
            String property = props.getProperty(key);
            if (property == null) {
                keyFound = false;
                continue;
            }
            props.remove(key);
        }
    }

    public AnalysisFeatureSetting[] getAnalysisFeatureSettings() {
        if (this.effort.equals(EFFORT_DEFAULT)) {
            return FindBugs.DEFAULT_EFFORT;
        }
        if (this.effort.equals(EFFORT_MIN)) {
            return FindBugs.MIN_EFFORT;
        }
        return FindBugs.MAX_EFFORT;
    }
}

