/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.detect.MutableStaticFields;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindReturnRef
extends OpcodeStackDetector {
    boolean check = false;
    boolean thisOnTOS = false;
    boolean fieldOnTOS = false;
    boolean publicClass = false;
    boolean staticMethod = false;
    String nameOnStack;
    String classNameOnStack;
    String sigOnStack;
    int parameterCount;
    boolean fieldIsStatic;
    private BugAccumulator bugAccumulator;

    public FindReturnRef(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visit(JavaClass obj) {
        this.publicClass = obj.isPublic();
        super.visit(obj);
    }

    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    public void visit(Method obj) {
        boolean bl = this.check = this.publicClass && (obj.getAccessFlags() & 1) != 0;
        if (!this.check) {
            return;
        }
        this.staticMethod = (obj.getAccessFlags() & 8) != 0;
        this.parameterCount = this.getNumberMethodArguments();
        if (!this.staticMethod) {
            ++this.parameterCount;
        }
        this.thisOnTOS = false;
        this.fieldOnTOS = false;
        super.visit(obj);
        this.thisOnTOS = false;
        this.fieldOnTOS = false;
    }

    public void visit(Code obj) {
        if (this.check) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        OpcodeStack.Item top;
        if (!this.check) {
            return;
        }
        if (this.staticMethod && seen == 179 && MutableStaticFields.mutableSignature(this.getSigConstantOperand()) && this.isPotentialCapture(top = this.stack.getStackItem(0))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_STATIC_REP2", 2).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
        }
        if (!this.staticMethod && seen == 181 && MutableStaticFields.mutableSignature(this.getSigConstantOperand())) {
            top = this.stack.getStackItem(0);
            OpcodeStack.Item target = this.stack.getStackItem(1);
            if (this.isPotentialCapture(top) && target.getRegisterNumber() == 0) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_REP2", 2).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
            }
        }
        if (seen == 42 && !this.staticMethod) {
            this.thisOnTOS = true;
            this.fieldOnTOS = false;
            return;
        }
        if (this.thisOnTOS && seen == 180 && this.getClassConstantOperand().equals(this.getClassName()) && !AnalysisContext.currentXFactory().isEmptyArrayField(this.getXFieldOperand())) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.getNameConstantOperand();
            this.classNameOnStack = this.getDottedClassConstantOperand();
            this.sigOnStack = this.getSigConstantOperand();
            this.fieldIsStatic = false;
            return;
        }
        if (seen == 178 && this.getClassConstantOperand().equals(this.getClassName()) && !AnalysisContext.currentXFactory().isEmptyArrayField(this.getXFieldOperand())) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.getNameConstantOperand();
            this.classNameOnStack = this.getDottedClassConstantOperand();
            this.sigOnStack = this.getSigConstantOperand();
            this.fieldIsStatic = true;
            return;
        }
        this.thisOnTOS = false;
        if (this.check && this.fieldOnTOS && seen == 176 && this.nameOnStack.indexOf("EMPTY") == -1 && MutableStaticFields.mutableSignature(this.sigOnStack)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, this.staticMethod ? "MS_EXPOSE_REP" : "EI_EXPOSE_REP", 2).addClassAndMethod(this).addField(this.classNameOnStack, this.nameOnStack, this.sigOnStack, this.fieldIsStatic), this);
        }
        this.fieldOnTOS = false;
        this.thisOnTOS = false;
    }

    private boolean isPotentialCapture(OpcodeStack.Item top) {
        if (!top.isInitialParameter()) {
            return false;
        }
        if ((this.getMethod().getAccessFlags() & 0x80) == 0) {
            return true;
        }
        return top.getRegisterNumber() != this.parameterCount - 1;
    }
}

