/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.Path;
import edu.umd.cs.findbugs.ba.PathVisitor;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationAcquiredOrReleasedInLoopException;
import edu.umd.cs.findbugs.ba.obl.ObligationAnalysis;
import edu.umd.cs.findbugs.ba.obl.ObligationDataflow;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabase;
import edu.umd.cs.findbugs.ba.obl.State;
import edu.umd.cs.findbugs.ba.obl.StateSet;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.bcel.CFGDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindUnsatisfiedObligation
extends CFGDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("oa.debug");
    private static final String DEBUG_METHOD = SystemProperties.getProperty("oa.method");
    private static final boolean DEBUG_FP = SystemProperties.getBoolean("oa.debug.fp");
    private static final boolean COMPUTE_TRANSFERS = SystemProperties.getBoolean("oa.transfers", true);
    private static final boolean REPORT_PATH = SystemProperties.getBoolean("oa.reportpath", true);
    private static final boolean REPORT_PATH_DEBUG = SystemProperties.getBoolean("oa.reportpath.debug");
    private static final boolean REPORT_OBLIGATION_SET = SystemProperties.getBoolean("oa.report.obligationset", true);
    private final BugReporter bugReporter;
    private ObligationPolicyDatabase database;

    public FindUnsatisfiedObligation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        this.database = analysisCache.getDatabase(ObligationPolicyDatabase.class);
    }

    public void visitClass(ClassDescriptor classDescriptor) throws CheckedAnalysisException {
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        ObligationFactory factory = this.database.getFactory();
        JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, classDescriptor);
        for (Constant c : jclass.getConstantPool().getConstantPool()) {
            String className;
            if (c instanceof ConstantNameAndType) {
                ConstantNameAndType cnt = (ConstantNameAndType)c;
                String signature = cnt.getSignature(jclass.getConstantPool());
                if (!factory.signatureInvolvesObligations(signature)) continue;
                super.visitClass(classDescriptor);
                return;
            }
            if (!(c instanceof ConstantClass) || !factory.signatureInvolvesObligations(className = ((ConstantClass)c).getBytes(jclass.getConstantPool()))) continue;
            super.visitClass(classDescriptor);
            return;
        }
        if (DEBUG) {
            System.out.println(classDescriptor + " isn't interesting for obligation analysis");
        }
    }

    protected void visitMethodCFG(MethodDescriptor methodDescriptor, CFG cfg) throws CheckedAnalysisException {
        MethodChecker methodChecker = new MethodChecker(methodDescriptor, cfg);
        methodChecker.analyzeMethod();
    }

    public void report() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodChecker {
        MethodDescriptor methodDescriptor;
        CFG cfg;
        IAnalysisCache analysisCache;
        ObligationDataflow dataflow;
        ConstantPoolGen cpg;
        TypeDataflow typeDataflow;
        Subtypes2 subtypes2;
        XMethod xmethod;

        MethodChecker(MethodDescriptor methodDescriptor, CFG cfg) {
            this.methodDescriptor = methodDescriptor;
            this.cfg = cfg;
        }

        public void analyzeMethod() throws CheckedAnalysisException {
            if (DEBUG_METHOD != null && !this.methodDescriptor.getName().equals(DEBUG_METHOD)) {
                return;
            }
            if (DEBUG) {
                System.out.println("*** Analyzing method " + this.methodDescriptor);
            }
            this.xmethod = XFactory.createXMethod(this.methodDescriptor);
            this.analysisCache = Global.getAnalysisCache();
            try {
                this.dataflow = this.analysisCache.getMethodAnalysis(ObligationDataflow.class, this.methodDescriptor);
            }
            catch (ObligationAcquiredOrReleasedInLoopException e) {
                if (DEBUG) {
                    System.out.println("FindUnsatisifedObligation: " + this.methodDescriptor + ": " + e.getMessage());
                }
                return;
            }
            this.cpg = this.analysisCache.getClassAnalysis(ConstantPoolGen.class, this.methodDescriptor.getClassDescriptor());
            this.typeDataflow = this.analysisCache.getMethodAnalysis(TypeDataflow.class, this.methodDescriptor);
            this.subtypes2 = Global.getAnalysisCache().getDatabase(Subtypes2.class);
            HashMap<Obligation, State> leakedObligationMap = new HashMap<Obligation, State>();
            StateSet factAtExit = (StateSet)this.dataflow.getResultFact(this.cfg.getExit());
            Iterator<State> i = factAtExit.stateIterator();
            while (i.hasNext()) {
                State state = i.next();
                this.checkStateForLeakedObligations(state, leakedObligationMap);
            }
            for (Map.Entry entry : leakedObligationMap.entrySet()) {
                Obligation obligation = (Obligation)entry.getKey();
                State state = (State)entry.getValue();
                this.reportWarning(obligation, state);
            }
        }

        private void checkStateForLeakedObligations(State state, Map<Obligation, State> leakedObligationMap) throws IllegalStateException {
            Path path;
            if (DEBUG && (path = state.getPath()).getLength() > 0 && path.getBlockIdAt(path.getLength() - 1) != this.cfg.getExit().getLabel()) {
                throw new IllegalStateException("path " + path + " at cfg exit has no label for exit block");
            }
            for (int id = 0; id < FindUnsatisfiedObligation.this.database.getFactory().getMaxObligationTypes(); ++id) {
                int leakCount;
                Obligation obligation = FindUnsatisfiedObligation.this.database.getFactory().getObligationById(id);
                int rawLeakCount = state.getObligationSet().getCount(id);
                if (rawLeakCount == 0) continue;
                try {
                    leakCount = this.getAdjustedLeakCount(state, id);
                }
                catch (DataflowAnalysisException e) {
                    continue;
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (leakCount <= 0) continue;
                leakedObligationMap.put(obligation, state);
            }
        }

        private void reportWarning(Obligation obligation, State state) {
            String className = obligation.getClassName();
            if (this.methodDescriptor.isStatic() && this.methodDescriptor.getName().equals("main") && this.methodDescriptor.getSignature().equals("([Ljava/lang/String;)V") && (className.contains("InputStream") || className.contains("Reader"))) {
                return;
            }
            BugInstance bugInstance = new BugInstance(FindUnsatisfiedObligation.this, "OBL_UNSATISFIED_OBLIGATION", 2).addClassAndMethod(this.methodDescriptor).addClass(className).describe("CLASS_REFTYPE");
            bugInstance.addInt(state.getObligationSet().getCount(obligation.getId())).describe("INT_OBLIGATIONS_REMAINING");
            this.annotateWarningWithSourceLineInformation(state, obligation, bugInstance);
            if (REPORT_OBLIGATION_SET) {
                bugInstance.addString(state.getObligationSet().toString()).describe("STRING_REMAINING_OBLIGATIONS");
            }
            FindUnsatisfiedObligation.this.bugReporter.reportBug(bugInstance);
        }

        private void annotateWarningWithSourceLineInformation(State state, Obligation obligation, BugInstance bugInstance) {
            if (REPORT_PATH) {
                this.reportPath(bugInstance, obligation, state);
            }
        }

        private int getAdjustedLeakCount(State state, int obligationId) throws DataflowAnalysisException, ClassNotFoundException {
            Obligation obligation = FindUnsatisfiedObligation.this.database.getFactory().getObligationById(obligationId);
            Path path = state.getPath();
            PostProcessingPathVisitor visitor = new PostProcessingPathVisitor(obligation, state);
            path.acceptVisitor(this.cfg, visitor);
            if (visitor.couldNotAnalyze()) {
                return 0;
            }
            return visitor.getAdjustedLeakCount();
        }

        private boolean isPossibleInstanceOfObligationType(Subtypes2 subtypes2, ObjectType type, ObjectType obligationType) throws ClassNotFoundException {
            return subtypes2.isSubtype(type, obligationType);
        }

        private void reportPath(final BugInstance bugInstance, final Obligation obligation, State state) {
            Path path = state.getPath();
            PathVisitor visitor = new PathVisitor(){
                boolean sawFirstCreation;
                SourceLineAnnotation lastSourceLine;
                BasicBlock curBlock;

                public void visitBasicBlock(BasicBlock basicBlock) {
                    State entryState;
                    StateSet entryFact;
                    Iterator<State> i;
                    this.curBlock = basicBlock;
                    if (this.curBlock == MethodChecker.this.cfg.getEntry() && (i = (entryFact = (StateSet)MethodChecker.this.dataflow.getResultFact(this.curBlock)).stateIterator()).hasNext() && (entryState = i.next()).getObligationSet().getCount(obligation.getId()) > 0) {
                        this.lastSourceLine = SourceLineAnnotation.forFirstLineOfMethod(MethodChecker.this.methodDescriptor);
                        this.lastSourceLine.setDescription("SOURCE_LINE_OBLIGATION_CREATED_BY_WILLCLOSE_PARAMETER");
                        bugInstance.add(this.lastSourceLine);
                        this.sawFirstCreation = true;
                        if (REPORT_PATH_DEBUG) {
                            System.out.println("  " + obligation + " created by @WillClose parameter at " + this.lastSourceLine);
                        }
                    }
                }

                public void visitInstructionHandle(InstructionHandle handle) {
                    boolean isInteresting;
                    boolean isCreation = ((ObligationAnalysis)MethodChecker.this.dataflow.getAnalysis()).getActionCache().addsObligation(handle, MethodChecker.this.cpg, obligation);
                    if (!this.sawFirstCreation && !isCreation) {
                        return;
                    }
                    SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction(MethodChecker.this.methodDescriptor, new Location(handle, this.curBlock));
                    boolean bl = isInteresting = sourceLine.getStartLine() > 0 && (this.lastSourceLine == null || !sourceLine.equals(this.lastSourceLine));
                    if (REPORT_PATH_DEBUG) {
                        System.out.println("  " + handle.getPosition() + " --> " + sourceLine + (isInteresting ? " **" : ""));
                    }
                    if (isInteresting) {
                        sourceLine.setDescription(isCreation ? "SOURCE_LINE_OBLIGATION_CREATED" : "SOURCE_LINE_PATH_CONTINUES");
                        bugInstance.add(sourceLine);
                        this.lastSourceLine = sourceLine;
                        if (isCreation) {
                            this.sawFirstCreation = true;
                        }
                    }
                }

                public void visitEdge(Edge edge) {
                    if (REPORT_PATH_DEBUG) {
                        System.out.println("Edge of type " + Edge.edgeTypeToString(edge.getType()) + " to " + ((BasicBlock)edge.getTarget()).getLabel());
                        if (((BasicBlock)edge.getTarget()).getFirstInstruction() != null) {
                            System.out.println("  First instruction in target: " + ((BasicBlock)edge.getTarget()).getFirstInstruction());
                        }
                        if (((BasicBlock)edge.getTarget()).isExceptionThrower()) {
                            System.out.println("  exception thrower for " + ((BasicBlock)edge.getTarget()).getExceptionThrower());
                        }
                        if (edge.isExceptionEdge()) {
                            System.out.println("  exceptions thrown: " + MethodChecker.this.typeDataflow.getEdgeExceptionSet(edge));
                        }
                    }
                }
            };
            path.acceptVisitor(this.cfg, visitor);
        }

        private class PostProcessingPathVisitor
        implements PathVisitor {
            Obligation possiblyLeakedObligation;
            State state;
            int adjustedLeakCount;
            BasicBlock curBlock;
            boolean couldNotAnalyze;
            List<PossibleObligationTransfer> transferList;

            public PostProcessingPathVisitor(Obligation possiblyLeakedObligation, State state) {
                this.possiblyLeakedObligation = possiblyLeakedObligation;
                this.state = state;
                this.adjustedLeakCount = state.getObligationSet().getCount(possiblyLeakedObligation.getId());
                if (COMPUTE_TRANSFERS) {
                    this.transferList = new LinkedList<PossibleObligationTransfer>();
                }
            }

            public int getAdjustedLeakCount() {
                return this.adjustedLeakCount;
            }

            public boolean couldNotAnalyze() {
                return this.couldNotAnalyze;
            }

            public void visitBasicBlock(BasicBlock basicBlock) {
                this.curBlock = basicBlock;
                if (COMPUTE_TRANSFERS && basicBlock == MethodChecker.this.cfg.getExit() && this.adjustedLeakCount == 1) {
                    this.applyPossibleObligationTransfers();
                }
            }

            public void visitInstructionHandle(InstructionHandle handle) {
                try {
                    Instruction ins = handle.getInstruction();
                    short opcode = ins.getOpcode();
                    if (opcode == 181 || opcode == 179 || opcode == 176) {
                        Type tosType;
                        Location loc = new Location(handle, this.curBlock);
                        TypeFrame typeFrame = (TypeFrame)MethodChecker.this.typeDataflow.getFactAtLocation(loc);
                        if (!typeFrame.isValid()) {
                            this.couldNotAnalyze = true;
                        }
                        if ((tosType = (Type)typeFrame.getTopValue()) instanceof ObjectType && MethodChecker.this.isPossibleInstanceOfObligationType(MethodChecker.this.subtypes2, (ObjectType)tosType, this.possiblyLeakedObligation.getType())) {
                            --this.adjustedLeakCount;
                        }
                    }
                    if (COMPUTE_TRANSFERS && ins instanceof InvokeInstruction) {
                        this.checkForPossibleObligationTransfer((InvokeInstruction)ins, handle);
                    }
                }
                catch (ClassNotFoundException e) {
                    FindUnsatisfiedObligation.this.bugReporter.reportMissingClass(e);
                    this.couldNotAnalyze = true;
                }
                catch (DataflowAnalysisException e) {
                    this.couldNotAnalyze = true;
                }
            }

            private void applyPossibleObligationTransfers() {
                for (PossibleObligationTransfer transfer : this.transferList) {
                    if (DEBUG_FP) {
                        System.out.println("Checking possible transfer " + transfer + "...");
                    }
                    boolean matches = transfer.matches(this.possiblyLeakedObligation);
                    if (DEBUG_FP) {
                        System.out.println("  matches: " + this.possiblyLeakedObligation);
                    }
                    if (!matches) continue;
                    boolean balanced = transfer.balanced(this.state);
                    if (DEBUG_FP) {
                        System.out.println("  balanced: " + balanced + " in " + this.state.getObligationSet());
                    }
                    if (!balanced) continue;
                    if (DEBUG_FP) {
                        System.out.println("  Suppressing path because a transfer appears to result in balanced outstanding obligations");
                    }
                    this.adjustedLeakCount = 0;
                    break;
                }
            }

            private void checkForPossibleObligationTransfer(InvokeInstruction inv, InstructionHandle handle) throws ClassNotFoundException {
                ReferenceType producedType;
                State transferState;
                if (DEBUG_FP) {
                    System.out.println("Checking " + handle + " as possible obligation transfer...:");
                }
                if ((transferState = this.getTransferState(handle)) == null) {
                    if (DEBUG_FP) {
                        System.out.println("No transfer state???");
                    }
                    return;
                }
                String methodName = inv.getMethodName(MethodChecker.this.cpg);
                Object object = producedType = methodName.equals("<init>") ? inv.getReferenceType(MethodChecker.this.cpg) : inv.getReturnType(MethodChecker.this.cpg);
                if (DEBUG_FP && !(producedType instanceof ObjectType)) {
                    System.out.println("Produced type " + producedType + " not an ObjectType");
                }
                if (producedType instanceof ObjectType) {
                    Obligation produced = FindUnsatisfiedObligation.this.database.getFactory().getObligationByType((ObjectType)producedType);
                    if (DEBUG_FP && produced == null) {
                        System.out.println("Produced type  " + producedType + " not an obligation type");
                    }
                    if (produced != null) {
                        XMethod calledMethod = XFactory.createXMethod(inv, MethodChecker.this.cpg);
                        Obligation[] params = FindUnsatisfiedObligation.this.database.getFactory().getParameterObligationTypes(calledMethod);
                        for (int i = 0; i < params.length; ++i) {
                            Obligation consumed = params[i];
                            if (DEBUG_FP && consumed == null) {
                                System.out.println("Param " + i + " not an obligation type");
                            }
                            if (DEBUG_FP && consumed != null && consumed.equals(produced)) {
                                System.out.println("Consumed type is the same as produced type");
                            }
                            if (consumed == null || consumed.equals(produced)) continue;
                            if (transferState.getObligationSet().getCount(consumed.getId()) > 0) {
                                this.transferList.add(new PossibleObligationTransfer(consumed, produced));
                                if (!DEBUG_FP) continue;
                                System.out.println("===> Possible transfer of " + consumed + " to " + produced + " at " + handle);
                                continue;
                            }
                            if (!DEBUG_FP) continue;
                            System.out.println(handle + " not a transfer " + "of " + consumed + "->" + produced + " because no instances of " + consumed);
                            System.out.println("I see " + transferState.getObligationSet());
                        }
                    }
                }
            }

            public void visitEdge(Edge edge) {
                if (DEBUG_FP) {
                    System.out.println("visit edge " + edge);
                }
            }

            private State getTransferState(InstructionHandle handle) {
                StateSet stateSet;
                try {
                    stateSet = (StateSet)MethodChecker.this.dataflow.getFactAtLocation(new Location(handle, this.curBlock));
                }
                catch (DataflowAnalysisException e) {
                    FindUnsatisfiedObligation.this.bugReporter.logError("Error checking obligation state at " + handle, e);
                    return null;
                }
                List<State> prefixes = stateSet.getPrefixStates(this.state.getPath());
                if (prefixes.size() != 1) {
                    if (DEBUG_FP) {
                        System.out.println("at " + handle + " in " + MethodChecker.this.xmethod + " found " + prefixes.size() + " states which are prefixes of error state");
                    }
                    return null;
                }
                return prefixes.get(0);
            }
        }
    }

    private static class PossibleObligationTransfer {
        Obligation consumed;
        Obligation produced;

        public PossibleObligationTransfer(@Nonnull Obligation consumed, @Nonnull Obligation produced) {
            this.consumed = consumed;
            this.produced = produced;
        }

        private boolean balanced(State state) {
            int producedCount;
            int consumedCount = state.getObligationSet().getCount(this.consumed.getId());
            return consumedCount + (producedCount = state.getObligationSet().getCount(this.produced.getId())) == 0 && (consumedCount == 1 || producedCount == 1);
        }

        private boolean matches(Obligation possiblyLeakedObligation) {
            return this.consumed.equals(possiblyLeakedObligation) || this.produced.equals(possiblyLeakedObligation);
        }

        public String toString() {
            return this.consumed + " -> " + this.produced;
        }
    }
}

