/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.formatStringChecker.ExtraFormatArgumentsException;
import edu.umd.cs.findbugs.formatStringChecker.Formatter;
import edu.umd.cs.findbugs.formatStringChecker.IllegalFormatConversionException;
import edu.umd.cs.findbugs.formatStringChecker.MissingFormatArgumentException;
import org.apache.bcel.classfile.Code;

public class FormatStringChecker
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    FormatState state;
    String formatString;
    int stackDepth;
    OpcodeStack.Item[] arguments;

    public FormatStringChecker(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code code) {
        this.state = FormatState.NONE;
        super.visit(code);
        this.arguments = null;
    }

    public void sawOpcode(int seen) {
        if (this.stack.getStackDepth() < this.stackDepth) {
            this.state = FormatState.NONE;
            this.stackDepth = 0;
            this.arguments = null;
        }
        if (seen == 189 && this.stack.getStackDepth() >= 2) {
            Object size = this.stack.getStackItem(0).getConstant();
            Object formatStr = this.stack.getStackItem(1).getConstant();
            if (size instanceof Integer && formatStr instanceof String) {
                this.arguments = new OpcodeStack.Item[((Integer)size).intValue()];
                this.formatString = (String)formatStr;
                this.state = FormatState.READY_FOR_FORMAT;
                this.stackDepth = this.stack.getStackDepth();
            }
        } else if (this.state == FormatState.READY_FOR_FORMAT && seen == 89) {
            this.state = FormatState.EXPECTING_ASSIGNMENT;
        } else if (this.state == FormatState.EXPECTING_ASSIGNMENT && this.stack.getStackDepth() == this.stackDepth + 3 && seen == 83) {
            Object pos = this.stack.getStackItem(1).getConstant();
            OpcodeStack.Item value = this.stack.getStackItem(0);
            if (pos instanceof Integer) {
                int index = (Integer)pos;
                if (index >= 0 && index < this.arguments.length) {
                    this.arguments[index] = value;
                    this.state = FormatState.READY_FOR_FORMAT;
                } else {
                    this.state = FormatState.NONE;
                }
            } else {
                this.state = FormatState.NONE;
            }
        } else if (this.state == FormatState.READY_FOR_FORMAT && (seen == 183 || seen == 182 || seen == 184 || seen == 185) && this.stack.getStackDepth() == this.stackDepth) {
            String cl = this.getClassConstantOperand();
            String nm = this.getNameConstantOperand();
            String sig = this.getSigConstantOperand();
            XMethod m = this.getXMethodOperand();
            if ((m == null || m.isVarArgs()) && sig.indexOf("Ljava/lang/String;[Ljava/lang/Object;)") >= 0 && ("java/util/Formatter".equals(cl) && "format".equals(nm) || "java/lang/String".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "format".equals(nm) || "java/io/PrintStream".equals(cl) && "printf".equals(nm) || cl.endsWith("Writer") && "format".equals(nm) || cl.endsWith("Writer") && "printf".equals(nm)) || cl.endsWith("Logger") && nm.endsWith("fmt")) {
                try {
                    String[] signatures = new String[this.arguments.length];
                    for (int i = 0; i < signatures.length; ++i) {
                        signatures[i] = this.arguments[i].getSignature();
                    }
                    Formatter.check((String)this.formatString, (String[])signatures);
                }
                catch (IllegalFormatConversionException e) {
                    if (e.getConversion() == 'b') {
                        this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_BAD_CONVERSION_TO_BOOLEAN", 1).addClassAndMethod(this).addCalledMethod(this).addType(e.getArgumentSignature()).describe("TYPE_FOUND").addString(e.getFormatSpecifier()).describe("STRING_FORMAT_SPECIFIER").addString(this.formatString).describe("STRING_FORMAT_STRING").addValueSource(this.arguments[e.getArgIndex()], this.getMethod(), this.getPC()).addSourceLine(this));
                    } else if (e.getArgumentSignature().charAt(0) == '[' && e.getConversion() == 's') {
                        this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_BAD_CONVERSION_FROM_ARRAY", 1).addClassAndMethod(this).addCalledMethod(this).addType(e.getArgumentSignature()).describe("TYPE_FOUND").addString(e.getFormatSpecifier()).describe("STRING_FORMAT_SPECIFIER").addString(this.formatString).describe("STRING_FORMAT_STRING").addValueSource(this.arguments[e.getArgIndex()], this.getMethod(), this.getPC()).addSourceLine(this));
                    } else {
                        this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_BAD_CONVERSION", 1).addClassAndMethod(this).addCalledMethod(this).addType(e.getArgumentSignature()).describe("TYPE_FOUND").addString(e.getFormatSpecifier()).describe("STRING_FORMAT_SPECIFIER").addString(this.formatString).describe("STRING_FORMAT_STRING").addValueSource(this.arguments[e.getArgIndex()], this.getMethod(), this.getPC()).addSourceLine(this));
                    }
                }
                catch (IllegalArgumentException e) {
                    this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_ILLEGAL", 1).addClassAndMethod(this).addCalledMethod(this).addString(this.formatString).describe("STRING_FORMAT_STRING").addSourceLine(this));
                }
                catch (MissingFormatArgumentException e) {
                    if (e.pos < 0) {
                        this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_NO_PREVIOUS_ARGUMENT", 1).addClassAndMethod(this).addCalledMethod(this).addString(e.formatSpecifier).describe("STRING_FORMAT_SPECIFIER").addString(this.formatString).describe("STRING_FORMAT_STRING").addSourceLine(this));
                    } else {
                        this.bugReporter.reportBug(new BugInstance(this, "VA_FORMAT_STRING_MISSING_ARGUMENT", 1).addClassAndMethod(this).addCalledMethod(this).addString(e.formatSpecifier).describe("STRING_FORMAT_SPECIFIER").addString(this.formatString).describe("STRING_FORMAT_STRING").addInt(e.pos + 1).describe("INT_EXPECTED_ARGUMENTS").addInt(this.arguments.length).describe("INT_ACTUAL_ARGUMENTS").addSourceLine(this));
                    }
                }
                catch (ExtraFormatArgumentsException e) {
                    int priority = 2;
                    String pattern = "VA_FORMAT_STRING_EXTRA_ARGUMENTS_PASSED";
                    if (e.used == 0) {
                        priority = 1;
                        if (this.formatString.indexOf("{0") >= 0 || this.formatString.indexOf("{1") >= 0) {
                            pattern = "VA_FORMAT_STRING_EXPECTED_MESSAGE_FORMAT_SUPPLIED";
                        }
                    }
                    this.bugReporter.reportBug(new BugInstance(this, pattern, priority).addClassAndMethod(this).addCalledMethod(this).addString(this.formatString).describe("STRING_FORMAT_STRING").addInt(e.used).describe("INT_EXPECTED_ARGUMENTS").addInt(e.provided).describe("INT_ACTUAL_ARGUMENTS").addSourceLine(this));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FormatState {
        NONE,
        READY_FOR_FORMAT,
        EXPECTING_ASSIGNMENT;

    }
}

