/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.detect.BCPMethodReturnCheck;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteCheckReturnValue
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private static final String LOAD_TRAINING = SystemProperties.getProperty("findbugs.checkreturn.loadtraining");
    private static final String SAVE_TRAINING = SystemProperties.getProperty("findbugs.checkreturn.savetraining");
    private BugReporter bugReporter;
    private boolean checkLoad;
    private Set<XMethod> checkReturnValueDatabase;

    public NoteCheckReturnValue(BugReporter bugReporter) {
        AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase();
        this.bugReporter = bugReporter;
        if (SAVE_TRAINING != null) {
            this.checkReturnValueDatabase = new HashSet<XMethod>();
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass;
        if (LOAD_TRAINING != null && !this.checkLoad) {
            this.loadTraining();
            this.checkLoad = true;
        }
        if (!BCELUtil.preTiger(javaClass = classContext.getJavaClass())) {
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (!annotationClass.endsWith("CheckReturnValue")) {
            return;
        }
        if (!this.visitingMethod()) {
            return;
        }
        BCPMethodReturnCheck.addMethodWhoseReturnMustBeChecked("+" + this.getDottedClassName(), this.getMethodName(), this.getMethodSig(), this.getThisClass().isStatic() ? 2 : 7);
        if (SAVE_TRAINING != null) {
            this.checkReturnValueDatabase.add(XFactory.createXMethod(this));
        }
    }

    @Override
    public void report() {
        if (SAVE_TRAINING != null) {
            this.saveTraining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTraining() {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(Util.getFileReader(LOAD_TRAINING));
            while ((line = reader.readLine()) != null) {
                String[] tuple = line.split(",");
                if (tuple.length != 4) continue;
                BCPMethodReturnCheck.addMethodWhoseReturnMustBeChecked(tuple[0], tuple[1], tuple[2], Boolean.valueOf(tuple[3]) != false ? 2 : 7);
            }
        }
        catch (IOException e) {
            this.bugReporter.logError("Couldn't load check return database");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTraining() {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(SAVE_TRAINING));
            for (XMethod xmethod : this.checkReturnValueDatabase) {
                writer.write(xmethod.getClassName());
                writer.write(",");
                writer.write(xmethod.getName());
                writer.write(",");
                writer.write(xmethod.getSignature());
                writer.write(",");
                writer.write(String.valueOf(xmethod.getAccessFlags()));
                writer.write("\n");
            }
        }
        catch (IOException e) {
            this.bugReporter.logError("Couldn't write check return value training data", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

