/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DisplayNonmodelMessage {
    static JFrame messageFrame;
    static JTextArea messageTextArea;
    static Font sourceFont;
    static Runnable moveToFrontLater;
    static Runnable clearAlwaysOnTopLater;
    static Runnable moveToFront;
    static Runnable clearAlwaysOnTop;

    public static void main(String[] args) {
        DisplayNonmodelMessage.displayNonmodelMessage("Hello", "The quick brown fox jumped over the lazy dog", null, false);
    }

    public static void displayNonmodelMessage(String title, String message, @CheckForNull Component centerOver, boolean onTop) {
        boolean positionWindow = false;
        if (messageFrame == null) {
            positionWindow = true;
            messageFrame = new JFrame(title);
            messageTextArea = new JTextArea(40, 80);
            messageTextArea.setEditable(false);
            messageTextArea.setLineWrap(true);
            messageTextArea.setWrapStyleWord(true);
            messageTextArea.setFont(sourceFont);
            try {
                messageFrame.setIconImage(ImageIO.read(MainFrame.class.getResource("smallBuggy.png")));
            }
            catch (IOException e1) {
                // empty catch block
            }
            Container contentPane = messageFrame.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane(messageTextArea);
            contentPane.add((Component)scrollPane, "Center");
            messageFrame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    JFrame tmp = messageFrame;
                    messageFrame = null;
                    tmp.setVisible(false);
                    tmp.dispose();
                }
            });
        }
        messageTextArea.setText(message);
        messageFrame.setTitle(title);
        messageFrame.pack();
        if (positionWindow) {
            messageFrame.setLocationRelativeTo(centerOver);
        }
        messageFrame.setVisible(true);
        messageFrame.toFront();
        if (onTop) {
            messageFrame.setAlwaysOnTop(true);
            new Thread(clearAlwaysOnTopLater).start();
        }
    }

    static void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        sourceFont = new Font("Monospaced", 0, (int)Driver.getFontSize());
        moveToFrontLater = new Runnable(){

            public void run() {
                DisplayNonmodelMessage.sleep(5);
                SwingUtilities.invokeLater(moveToFront);
            }
        };
        clearAlwaysOnTopLater = new Runnable(){

            public void run() {
                DisplayNonmodelMessage.sleep(5);
                SwingUtilities.invokeLater(clearAlwaysOnTop);
            }
        };
        moveToFront = new Runnable(){

            public void run() {
                JFrame frame = messageFrame;
                if (frame != null) {
                    frame.toFront();
                }
            }
        };
        clearAlwaysOnTop = new Runnable(){

            public void run() {
                JFrame frame = messageFrame;
                if (frame != null) {
                    frame.setAlwaysOnTop(false);
                }
            }
        };
    }
}

