/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.gui2.AnalyzingDialog;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SourceDirectoryWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class NewProjectWizard
extends FBDialog {
    private EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
    private Project project;
    private boolean projectChanged = false;
    private boolean projectNameChanged = false;
    private FBFileChooser chooser = new FBFileChooser();
    private FileFilter directoryOrArchive = new FileFilter(){

        public boolean accept(File f) {
            String fileName = f.getName().toLowerCase();
            return f.isDirectory() || fileName.endsWith(".jar") || fileName.endsWith(".ear") || fileName.endsWith(".war") || fileName.endsWith(".zip") || fileName.endsWith(".sar") || fileName.endsWith(".class");
        }

        public String getDescription() {
            return L10N.getLocalString("file.accepted_extensions", "Class archive files (*.class, *.[jwes]ar, *.zip)");
        }
    };
    private JList analyzeList = new JList();
    private DefaultListModel analyzeModel = new DefaultListModel();
    private JTextField projectName = new JTextField();
    private JList auxList = new JList();
    private DefaultListModel auxModel = new DefaultListModel();
    private JList sourceList = new JList();
    private DefaultListModel sourceModel = new DefaultListModel();
    private JButton finishButton = new JButton(L10N.getLocalString("dlg.finish_btn", "Finish"));
    private JButton cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
    private JComponent[] wizardComponents = new JComponent[3];
    private int currentPanel;

    public NewProjectWizard() {
        this((Project)null);
        this.finishButton.setEnabled(false);
    }

    public NewProjectWizard(Project curProject) {
        this.project = curProject;
        boolean temp = false;
        if (curProject == null) {
            this.setTitle(L10N.getLocalString("dlg.new_item", "New Project"));
        } else {
            this.setTitle(L10N.getLocalString("dlg.reconfig", "Reconfigure"));
            temp = true;
        }
        final boolean reconfig = temp;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(3, 1));
        this.wizardComponents[0] = this.createFilePanel(L10N.getLocalString("dlg.class_jars_dirs_lbl", "Class archives and directories to analyze:"), this.analyzeList, this.analyzeModel, 2, this.directoryOrArchive, "Choose Class Archives and Directories to Analyze", false);
        this.wizardComponents[1] = this.createFilePanel(L10N.getLocalString("dlg.aux_class_lbl", "Auxiliary class locations:"), this.auxList, this.auxModel, 2, this.directoryOrArchive, "Choose Auxilliary Class Archives and Directories", false);
        this.wizardComponents[2] = this.createFilePanel(L10N.getLocalString("dlg.source_dirs_lbl", "Source directories:"), this.sourceList, this.sourceModel, 2, null, "Choose Source Directories", true);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        if (MainFrame.isMacLookAndFeel()) {
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.cancelButton);
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.finishButton);
        } else {
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.finishButton);
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.cancelButton);
        }
        this.finishButton.addActionListener(new ActionListener(){
            boolean keepGoing = false;

            private boolean displayWarningAndAskIfWeShouldContinue(String msg, String title) {
                boolean result;
                if (this.keepGoing) {
                    return true;
                }
                boolean bl = result = JOptionPane.showConfirmDialog(NewProjectWizard.this, msg, title, 2, 2) == 0;
                if (result) {
                    this.keepGoing = true;
                }
                return result;
            }

            public void actionPerformed(ActionEvent evt) {
                String name;
                int i;
                boolean resetSettings;
                Project p;
                File temp;
                int i2;
                for (i2 = 0; i2 < NewProjectWizard.this.analyzeModel.getSize(); ++i2) {
                    temp = new File((String)NewProjectWizard.this.analyzeModel.get(i2));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return;
                }
                for (i2 = 0; i2 < NewProjectWizard.this.sourceModel.getSize(); ++i2) {
                    temp = new File((String)NewProjectWizard.this.sourceModel.get(i2));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return;
                }
                for (i2 = 0; i2 < NewProjectWizard.this.auxModel.getSize(); ++i2) {
                    temp = new File((String)NewProjectWizard.this.auxModel.get(i2));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return;
                }
                if (NewProjectWizard.this.project == null) {
                    p = new Project();
                    resetSettings = true;
                } else {
                    p = NewProjectWizard.this.project;
                    resetSettings = false;
                }
                int numOldFiles = p.getFileCount();
                for (int x = 0; x < numOldFiles; ++x) {
                    p.removeFile(0);
                }
                int numOldAuxFiles = p.getNumAuxClasspathEntries();
                for (int x = 0; x < numOldAuxFiles; ++x) {
                    p.removeAuxClasspathEntry(0);
                }
                int numOldSrc = p.getNumSourceDirs();
                for (int x = 0; x < numOldSrc; ++x) {
                    p.removeSourceDir(0);
                }
                for (i = 0; i < NewProjectWizard.this.analyzeModel.getSize(); ++i) {
                    p.addFile((String)NewProjectWizard.this.analyzeModel.get(i));
                }
                for (i = 0; i < NewProjectWizard.this.auxModel.getSize(); ++i) {
                    p.addAuxClasspathEntry((String)NewProjectWizard.this.auxModel.get(i));
                }
                for (i = 0; i < NewProjectWizard.this.sourceModel.getSize(); ++i) {
                    p.addSourceDir((String)NewProjectWizard.this.sourceModel.get(i));
                }
                p.setProjectName(NewProjectWizard.this.projectName.getText());
                if (this.keepGoing) {
                    MainFrame.getInstance().setProject(p);
                } else if (NewProjectWizard.this.project == null || NewProjectWizard.this.projectChanged && JOptionPane.showConfirmDialog(NewProjectWizard.this, L10N.getLocalString("dlg.project_settings_changed_lbl", "Project settings have been changed.  Perform a new analysis with the changed files?"), L10N.getLocalString("dlg.redo_analysis_question_lbl", "Redo analysis?"), 0) == 0) {
                    new AnalyzingDialog(p, resetSettings);
                }
                if (reconfig) {
                    MainFrame.getInstance().setProjectChanged(true);
                }
                if ((name = p.getProjectName()) == null) {
                    name = "<<unnamed project>>";
                    Debug.println("PROJECT NAME IS NULL!!");
                }
                if (NewProjectWizard.this.projectNameChanged) {
                    MainFrame.getInstance().setTitle("FindBugs: " + name);
                }
                NewProjectWizard.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectWizard.this.dispose();
            }
        });
        JPanel south = new JPanel(new BorderLayout());
        south.add((Component)new JSeparator(), "North");
        south.add((Component)buttons, "East");
        if (curProject != null) {
            for (String i : curProject.getFileList()) {
                this.analyzeModel.addElement(i);
            }
            if (curProject.getFileList().size() == 0) {
                this.finishButton.setEnabled(false);
            }
            for (String i : curProject.getAuxClasspathEntryList()) {
                this.auxModel.addElement(i);
            }
            for (String i : curProject.getSourceDirList()) {
                this.sourceModel.addElement(i);
            }
            this.projectName.setText(curProject.getProjectName());
            this.projectName.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    NewProjectWizard.this.projectNameChanged = true;
                }
            });
        } else {
            this.finishButton.setEnabled(false);
        }
        this.loadAllPanels(mainPanel);
        this.add((Component)mainPanel, "Center");
        this.add((Component)south, "South");
        this.add((Component)this.createTextFieldPanel("Project name (i.e., description)", this.projectName), "North");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setVisible(true);
    }

    private JComponent createTextFieldPanel(String label, JTextField textField) {
        JPanel myPanel = new JPanel(new BorderLayout());
        myPanel.add((Component)new JLabel(label), "North");
        myPanel.add((Component)textField, "Center");
        return myPanel;
    }

    private JPanel createFilePanel(final String label, final JList list, final DefaultListModel listModel, final int fileSelectionMode, final FileFilter filter, final String dialogTitle, boolean wizard) {
        JPanel myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        myPanel.add((Component)new JLabel(label), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        myPanel.add((Component)new JScrollPane(list), gbc);
        list.setModel(listModel);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton addButton = new JButton(L10N.getLocalString("dlg.add_btn", "Add"));
        myPanel.add((Component)addButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        JButton removeButton = new JButton(L10N.getLocalString("dlg.remove_btn", "Remove"));
        myPanel.add((Component)removeButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        JButton wizardButton = new JButton("Wizard");
        if (wizard) {
            final NewProjectWizard thisGUI = this;
            myPanel.add((Component)wizardButton, gbc);
            wizardButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int i;
                    final Project tempProject = new Project();
                    for (i = 0; i < NewProjectWizard.this.analyzeModel.getSize(); ++i) {
                        tempProject.addFile((String)NewProjectWizard.this.analyzeModel.get(i));
                    }
                    for (i = 0; i < NewProjectWizard.this.auxModel.getSize(); ++i) {
                        tempProject.addAuxClasspathEntry((String)NewProjectWizard.this.auxModel.get(i));
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            final SourceDirectoryWizard dialog = new SourceDirectoryWizard((Frame)new JFrame(), true, tempProject, thisGUI);
                            dialog.addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent e) {
                                    if (dialog.discover != null && dialog.discover.isAlive()) {
                                        dialog.discover.interrupt();
                                    }
                                }
                            });
                            dialog.setVisible(true);
                        }
                    });
                }
            });
        }
        gbc.insets = new Insets(0, 0, 0, 0);
        myPanel.add(Box.createGlue(), gbc);
        myPanel.setBorder(this.border);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewProjectWizard.this.chooser.setFileSelectionMode(fileSelectionMode);
                NewProjectWizard.this.chooser.setMultiSelectionEnabled(true);
                NewProjectWizard.this.chooser.setApproveButtonText("Choose");
                NewProjectWizard.this.chooser.setDialogTitle(dialogTitle);
                for (FileFilter ff : NewProjectWizard.this.chooser.getChoosableFileFilters()) {
                    NewProjectWizard.this.chooser.removeChoosableFileFilter(ff);
                }
                NewProjectWizard.this.chooser.setFileFilter(filter);
                if (NewProjectWizard.this.chooser.showOpenDialog(NewProjectWizard.this) == 0) {
                    File[] selectedFiles;
                    for (File selectedFile : selectedFiles = NewProjectWizard.this.chooser.getSelectedFiles()) {
                        listModel.addElement(selectedFile.getAbsolutePath());
                    }
                    NewProjectWizard.this.projectChanged = true;
                    if (label.equals(L10N.getLocalString("dlg.class_jars_dirs_lbl", "Class archives and directories to analyze:"))) {
                        NewProjectWizard.this.finishButton.setEnabled(true);
                    }
                }
            }
        });
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (list.getSelectedValues().length > 0) {
                    NewProjectWizard.this.projectChanged = true;
                }
                for (Object i : list.getSelectedValues()) {
                    listModel.removeElement(i);
                }
                if (listModel.size() == 0 && label.equals(L10N.getLocalString("dlg.class_jars_dirs_lbl", "Class archives and directories to analyze:"))) {
                    NewProjectWizard.this.finishButton.setEnabled(false);
                }
            }
        });
        return myPanel;
    }

    private void loadAllPanels(final JPanel mainPanel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                int numPanels = NewProjectWizard.this.wizardComponents.length;
                for (i = 0; i < numPanels; ++i) {
                    mainPanel.remove(NewProjectWizard.this.wizardComponents[i]);
                }
                for (i = 0; i < numPanels; ++i) {
                    mainPanel.add(NewProjectWizard.this.wizardComponents[i]);
                }
                NewProjectWizard.this.validate();
                NewProjectWizard.this.repaint();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        for (JComponent component : this.wizardComponents) {
            this.setFontSizeHelper(component.getComponents(), Driver.getFontSize());
        }
        this.pack();
        int width = super.getWidth();
        if (width < 600) {
            width = 600;
        }
        this.setSize(new Dimension(width, 500));
        this.setLocationRelativeTo(MainFrame.getInstance());
    }

    public void setSourceDirecs(DefaultListModel foundModel) {
        for (int i = 0; i < foundModel.size(); ++i) {
            this.sourceModel.addElement(foundModel.getElementAt(i));
        }
    }
}

