/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.sourceViewer.JavaSourceDocument;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;

public final class SourceCodeDisplay
implements Runnable {
    final MainFrame frame;
    private static final Color MAIN_HIGHLIGHT = new Color(1.0f, 1.0f, 0.5f);
    private static final Color MAIN_HIGHLIGHT_MORE = MAIN_HIGHLIGHT.brighter();
    private static final Color ALTERNATIVE_HIGHLIGHT = new Color(0.86f, 0.9f, 1.0f);
    private static final Color FOUND_HIGHLIGHT = new Color(0.75f, 0.75f, 1.0f);
    static final Document SOURCE_NOT_RELEVANT = new DefaultStyledDocument();
    public JavaSourceDocument myDocument;
    private int currentChar = -1;
    private final Map<String, SoftReference<JavaSourceDocument>> map = new HashMap<String, SoftReference<JavaSourceDocument>>();
    private boolean pendingUpdate;
    @CheckForNull
    private BugInstance bugToDisplay;
    private SourceLineAnnotation sourceToHighlight;

    SourceCodeDisplay(MainFrame frame) {
        this.frame = frame;
        Thread t = new Thread((Runnable)this, "Source code display thread");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void displaySource(BugInstance bug, SourceLineAnnotation source) {
        this.bugToDisplay = bug;
        this.sourceToHighlight = source;
        this.pendingUpdate = true;
        this.notifyAll();
    }

    public void clearCache() {
        this.map.clear();
    }

    @NonNull
    private JavaSourceDocument getDocument(SourceLineAnnotation source) {
        try {
            SourceFile sourceFile = this.frame.getProject().getSourceFinder().findSourceFile(source);
            String fullFileName = sourceFile.getFullFileName();
            SoftReference<JavaSourceDocument> resultReference = this.map.get(fullFileName);
            JavaSourceDocument result = null;
            if (resultReference != null) {
                result = resultReference.get();
            }
            if (result != null) {
                return result;
            }
            try {
                InputStream in = sourceFile.getInputStream();
                result = new JavaSourceDocument(source.getClassName(), new InputStreamReader(in), sourceFile);
            }
            catch (Exception e) {
                result = JavaSourceDocument.UNKNOWNSOURCE;
                Debug.println(e);
            }
            this.map.put(fullFileName, new SoftReference<JavaSourceDocument>(result));
            return result;
        }
        catch (Exception e) {
            Debug.println(e);
            return JavaSourceDocument.UNKNOWNSOURCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SourceLineAnnotation mySourceLine;
            BugInstance myBug;
            SourceCodeDisplay sourceCodeDisplay = this;
            synchronized (sourceCodeDisplay) {
                while (!this.pendingUpdate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {}
                }
                myBug = this.bugToDisplay;
                mySourceLine = this.sourceToHighlight;
                this.bugToDisplay = null;
                this.sourceToHighlight = null;
                this.pendingUpdate = false;
            }
            if (myBug == null || mySourceLine == null) {
                this.frame.clearSourcePane();
                continue;
            }
            try {
                JavaSourceDocument src;
                this.myDocument = src = this.getDocument(mySourceLine);
                src.getHighlightInformation().clear();
                String primaryKind = mySourceLine.getDescription();
                Iterator<BugAnnotation> i = myBug.annotationIterator();
                while (i.hasNext()) {
                    SourceLineAnnotation sourceAnnotation;
                    BugAnnotation annotation = i.next();
                    if (!(annotation instanceof SourceLineAnnotation) || (sourceAnnotation = (SourceLineAnnotation)annotation) == mySourceLine) continue;
                    if (sourceAnnotation.getDescription().equals(primaryKind)) {
                        this.highlight(src, sourceAnnotation, MAIN_HIGHLIGHT_MORE);
                        continue;
                    }
                    this.highlight(src, sourceAnnotation, ALTERNATIVE_HIGHLIGHT);
                }
                this.highlight(src, mySourceLine, MAIN_HIGHLIGHT);
                final BugInstance thisBug = myBug;
                final SourceLineAnnotation thisSource = mySourceLine;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SourceCodeDisplay.this.frame.sourceCodeTextPane.setEditorKit(src.getEditorKit());
                        StyledDocument document = src.getDocument();
                        SourceCodeDisplay.this.frame.sourceCodeTextPane.setDocument(document);
                        String sourceFile = thisSource.getSourceFile();
                        if (sourceFile == null || sourceFile.equals("<Unknown>")) {
                            sourceFile = thisSource.getSimpleClassName();
                        }
                        int startLine = thisSource.getStartLine();
                        int endLine = thisSource.getEndLine();
                        SourceCodeDisplay.this.frame.setSourceTab(sourceFile + " in " + thisSource.getPackageName(), thisBug);
                        int originLine = (startLine + endLine) / 2;
                        LinkedList<Integer> otherLines = new LinkedList<Integer>();
                        Iterator<BugAnnotation> i = thisBug.annotationIterator();
                        while (i.hasNext()) {
                            SourceLineAnnotation sourceAnnotation;
                            BugAnnotation annotation = i.next();
                            if (!(annotation instanceof SourceLineAnnotation) || (sourceAnnotation = (SourceLineAnnotation)annotation) == thisSource) continue;
                            int otherLine = sourceAnnotation.getStartLine();
                            if (otherLine > originLine) {
                                otherLine = sourceAnnotation.getEndLine();
                            }
                            otherLines.add(otherLine);
                        }
                        if (startLine >= 0 && endLine >= 0) {
                            SourceCodeDisplay.this.frame.sourceCodeTextPane.scrollLinesToVisible(startLine, endLine, otherLines);
                        }
                    }
                });
                continue;
            }
            catch (Exception e) {
                Debug.println(e);
                continue;
            }
            break;
        }
    }

    private void highlight(JavaSourceDocument src, SourceLineAnnotation sourceAnnotation, Color color) {
        int startLine = sourceAnnotation.getStartLine();
        if (startLine == -1) {
            return;
        }
        String sourceFile = sourceAnnotation.getSourcePath();
        String sourceFile2 = src.getSourceFile().getFullFileName();
        if (!File.separator.equals(String.valueOf('/'))) {
            sourceFile2 = sourceFile2.replace(File.separatorChar, '/');
        }
        if (!sourceFile2.endsWith(sourceFile)) {
            return;
        }
        src.getHighlightInformation().setHighlight(startLine, sourceAnnotation.getEndLine(), color);
    }

    public void foundItem(int lineNum) {
        this.myDocument.getHighlightInformation().updateFoundLineNum(lineNum);
        this.myDocument.getHighlightInformation().setHighlight(lineNum, FOUND_HIGHLIGHT);
        this.frame.sourceCodeTextPane.scrollLineToVisible(lineNum);
        this.frame.sourceCodeTextPane.updateUI();
    }

    private int search(JavaSourceDocument document, String target, int start, Boolean backwards) {
        int i;
        int sourceLen;
        if (document == null) {
            return -1;
        }
        String docContent = null;
        try {
            StyledDocument document2 = document.getDocument();
            if (document2 == null) {
                return -1;
            }
            docContent = document2.getText(0, document2.getLength());
        }
        catch (BadLocationException ble) {
            System.out.println("Bad location exception");
        }
        catch (NullPointerException npe) {
            return -1;
        }
        if (docContent == null) {
            return -1;
        }
        int targetLen = target.length();
        if (targetLen > (sourceLen = docContent.length())) {
            return -1;
        }
        if (backwards.booleanValue()) {
            int i2;
            for (i2 = start; i2 >= 0; --i2) {
                if (!docContent.substring(i2, i2 + targetLen).equals(target)) continue;
                return i2;
            }
            for (i2 = sourceLen - targetLen; i2 > start; --i2) {
                if (!docContent.substring(i2, i2 + targetLen).equals(target)) continue;
                return i2;
            }
            return -1;
        }
        for (i = start; i <= sourceLen - targetLen; ++i) {
            if (!docContent.substring(i, i + targetLen).equals(target)) continue;
            return i;
        }
        for (i = 0; i < start; ++i) {
            if (!docContent.substring(i, i + targetLen).equals(target)) continue;
            return i;
        }
        return -1;
    }

    private int charToLineNum(int charNum) {
        if (charNum == -1) {
            return -1;
        }
        try {
            int i = 1;
            while (true) {
                if (this.frame.sourceCodeTextPane.getLineOffset(i) > charNum) {
                    return i - 1;
                }
                if (this.frame.sourceCodeTextPane.getLineOffset(i) == -1) {
                    return -1;
                }
                ++i;
            }
        }
        catch (BadLocationException ble) {
            return -1;
        }
    }

    public int find(String target) {
        int charFoundAt;
        this.currentChar = charFoundAt = this.search(this.myDocument, target, 0, false);
        return this.charToLineNum(this.currentChar);
    }

    public int findNext(String target) {
        int charFoundAt;
        this.currentChar = charFoundAt = this.search(this.myDocument, target, this.currentChar + 1, false);
        return this.charToLineNum(this.currentChar);
    }

    public int findPrevious(String target) {
        int charFoundAt;
        this.currentChar = charFoundAt = this.search(this.myDocument, target, this.currentChar - 1, true);
        return this.charToLineNum(this.currentChar);
    }

    private void show(JTextPane pane, Document src, SourceLineAnnotation sourceAnnotation) {
        int startLine = sourceAnnotation.getStartLine();
        if (startLine == -1) {
            return;
        }
        this.frame.sourceCodeTextPane.scrollLineToVisible(startLine);
    }

    public void showLine(int line) {
        this.frame.sourceCodeTextPane.scrollLineToVisible(line);
    }
}

