/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.model;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFeatureSet
implements XMLWriteable {
    public static final String CLASS_NAME_KEY = "Class:";
    public static final String METHOD_NAME_KEY = "Method:";
    public static final String CODE_LENGTH_KEY = "CodeLength:";
    public static final String FIELD_NAME_KEY = "Field:";
    private String className;
    private boolean isInterface;
    private Set<String> featureSet = new HashSet<String>();
    public static final int MIN_CODE_LENGTH = 10;
    public static final int MIN_FEATURES = 5;
    public static final double MIN_MATCH = 0.6;
    public static final double EXACT_CLASS_NAME_MATCH = 0.7;
    public static final String ELEMENT_NAME = "ClassFeatureSet";
    public static final String FEATURE_ELEMENT_NAME = "Feature";

    public ClassFeatureSet initialize(JavaClass javaClass) {
        this.className = javaClass.getClassName();
        this.isInterface = javaClass.isInterface();
        this.addFeature(CLASS_NAME_KEY + ClassFeatureSet.transformClassName(javaClass.getClassName()));
        for (Method method : javaClass.getMethods()) {
            Code code;
            if (this.isSynthetic((FieldOrMethod)method)) continue;
            String transformedMethodSignature = ClassFeatureSet.transformMethodSignature(method.getSignature());
            if (method.isStatic() || !this.overridesSuperclassMethod(javaClass, method)) {
                this.addFeature(METHOD_NAME_KEY + method.getName() + ":" + transformedMethodSignature);
            }
            if ((code = method.getCode()) == null || code.getCode() == null || code.getCode().length < 10) continue;
            this.addFeature(CODE_LENGTH_KEY + method.getName() + ":" + transformedMethodSignature + ":" + code.getCode().length);
        }
        for (Method method : javaClass.getFields()) {
            if (this.isSynthetic((FieldOrMethod)method)) continue;
            this.addFeature(FIELD_NAME_KEY + method.getName() + ":" + ClassFeatureSet.transformSignature(method.getSignature()));
        }
        return this;
    }

    private boolean overridesSuperclassMethod(JavaClass javaClass, Method method) {
        if (method.isStatic()) {
            return false;
        }
        try {
            JavaClassAndMethod match;
            JavaClassAndMethod match2;
            JavaClass[] superclassList = javaClass.getSuperClasses();
            if (superclassList != null && (match2 = Hierarchy.findMethod(superclassList, method.getName(), method.getSignature(), Hierarchy.INSTANCE_METHOD)) != null) {
                return true;
            }
            JavaClass[] interfaceList = javaClass.getAllInterfaces();
            return interfaceList != null && (match = Hierarchy.findMethod(interfaceList, method.getName(), method.getSignature(), Hierarchy.INSTANCE_METHOD)) != null;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    private boolean isSynthetic(FieldOrMethod member) {
        if (member.isSynthetic()) {
            return true;
        }
        String name = member.getName();
        if (name.startsWith("class$")) {
            return true;
        }
        return name.startsWith("access$");
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public int getNumFeatures() {
        return this.featureSet.size();
    }

    public void addFeature(String feature) {
        this.featureSet.add(feature);
    }

    public Iterator<String> featureIterator() {
        return this.featureSet.iterator();
    }

    public boolean hasFeature(String feature) {
        return this.featureSet.contains(feature);
    }

    public static String transformClassName(String className) {
        String pkg;
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0 && !ClassFeatureSet.isUnlikelyToBeRenamed(pkg = className.substring(0, lastDot))) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }

    public static boolean isUnlikelyToBeRenamed(String pkg) {
        return pkg.startsWith("java.");
    }

    public static String transformMethodSignature(String signature) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        SignatureParser parser = new SignatureParser(signature);
        Iterator<String> i = parser.parameterSignatureIterator();
        while (i.hasNext()) {
            String param = i.next();
            param = ClassFeatureSet.transformSignature(param);
            buf.append(param);
        }
        buf.append(')');
        return buf.toString();
    }

    public static String transformSignature(String signature) {
        StringBuilder buf = new StringBuilder();
        int lastBracket = signature.lastIndexOf(91);
        if (lastBracket > 0) {
            buf.append(signature.substring(0, lastBracket + 1));
            signature = signature.substring(lastBracket + 1);
        }
        if (signature.startsWith("L")) {
            signature = signature.substring(1, signature.length() - 1).replace('/', '.');
            signature = ClassFeatureSet.transformClassName(signature);
            signature = "L" + signature.replace('.', '/') + ";";
        }
        buf.append(signature);
        return buf.toString();
    }

    public static double similarity(ClassFeatureSet a, ClassFeatureSet b) {
        if (a.isInterface() != b.isInterface()) {
            return 0.0;
        }
        if (a.getNumFeatures() < 5 || b.getNumFeatures() < 5) {
            return a.getClassName().equals(b.getClassName()) ? 0.7 : 0.0;
        }
        int numMatch = 0;
        int max = Math.max(a.getNumFeatures(), b.getNumFeatures());
        Iterator<String> i = a.featureIterator();
        while (i.hasNext()) {
            String feature = i.next();
            if (!b.hasFeature(feature)) continue;
            ++numMatch;
        }
        return (double)numMatch / (double)max;
    }

    public boolean similarTo(ClassFeatureSet other) {
        return ClassFeatureSet.similarity(this, other) >= 0.6;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + ClassFeatureSet.class.getName() + " <class 1> <class 2>");
            System.exit(1);
        }
        JavaClass a = Repository.lookupClass((String)args[0]);
        JavaClass b = Repository.lookupClass((String)args[1]);
        ClassFeatureSet aFeatures = new ClassFeatureSet().initialize(a);
        ClassFeatureSet bFeatures = new ClassFeatureSet().initialize(b);
        System.out.println("Similarity is " + ClassFeatureSet.similarity(aFeatures, bFeatures));
        System.out.println("Classes are" + (aFeatures.similarTo(bFeatures) ? "" : " not") + " similar");
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.openTag(ELEMENT_NAME, new XMLAttributeList().addAttribute("class", this.className));
        Iterator<String> i = this.featureIterator();
        while (i.hasNext()) {
            String feature = i.next();
            xmlOutput.openCloseTag(FEATURE_ELEMENT_NAME, new XMLAttributeList().addAttribute("value", feature));
        }
        xmlOutput.closeTag(ELEMENT_NAME);
    }
}

