/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;

class BugCounts {
    protected int[] nBugs;

    BugCounts() {
    }

    @OverridingMethodsMustInvokeSuper
    public void addError(BugInstance bug) {
        this.ensureNonnullBugCounts();
        int n = bug.getPriority();
        this.nBugs[n] = this.nBugs[n] + 1;
        this.nBugs[0] = this.nBugs[0] + 1;
    }

    protected void ensureNonnullBugCounts() {
        if (this.nBugs == null) {
            this.nBugs = new int[]{0, 0, 0, 0, 0};
        }
    }

    public final int getTotalBugs() {
        if (this.nBugs == null) {
            return 0;
        }
        return this.nBugs[0];
    }

    public final int getBugsAtPriority(int p) {
        if (this.nBugs == null) {
            return 0;
        }
        return this.nBugs[p];
    }

    public void clearBugCounts() {
        this.nBugs = null;
    }

    public void writeBugPriorities(XMLOutput xmlOutput) throws IOException {
        if (this.nBugs == null) {
            return;
        }
        BugCounts.writeBugPriorities(xmlOutput, this.nBugs);
    }

    public static void writeBugPriorities(XMLOutput xmlOutput, @Nonnull int[] nBugs) throws IOException {
        int i = nBugs.length;
        while (--i > 0) {
            if (nBugs[i] <= 0) continue;
            xmlOutput.addAttribute("priority_" + i, String.valueOf(nBugs[i]));
        }
    }
}

