/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCounts;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Footprint;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.workflow.FileBugHash;
import edu.umd.cs.findbugs.xml.OutputStreamXMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.WillClose;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ProjectStats
implements XMLWriteable,
Cloneable {
    private static final String TIMESTAMP_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";
    private static final boolean OMIT_PACKAGE_STATS = SystemProperties.getBoolean("findbugs.packagestats.omit");
    private final SortedMap<String, PackageStats> packageStatsMap;
    private final int[] totalErrors = new int[]{0, 0, 0, 0, 0};
    private int totalClasses = 0;
    private int referencedClasses;
    private int totalSize;
    private int totalSizeFromPackageStats;
    private int totalClassesFromPackageStats;
    private Date analysisTimestamp;
    private boolean hasClassStats;
    private boolean hasPackageStats;
    private final Footprint baseFootprint;
    private final String java_version = SystemProperties.getProperty("java.version");
    private String java_vm_version = SystemProperties.getProperty("java.vm.version");
    private final Profiler profiler;
    FileBugHash fileBugHashes;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getNumClasses()).append(" classes: ");
        for (PackageStats pStats : this.getPackageStats()) {
            for (PackageStats.ClassStats cStats : pStats.getSortedClassStats()) {
                buf.append(cStats.getName()).append(" ");
            }
        }
        return buf.toString();
    }

    public ProjectStats() {
        this.packageStatsMap = new TreeMap<String, PackageStats>();
        this.analysisTimestamp = new Date();
        this.baseFootprint = new Footprint();
        this.profiler = new Profiler();
    }

    public boolean hasClassStats() {
        return this.hasClassStats;
    }

    public boolean hasPackageStats() {
        return this.hasPackageStats;
    }

    public ProjectStats clone() {
        try {
            return (ProjectStats)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getCodeSize() {
        if (this.totalSizeFromPackageStats > 0) {
            return this.totalSizeFromPackageStats;
        }
        return this.totalSize;
    }

    public int getTotalBugs() {
        return this.totalErrors[0];
    }

    public int getBugsOfPriority(int priority) {
        return this.totalErrors[priority];
    }

    public void setTimestamp(String timestamp) throws ParseException {
        this.analysisTimestamp = new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).parse(timestamp);
    }

    public void setTimestamp(long timestamp) {
        this.analysisTimestamp = new Date(timestamp);
    }

    public void setVMVersion(String vm_version) {
        this.java_vm_version = vm_version;
    }

    public int getNumClasses() {
        if (this.totalClassesFromPackageStats > 0) {
            return this.totalClassesFromPackageStats;
        }
        return this.totalClasses;
    }

    public Footprint getBaseFootprint() {
        return this.baseFootprint;
    }

    public void addClass(@DottedClassName String className, @CheckForNull String sourceFile, boolean isInterface, int size) {
        this.addClass(className, sourceFile, isInterface, size, true);
    }

    public void addClass(@DottedClassName String className, @CheckForNull String sourceFile, boolean isInterface, int size, boolean updatePackageStats) {
        if (!this.hasClassStats) {
            this.totalClasses = 0;
            this.totalSize = 0;
        }
        this.hasClassStats = true;
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot < 0 ? "" : className.substring(0, lastDot);
        PackageStats stat = this.getPackageStats(packageName);
        stat.addClass(className, sourceFile, isInterface, size, updatePackageStats);
        ++this.totalClasses;
        this.totalSize += size;
        this.totalClassesFromPackageStats = 0;
        this.totalSizeFromPackageStats = 0;
    }

    @CheckForNull
    public PackageStats.ClassStats getClassStats(@DottedClassName String className) {
        if (this.hasClassStats) {
            return null;
        }
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot < 0 ? "" : className.substring(0, lastDot);
        PackageStats stat = this.getPackageStats(packageName);
        return stat.getClassStatsOrNull(className);
    }

    public void addBug(BugInstance bug) {
        SourceLineAnnotation source = bug.getPrimarySourceLineAnnotation();
        PackageStats stat = this.getPackageStats(source.getPackageName());
        stat.addError(bug);
        this.totalErrors[0] = this.totalErrors[0] + 1;
        int priority = bug.getPriority();
        if (priority >= 1) {
            int n = Math.min(priority, this.totalErrors.length - 1);
            this.totalErrors[n] = this.totalErrors[n] + 1;
        }
    }

    public void clearBugCounts() {
        for (int i = 0; i < this.totalErrors.length; ++i) {
            this.totalErrors[i] = 0;
        }
        for (PackageStats stats : this.packageStatsMap.values()) {
            stats.clearBugCounts();
        }
    }

    public void purgeClassesThatDontMatch(Pattern classPattern) {
        block5: {
            Matcher m;
            block4: {
                if (!this.hasClassStats) break block4;
                Iterator<Map.Entry<String, PackageStats>> i = this.packageStatsMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, PackageStats> e = i.next();
                    PackageStats stats = e.getValue();
                    stats.purgeClassesThatDontMatch(classPattern);
                    if (!stats.getClassStats().isEmpty()) continue;
                    i.remove();
                }
                break block5;
            }
            if (!this.hasPackageStats) break block5;
            boolean matchAny = false;
            for (String packageName : this.packageStatsMap.keySet()) {
                m = classPattern.matcher(packageName);
                if (!m.lookingAt()) continue;
                matchAny = true;
                break;
            }
            if (matchAny) {
                Iterator<String> i = this.packageStatsMap.keySet().iterator();
                while (i.hasNext()) {
                    String packageName;
                    packageName = i.next();
                    m = classPattern.matcher(packageName);
                    if (m.lookingAt()) continue;
                    i.remove();
                }
            }
        }
    }

    public void purgeClassStats() {
        this.hasClassStats = false;
        if (this.totalClassesFromPackageStats == 0) {
            this.totalClassesFromPackageStats = this.totalClasses;
        }
        if (this.totalSizeFromPackageStats == 0) {
            this.totalSizeFromPackageStats = this.totalSize;
        }
        for (PackageStats ps : this.getPackageStats()) {
            ps.getClassStats().clear();
        }
    }

    public void purgePackageStats() {
        this.hasPackageStats = false;
        if (this.totalClassesFromPackageStats == 0) {
            this.totalClassesFromPackageStats = this.totalClasses;
        }
        if (this.totalSizeFromPackageStats == 0) {
            this.totalSizeFromPackageStats = this.totalSize;
        }
        this.getPackageStats().clear();
    }

    public void recomputeFromComponents() {
        if (!this.hasClassStats && !this.hasPackageStats) {
            return;
        }
        for (int i = 0; i < this.totalErrors.length; ++i) {
            this.totalErrors[i] = 0;
        }
        this.totalSize = 0;
        this.totalClasses = 0;
        this.totalSizeFromPackageStats = 0;
        this.totalClassesFromPackageStats = 0;
        for (PackageStats stats : this.packageStatsMap.values()) {
            if (this.hasClassStats) {
                stats.recomputeFromClassStats();
            }
            this.totalSize += stats.size();
            this.totalClasses += stats.getNumClasses();
            for (int i = 0; i < this.totalErrors.length; ++i) {
                int n = i;
                this.totalErrors[n] = this.totalErrors[n] + stats.getBugsAtPriority(i);
            }
        }
    }

    public void computeFileStats(BugCollection bugs) {
        if (bugs.getProjectStats() != this) {
            throw new IllegalArgumentException("Collection doesn't own stats");
        }
        this.fileBugHashes = FileBugHash.compute(bugs);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        this.writeXML(xmlOutput, true);
    }

    public void writeXML(XMLOutput xmlOutput, boolean withMessages) throws IOException {
        long peakMemory;
        long clockTime;
        xmlOutput.startTag("FindBugsSummary");
        xmlOutput.addAttribute("timestamp", new SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).format(this.analysisTimestamp));
        xmlOutput.addAttribute("total_classes", String.valueOf(this.getNumClasses()));
        xmlOutput.addAttribute("referenced_classes", String.valueOf(this.referencedClasses));
        xmlOutput.addAttribute("total_bugs", String.valueOf(this.totalErrors[0]));
        xmlOutput.addAttribute("total_size", String.valueOf(this.getCodeSize()));
        xmlOutput.addAttribute("num_packages", String.valueOf(this.packageStatsMap.size()));
        if (this.java_version != null) {
            xmlOutput.addAttribute("java_version", this.java_version);
        }
        if (this.java_vm_version != null) {
            xmlOutput.addAttribute("vm_version", this.java_vm_version);
        }
        Footprint delta = new Footprint(this.baseFootprint);
        NumberFormat twoPlaces = NumberFormat.getInstance(Locale.ENGLISH);
        twoPlaces.setMinimumFractionDigits(2);
        twoPlaces.setMaximumFractionDigits(2);
        twoPlaces.setGroupingUsed(false);
        long cpuTime = delta.getCpuTime();
        if (cpuTime >= 0L) {
            xmlOutput.addAttribute("cpu_seconds", twoPlaces.format((double)cpuTime / 1.0E9));
        }
        if ((clockTime = delta.getClockTime()) >= 0L) {
            xmlOutput.addAttribute("clock_seconds", twoPlaces.format((double)clockTime / 1000.0));
        }
        if ((peakMemory = delta.getPeakMemory()) >= 0L) {
            xmlOutput.addAttribute("peak_mbytes", twoPlaces.format((double)peakMemory / 1048576.0));
        }
        xmlOutput.addAttribute("alloc_mbytes", twoPlaces.format((double)Runtime.getRuntime().maxMemory() / 1048576.0));
        long gcTime = delta.getCollectionTime();
        if (gcTime >= 0L) {
            xmlOutput.addAttribute("gc_seconds", twoPlaces.format((double)gcTime / 1000.0));
        }
        BugCounts.writeBugPriorities(xmlOutput, this.totalErrors);
        xmlOutput.stopTag(false);
        if (withMessages && this.fileBugHashes != null) {
            for (String sourceFile : new TreeSet<String>(this.fileBugHashes.getSourceFiles())) {
                xmlOutput.startTag("FileStats");
                xmlOutput.addAttribute("path", sourceFile);
                xmlOutput.addAttribute("bugCount", String.valueOf(this.fileBugHashes.getBugCount(sourceFile)));
                xmlOutput.addAttribute("size", String.valueOf(this.fileBugHashes.getSize(sourceFile)));
                String hash = this.fileBugHashes.getHash(sourceFile);
                if (hash != null) {
                    xmlOutput.addAttribute("bugHash", hash);
                }
                xmlOutput.stopTag(true);
            }
        }
        if (!OMIT_PACKAGE_STATS) {
            for (PackageStats stats : this.packageStatsMap.values()) {
                stats.writeXML(xmlOutput);
            }
        }
        this.getProfiler().writeXML(xmlOutput);
        xmlOutput.closeTag("FindBugsSummary");
    }

    public Map<String, String> getFileHashes(BugCollection bugs) {
        if (bugs.getProjectStats() != this) {
            throw new IllegalArgumentException("Collection doesn't own stats");
        }
        if (this.fileBugHashes == null) {
            this.computeFileStats(bugs);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String sourceFile : this.fileBugHashes.getSourceFiles()) {
            result.put(sourceFile, this.fileBugHashes.getHash(sourceFile));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSummary(@WillClose OutputStream out) throws IOException {
        OutputStreamXMLOutput xmlOutput = new OutputStreamXMLOutput(out);
        try {
            this.writeXML(xmlOutput);
        }
        finally {
            xmlOutput.finish();
        }
    }

    public void transformSummaryToHTML(Writer htmlWriter) throws IOException, TransformerException {
        ByteArrayOutputStream summaryOut = new ByteArrayOutputStream(8096);
        this.reportSummary(summaryOut);
        StreamSource in = new StreamSource(new ByteArrayInputStream(summaryOut.toByteArray()));
        StreamResult out = new StreamResult(htmlWriter);
        InputStream xslInputStream = this.getClass().getClassLoader().getResourceAsStream("summary.xsl");
        if (xslInputStream == null) {
            throw new IOException("Could not load summary stylesheet");
        }
        StreamSource xsl = new StreamSource(xslInputStream);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer(xsl);
        transformer.transform(in, out);
        Reader rdr = in.getReader();
        if (rdr != null) {
            rdr.close();
        }
        htmlWriter.close();
        InputStream is = xsl.getInputStream();
        if (is != null) {
            is.close();
        }
    }

    public Collection<PackageStats> getPackageStats() {
        return this.packageStatsMap.values();
    }

    private PackageStats getPackageStats(String packageName) {
        PackageStats stat = (PackageStats)this.packageStatsMap.get(packageName);
        if (stat == null) {
            stat = new PackageStats(packageName);
            this.packageStatsMap.put(packageName, stat);
        }
        return stat;
    }

    public void putPackageStats(String packageName, int numClasses, int size) {
        this.hasPackageStats = true;
        PackageStats stat = (PackageStats)this.packageStatsMap.get(packageName);
        if (stat == null) {
            stat = new PackageStats(packageName, numClasses, size);
            this.totalSizeFromPackageStats += size;
            this.totalClassesFromPackageStats += numClasses;
            this.packageStatsMap.put(packageName, stat);
        } else {
            this.totalSizeFromPackageStats += size - stat.size();
            this.totalClassesFromPackageStats += numClasses - stat.getNumClasses();
            stat.setNumClasses(numClasses);
            stat.setSize(size);
        }
    }

    public void addStats(ProjectStats stats2) {
        if (this.totalSize == this.totalSizeFromPackageStats) {
            this.totalSizeFromPackageStats += stats2.getCodeSize();
        }
        this.totalSize += stats2.getCodeSize();
        if (this.totalClasses == this.totalClassesFromPackageStats) {
            this.totalClassesFromPackageStats += stats2.getNumClasses();
        }
        this.totalClasses += stats2.getNumClasses();
        for (int i = 0; i < this.totalErrors.length; ++i) {
            int n = i;
            this.totalErrors[n] = this.totalErrors[n] + stats2.totalErrors[i];
        }
        if (stats2.hasPackageStats) {
            this.hasPackageStats = true;
        }
        if (stats2.hasClassStats) {
            this.hasClassStats = true;
        }
        for (Map.Entry<String, PackageStats> entry : stats2.packageStatsMap.entrySet()) {
            String key = entry.getKey();
            PackageStats pkgStats2 = entry.getValue();
            if (this.packageStatsMap.containsKey(key)) {
                PackageStats pkgStats = (PackageStats)this.packageStatsMap.get(key);
                for (PackageStats.ClassStats classStats : pkgStats2.getClassStats()) {
                    pkgStats.addClass(classStats, true);
                }
                continue;
            }
            this.packageStatsMap.put(key, pkgStats2);
        }
    }

    public void setReferencedClasses(int size) {
        this.referencedClasses = size;
    }

    public int getReferencedClasses() {
        return this.referencedClasses;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public void setTotalClasses(int totalClasses) {
        this.totalClasses = totalClasses;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }
}

