/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationAcquiredOrReleasedInLoopException;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.StateSet;
import javax.annotation.Nullable;

public class ObligationPolicyDatabaseAction {
    private final ObligationPolicyDatabaseActionType actionType;
    private final Obligation obligation;
    public static final ObligationPolicyDatabaseAction CLEAR = new ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType.CLEAR, null);

    public ObligationPolicyDatabaseAction(ObligationPolicyDatabaseActionType actionType, @Nullable Obligation obligation) {
        this.actionType = actionType;
        this.obligation = obligation;
    }

    public ObligationPolicyDatabaseActionType getActionType() {
        return this.actionType;
    }

    public Obligation getObligation() {
        return this.obligation;
    }

    public void apply(StateSet stateSet, int basicBlockId) throws ObligationAcquiredOrReleasedInLoopException {
        switch (this.actionType) {
            case ADD: {
                stateSet.addObligation(this.obligation, basicBlockId);
                break;
            }
            case DEL: {
                stateSet.deleteObligation(this.obligation, basicBlockId);
                break;
            }
            case CLEAR: {
                stateSet.clear();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public String toString() {
        return "[" + (Object)((Object)this.actionType) + " " + this.obligation + "]";
    }
}

