/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Code;

public class WaitInLoop
extends BytecodeScanningDetector
implements StatelessDetector {
    boolean sawWait = false;
    boolean sawAwait = false;
    boolean waitHasTimeout = false;
    boolean sawNotify = false;
    int notifyPC;
    int earliestJump = 0;
    int waitAt = 0;
    private final BugReporter bugReporter;

    public WaitInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.sawWait = false;
        this.sawAwait = false;
        this.waitHasTimeout = false;
        this.sawNotify = false;
        this.earliestJump = 9999999;
        super.visit(obj);
        if ((this.sawWait || this.sawAwait) && this.waitAt < this.earliestJump) {
            String bugType = this.sawWait ? "WA_NOT_IN_LOOP" : "WA_AWAIT_NOT_IN_LOOP";
            this.bugReporter.reportBug(new BugInstance(this, bugType, this.waitHasTimeout ? 3 : 2).addClassAndMethod(this).addSourceLine(this, this.waitAt));
        }
        if (this.sawNotify) {
            this.bugReporter.reportBug(new BugInstance(this, "NO_NOTIFY_NOT_NOTIFYALL", 3).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if ((seen == 182 || seen == 185) && "notify".equals(this.getNameConstantOperand()) && "()V".equals(this.getSigConstantOperand())) {
            this.sawNotify = true;
            this.notifyPC = this.getPC();
        }
        if (!(this.sawWait || this.sawAwait || seen != 182 && seen != 185 || !this.isMonitorWait() && !this.isConditionAwait())) {
            if ("wait".equals(this.getNameConstantOperand())) {
                this.sawWait = true;
            } else {
                this.sawAwait = true;
            }
            this.waitHasTimeout = !"()V".equals(this.getSigConstantOperand());
            this.waitAt = this.getPC();
            this.earliestJump = this.getPC() + 1;
            return;
        }
        if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
            this.earliestJump = Math.min(this.earliestJump, this.getBranchTarget());
        }
    }

    private boolean isConditionAwait() {
        String className = this.getClassConstantOperand();
        String name = this.getNameConstantOperand();
        String sig = this.getSigConstantOperand();
        if (!"java/util/concurrent/locks/Condition".equals(className)) {
            return false;
        }
        if (!name.startsWith("await")) {
            return false;
        }
        if ("await".equals(name) && ("()V".equals(sig) || "(JLjava/util/concurrent/TimeUnit;)V".equals(sig))) {
            return true;
        }
        if ("awaitNanos".equals(name) && "(J)V".equals(sig)) {
            return true;
        }
        if ("awaitUninterruptibly".equals(name) && "()V".equals(sig)) {
            return true;
        }
        return "awaitUntil".equals(name) && "(Ljava/util/Date;)V".equals(sig);
    }

    private boolean isMonitorWait() {
        String name = this.getNameConstantOperand();
        String sig = this.getSigConstantOperand();
        return "wait".equals(name) && ("()V".equals(sig) || "(J)V".equals(sig) || "(JI)V".equals(sig));
    }
}

