/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.props;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.props.PriorityAdjustment;
import edu.umd.cs.findbugs.props.WarningProperty;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public class WarningPropertySet<T extends WarningProperty>
implements Cloneable {
    private final Map<T, Object> map = new HashMap<T, Object>();

    public String toString() {
        StringBuilder buf = new StringBuilder("{ ");
        for (Map.Entry<T, Object> entry : this.map.entrySet()) {
            WarningProperty prop = (WarningProperty)entry.getKey();
            Object attribute = entry.getValue();
            buf.append("  ");
            buf.append(prop.getPriorityAdjustment());
            buf.append("\t");
            buf.append(prop.getName());
            buf.append("\t");
            buf.append(attribute);
            buf.append("\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public WarningPropertySet<T> addProperty(T prop) {
        this.map.put(prop, Boolean.TRUE);
        return this;
    }

    public WarningPropertySet<T> removeProperty(T prop) {
        this.map.remove(prop);
        return this;
    }

    public WarningPropertySet<T> setProperty(T prop, String value) {
        this.map.put(prop, value);
        return this;
    }

    public void setProperty(T prop, Boolean value) {
        this.map.put(prop, value);
    }

    @CheckReturnValue
    public boolean containsProperty(T prop) {
        return this.map.keySet().contains(prop);
    }

    public boolean checkProperty(T prop, Object value) {
        Object attribute = this.getProperty(prop);
        return attribute != null && attribute.equals(value);
    }

    public Object getProperty(T prop) {
        return this.map.get(prop);
    }

    public int computePriority(int basePriority) {
        boolean relaxedReporting = FindBugsAnalysisFeatures.isRelaxedMode();
        boolean atLeastMedium = false;
        boolean falsePositive = false;
        boolean atMostLow = false;
        boolean atMostMedium = false;
        boolean peggedHigh = false;
        int aLittleBitLower = 0;
        int priority = basePriority;
        if (!relaxedReporting) {
            for (WarningProperty warningProperty : this.map.keySet()) {
                PriorityAdjustment adj = warningProperty.getPriorityAdjustment();
                if (adj == PriorityAdjustment.PEGGED_HIGH) {
                    peggedHigh = true;
                    --priority;
                    continue;
                }
                if (adj == PriorityAdjustment.FALSE_POSITIVE) {
                    falsePositive = true;
                    atMostLow = true;
                    continue;
                }
                if (adj == PriorityAdjustment.A_LITTLE_BIT_LOWER_PRIORITY) {
                    ++aLittleBitLower;
                    continue;
                }
                if (adj == PriorityAdjustment.A_LITTLE_BIT_HIGHER_PRIORITY) {
                    --aLittleBitLower;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY) {
                    --priority;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY_TO_AT_LEAST_NORMAL) {
                    --priority;
                    atLeastMedium = true;
                    continue;
                }
                if (adj == PriorityAdjustment.LOWER_PRIORITY_TO_AT_MOST_NORMAL) {
                    ++priority;
                    atMostMedium = true;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY_TO_HIGH) {
                    return 1;
                }
                if (adj == PriorityAdjustment.LOWER_PRIORITY) {
                    ++priority;
                    continue;
                }
                if (adj == PriorityAdjustment.AT_MOST_LOW) {
                    ++priority;
                    atMostLow = true;
                    continue;
                }
                if (adj == PriorityAdjustment.AT_MOST_MEDIUM) {
                    atMostMedium = true;
                    continue;
                }
                if (adj == PriorityAdjustment.NO_ADJUSTMENT) continue;
                throw new IllegalStateException("Unknown priority " + adj);
            }
            if (peggedHigh && !falsePositive) {
                return 1;
            }
            if (aLittleBitLower >= 3 || priority == 1 && aLittleBitLower == 2) {
                ++priority;
            } else if (aLittleBitLower <= -2) {
                --priority;
            }
            if (atMostMedium) {
                priority = Math.max(2, priority);
            }
            if (falsePositive && !atLeastMedium) {
                return 5;
            }
            if (atMostLow) {
                return Math.min(Math.max(3, priority), 4);
            }
            if (atLeastMedium && priority > 2) {
                priority = 2;
            }
            if (priority < 1) {
                priority = 1;
            } else if (priority > 4) {
                priority = 4;
            }
        }
        return priority;
    }

    public boolean isFalsePositive(int priority) {
        return priority > 4;
    }

    public void decorateBugInstance(BugInstance bugInstance) {
        int priority = this.computePriority(bugInstance.getPriority());
        bugInstance.setPriority(priority);
        for (Map.Entry<T, Object> entry : this.map.entrySet()) {
            WarningProperty prop = (WarningProperty)entry.getKey();
            Object attribute = entry.getValue();
            if (attribute == null) {
                attribute = "";
            }
            bugInstance.setProperty(prop.getName(), attribute.toString());
        }
    }
}

